<?php

/**
 * GENERAL
 */

	// Alert message
	if ( ! function_exists( 'lsvr_bluecollar_the_alert_message' ) ) {
		function lsvr_bluecollar_the_alert_message( $message ) {

			echo '<p class="c-alert-message">' . esc_html( $message ) . '</p>';

		}
	}

 	// Post terms
	if ( ! function_exists( 'lsvr_bluecollar_the_post_terms' ) ) {
		function lsvr_bluecollar_the_post_terms( $post_id, $taxonomy, $template = '%s', $separator = ', ', $limit = 0 ) {

			if ( 'post_tag' === $taxonomy && true === apply_filters( 'lsvr_bluecollar_the_post_terms_the_tags_enable', false ) ) {
				the_tags();
			}

			else {

				$terms = wp_get_object_terms( $post_id, $taxonomy );
				$terms_parsed = array();
				if ( ! empty( $terms ) ) {
					foreach ( $terms as $term ) {
						array_push( $terms_parsed, '<a href="' . esc_url( get_term_link( $term->term_id, $taxonomy ) ) . '" class="post__term-link">' . esc_html( $term->name ) . '</a>' );
					}
					if ( $limit > 0 && count( $terms_parsed ) > $limit ) {
						$terms_parsed = array_slice( $terms_parsed, 0, $limit );
					}
				}

				if ( ! empty( $terms_parsed ) ) { ?>

					<span class="post__terms post__terms--<?php echo esc_attr( $taxonomy ); ?>">
						<?php echo sprintf( $template, implode( $separator, $terms_parsed ) ); ?>
					</span>

				<?php }

			}

		}
	}


/**
 * HEADER
 */

	// Header class
	if ( ! function_exists( 'lsvr_bluecollar_the_header_class' ) ) {
		function lsvr_bluecollar_the_header_class( $class = '' ) {

			$class_arr = ! empty( $class ) ? explode( ' ', $class ) : array();

			// Check if sticky
			if ( true === get_theme_mod( 'header_sticky_enable', false ) ) {
				array_push( $class_arr, 'header--sticky' );
			}

			// Filter
			if ( ! empty( apply_filters( 'lsvr_bluecollar_header_class', '' ) ) ) {
				array_push( $class_arr, apply_filters( 'lsvr_bluecollar_header_class', '' ) );
			}

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}


/**
 * CORE
 */

	// Core class
	if ( ! function_exists( 'lsvr_bluecollar_core_class' ) ) {
		function lsvr_bluecollar_core_class( $class = '' ) {

			$class_arr = ! empty( $class ) ? explode( ' ', $class ) : array();

			// Narrow layout
			if ( true === apply_filters( 'lsvr_bluecollar_narrow_layout_enable', false ) ) {
				array_push( $class_arr, 'core--narrow' );
			}

			// Filter
			if ( ! empty( apply_filters( 'lsvr_bluecollar_core_class', '' ) ) ) {
				array_push( $class_arr, apply_filters( 'lsvr_bluecollar_core_class', '' ) );
			}

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}

	// Page title class
	if ( ! function_exists( 'lsvr_bluecollar_the_page_title_class' ) ) {
		function lsvr_bluecollar_the_page_title_class( $class = '' ) {

			$class_arr = ! empty( $class ) ? explode( ' ', $class ) : array();
			array_push( $class_arr, 'page-title' );

			// Filter
			if ( ! empty( apply_filters( 'lsvr_bluecollar_page_title_class', '' ) ) ) {
				array_push( $class_arr, apply_filters( 'lsvr_bluecollar_page_title_class', '' ) );
			}

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}

	// Page title background
	if ( ! function_exists( 'lsvr_bluecollar_the_page_title_background_image' ) ) {
		function lsvr_bluecollar_the_page_title_background_image() {

			$image_url = apply_filters( 'lsvr_bluecollar_page_title_background_image_url', get_theme_mod( 'page_title_background_image', '' ) );
			if ( ! empty( $image_url ) ) {
				echo ' style="background-image: url( \'' . esc_url( $image_url ) . '\' );"';
			}

		}
	}

	// Page title overlay
	if ( ! function_exists( 'lsvr_bluecollar_the_page_title_overlay' ) ) {
		function lsvr_bluecollar_the_page_title_overlay() {

			$overlay_opacity = (int) get_theme_mod( 'page_title_background_overlay_opacity', 90 );
			if ( $overlay_opacity > 0 ) {
				$opacity_css = 'opacity: ' . $overlay_opacity / 100 . ';'; // For modern browsers
				$opacity_filter_css = 'filter: alpha(opacity=' . $overlay_opacity . ');'; // For IE
				echo '<div class="page-title__overlay" style="' . esc_attr( $opacity_css . ' ' . $opacity_filter_css ) . '"></div>';
			}

		}
	}

	// Blog Archive class
	if ( ! function_exists( 'lsvr_bluecollar_the_blog_post_archive_class' ) ) {
		function lsvr_bluecollar_the_blog_post_archive_class( $class = '' ) {

			// Defaults
			$class_arr = array( 'post-archive blog-post-archive' );

			// Passed
			if ( ! empty( $class ) ) {
				$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
			}

			// Masonry
			if ( 'grid' === get_theme_mod( 'blog_archive_layout', 'default' ) && true === get_theme_mod( 'blog_archive_masonry_enable', false ) ) {
				array_push( $class_arr, 'blog-post-archive--is-masonry' );
			}

			// Filter
			array_push( $class_arr, apply_filters( 'lsvr_bluecollar_blog_post_archive_class', '' ) );

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}

	// Archive list class
	if ( ! function_exists( 'lsvr_bluecollar_the_blog_post_archive_list_class' ) ) {
		function lsvr_bluecollar_the_blog_post_archive_list_class( $class = '' ) {

			// Defaults
			$class_arr = array( 'post-archive__list' );

			// Passed
			if ( ! empty( $class ) ) {
				$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
			}

			// Columns
			if ( 'grid' === get_theme_mod( 'blog_archive_layout', 'default' ) ) {
				$number_of_columns = ! empty( get_theme_mod( 'blog_archive_grid_columns', 3 ) ) ? (int) get_theme_mod( 'blog_archive_grid_columns', 3 ) : 3;
				$span = 12 / $number_of_columns;
				$md_cols = $span > 2 ? 2 : $span;
				$sm_cols = $span > 2 ? 2 : $span;
				array_push( $class_arr, 'lsvr-grid lsvr-grid--' . $number_of_columns . '-cols lsvr-grid--md-' . $md_cols . '-cols lsvr-grid--sm-' . $sm_cols . '-cols' );
			}

			// Filter
			array_push( $class_arr, apply_filters( 'lsvr_bluecollar_blog_post_archive_list_class', '' ) );

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}

	// Archive grid column class
	if ( ! function_exists( 'lsvr_bluecollar_the_blog_post_archive_grid_column_class' ) ) {
		function lsvr_bluecollar_the_blog_post_archive_grid_column_class( $class = '' ) {

			// Defaults
			$class_arr = array();

			// Passed
			if ( ! empty( $class ) ) {
				$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
			}

			// Columns
			$number_of_columns = (int) get_theme_mod( 'blog_archive_grid_columns', 3 ) > 0 ? (int) get_theme_mod( 'blog_archive_grid_columns', 3 ) : 3;
			$span = 12 / $number_of_columns;
			$span_md_class = 3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--md-span-6' : '';
			$span_sm_class = 3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--sm-span-6' : '';
			array_push( $class_arr, 'lsvr-grid__col lsvr-grid__col--span-' . $span . $span_md_class . $span_sm_class );

			// Filter
			array_push( $class_arr, apply_filters( 'lsvr_bluecollar_blog_post_archive_grid_column_class', '' ) );

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}



/**
 * FOOTER
 */

	// Footer class
	if ( ! function_exists( 'lsvr_bluecollar_the_footer_class' ) ) {
		function lsvr_bluecollar_the_footer_class( $class = '' ) {

			$class_arr = ! empty( $class ) ? explode( ' ', $class ) : array();

			// Filter
			if ( ! empty( apply_filters( 'lsvr_bluecollar_footer_class', '' ) ) ) {
				array_push( $class_arr, apply_filters( 'lsvr_bluecollar_footer_class', '' ) );
			}

			// Echo
			if ( ! empty( $class_arr ) ) {
				echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
			}

		}
	}

	// Footer background image
	if ( ! function_exists( 'lsvr_bluecollar_the_footer_background_image' ) ) {
		function lsvr_bluecollar_the_footer_background_image() {

			$image_url = get_theme_mod( 'footer_background_image', '' );
			if ( ! empty( $image_url )  ) {
				echo ' style="background-image: url( \'' . esc_url( $image_url ) . '\' );"';
			}

		}
	}

	// Footer background overlay
	if ( ! function_exists( 'lsvr_bluecollar_the_footer_overlay' ) ) {
		function lsvr_bluecollar_the_footer_overlay() {

			$overlay_opacity = (int) get_theme_mod( 'footer_background_overlay_opacity', 80 );
			if ( $overlay_opacity > 0 ) {
				$opacity_css = 'opacity: ' . $overlay_opacity / 100 . ';'; // For modern browsers
				$opacity_filter_css = 'filter: alpha(opacity=' . $overlay_opacity . ');'; // For IE
				echo '<div class="footer__overlay" style="' . esc_attr( $opacity_css . ' ' . $opacity_filter_css ) . '"></div>';
			}

		}
	}

	// Footer widgets grid class
	if ( ! function_exists( 'lsvr_bluecollar_the_footer_widgets_grid_class' ) ) {
		function lsvr_bluecollar_the_footer_widgets_grid_class() {

			$classes = array( 'lsvr-grid' );
			$columns = get_theme_mod( 'footer_widgets_columns', 3 );

			// Cols
			array_push( $classes, 'lsvr-grid--' . $columns . '-cols' );

			// Cols lg
			if ( $columns >= 2 ) {
				array_push( $classes, 'lsvr-grid--lg-2-cols' );
			}

			// Cols md
			if ( $columns >= 2 ) {
				array_push( $classes, 'lsvr-grid--md-2-cols' );
			}

			if ( ! empty( $classes ) ) {
				echo ' class="' . esc_attr( implode( ' ', $classes ) ) . '"';
			}

		}
	}

?>