<?php

/**
 * GENERAL
 */

	// Set current post type
	add_filter( 'lsvr_bluecollar_current_post_type', 'lsvr_bluecollar_faq_set_current_post_type' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_set_current_post_type' ) ) {
		function lsvr_bluecollar_faq_set_current_post_type( $post_type ) {

			if ( lsvr_bluecollar_is_faq() ) {
				return 'lsvr_faq';
			}
			return $post_type;

		}
	}

	// Document title
	add_filter( 'document_title_parts', 'lsvr_bluecollar_faq_document_title' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_document_title' ) ) {
		function lsvr_bluecollar_faq_document_title( $title ) {

			if ( is_post_type_archive( 'lsvr_faq' ) ) {
				$title['title'] = sanitize_text_field( lsvr_bluecollar_get_faq_archive_title() );
			}
			return $title;

		}
	}


/**
 * CORE
 */

	// Set narrow layout
	add_filter( 'lsvr_bluecollar_narrow_layout_enable', 'lsvr_bluecollar_faq_narrow_layout_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_narrow_layout_enable' ) ) {
		function lsvr_bluecollar_faq_narrow_layout_enable( $enable ) {

			if ( ( is_singular( 'lsvr_faq' ) && 'narrow' === get_theme_mod( 'lsvr_faq_single_layout', 'default' ) ) ||
				( lsvr_bluecollar_is_faq() && ! is_singular( 'lsvr_faq' ) && 'narrow' === get_theme_mod( 'lsvr_faq_archive_layout', 'default' ) ) ) {
				return true;
			}

			return $enable;

		}
	}

	// Page title
	add_filter( 'lsvr_bluecollar_page_title_title', 'lsvr_bluecollar_faq_page_title' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_page_title' ) ) {
		function lsvr_bluecollar_faq_page_title( $title ) {

			if ( is_post_type_archive( 'lsvr_faq' ) ) {
				return lsvr_bluecollar_get_faq_archive_title();
			} elseif ( is_tax( 'lsvr_faq_tag' ) ) {
				return sprintf( esc_html__( 'Tag: %s', 'bluecollar' ), single_term_title( '', false ) );
			}

			return $title;

		}
	}

	// Breadcrumbs
	add_filter( 'lsvr_bluecollar_add_to_breadcrumbs', 'lsvr_bluecollar_faq_breadcrumbs' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_breadcrumbs' ) ) {
		function lsvr_bluecollar_faq_breadcrumbs( $breadcrumbs ) {

			if ( lsvr_bluecollar_is_faq() && ! is_post_type_archive( 'lsvr_faq' ) ) {
				return array(
					array(
						'url' => get_post_type_archive_link( 'lsvr_faq' ),
						'label' => lsvr_bluecollar_get_faq_archive_title(),
					),
				);
			}
			return $breadcrumbs;

		}
	}

	// Archive intro title
	add_filter( 'lsvr_bluecollar_post_archive_intro_title', 'lsvr_bluecollar_faq_archive_intro_title' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_archive_intro_title' ) ) {
		function lsvr_bluecollar_faq_archive_intro_title( $title ) {

			if ( lsvr_bluecollar_is_faq() && ! empty( get_theme_mod( 'lsvr_faq_archive_intro_title', '' ) ) ) {
				$title = get_theme_mod( 'lsvr_faq_archive_intro_title', '' );
			}

			return $title;

		}
	}

	// Archive intro text
	add_filter( 'lsvr_bluecollar_post_archive_intro_text', 'lsvr_bluecollar_faq_archive_intro_text' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_archive_intro_text' ) ) {
		function lsvr_bluecollar_faq_archive_intro_text( $text ) {

			if ( lsvr_bluecollar_is_faq() && ! empty( get_theme_mod( 'lsvr_faq_archive_intro_text', '' ) ) ) {
				$text = get_theme_mod( 'lsvr_faq_archive_intro_text', '' );
			}

			if ( is_tax( 'lsvr_faq_cat' ) && ! empty( term_description( get_queried_object()->term_id, 'lsvr_faq_cat' ) ) ) {
				$text = term_description( get_queried_object()->term_id, 'lsvr_faq_cat' );
			}

			return $text;

		}
	}

	// Archive pre_get_posts actions
	add_action( 'pre_get_posts', 'lsvr_bluecollar_faq_archive_pre_get_posts' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_archive_pre_get_posts' ) ) {
		function lsvr_bluecollar_faq_archive_pre_get_posts( $query ) {

			if ( ! is_admin() && $query->is_main_query() && ( $query->is_post_type_archive( 'lsvr_faq' ) ||
				$query->is_tax( 'lsvr_faq_cat' ) || $query->is_tax( 'lsvr_faq_tag' ) ) ) {

				// Posts per page
				if ( 0 === (int) get_theme_mod( 'lsvr_faq_archive_posts_per_page', 12 ) ) {
					$query->set( 'posts_per_page', 1000 );
				} else {
					$query->set( 'posts_per_page', esc_attr( get_theme_mod( 'lsvr_faq_archive_posts_per_page', 12 ) ) );
				}

				// Order
				if ( 'date_desc' == get_theme_mod( 'lsvr_faq_archive_order', 'default' ) ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'date_asc' == get_theme_mod( 'lsvr_faq_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'title_asc' == get_theme_mod( 'lsvr_faq_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'title_desc' == get_theme_mod( 'lsvr_faq_archive_order', 'default' )  ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'random' == get_theme_mod( 'lsvr_faq_archive_order', 'default' )  ) {
					$query->set( 'orderby', 'rand' );
				}

			}

		}
	}

	// Enable archive categories
	add_filter( 'lsvr_bluecollar_post_archive_categories_enable', 'lsvr_bluecollar_faq_archive_categories_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_archive_categories_enable' ) ) {
		function lsvr_bluecollar_faq_archive_categories_enable( $enabled ) {

			if ( lsvr_bluecollar_is_faq() && true === get_theme_mod( 'lsvr_faq_archive_categories_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Get categories taxonomy
	add_filter( 'lsvr_bluecollar_post_archive_categories_taxonomy', 'lsvr_bluecollar_faq_archive_categories_taxonomy' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_archive_categories_taxonomy' ) ) {
		function lsvr_bluecollar_faq_archive_categories_taxonomy( $taxonomy ) {

			if ( lsvr_bluecollar_is_faq() ) {
				return 'lsvr_faq_cat';
			}

			return $taxonomy;

		}
	}

	// Make posts on archive expandable
	add_filter( 'lsvr_bluecollar_faq_post_archive_class', 'lsvr_bluecollar_faq_archive_expandable_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_archive_expandable_enable' ) ) {
		function lsvr_bluecollar_faq_archive_expandable_enable( $class ) {

			if ( lsvr_bluecollar_is_faq() && true === get_theme_mod( 'lsvr_faq_archive_expandable_enable', true ) ) {
				return 'lsvr_faq-post-archive--is-expandable';
			}

			return $class;

		}
	}

	// Enable single post single navigation
	add_filter( 'lsvr_bluecollar_post_single_navigation_enable', 'lsvr_bluecollar_faq_single_post_navigation_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_single_post_navigation_enable' ) ) {
		function lsvr_bluecollar_faq_single_post_navigation_enable( $enabled ) {

			if ( lsvr_bluecollar_is_faq() && true === get_theme_mod( 'lsvr_faq_single_navigation_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Sidebar position
	add_filter( 'lsvr_bluecollar_sidebar_position', 'lsvr_bluecollar_faq_sidebar_position' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_sidebar_position' ) ) {
		function lsvr_bluecollar_faq_sidebar_position( $sidebar_position ) {

			// Is single
			if ( is_singular( 'lsvr_faq' ) ) {
				return get_theme_mod( 'lsvr_faq_single_sidebar_position', 'disable' );
			}

			// Is archive
			elseif ( lsvr_bluecollar_is_faq() ) {
				return get_theme_mod( 'lsvr_faq_archive_sidebar_position', 'disable' );
			}

			return $sidebar_position;

		}
	}

	// Sidebar ID
	add_filter( 'lsvr_bluecollar_sidebar_id', 'lsvr_bluecollar_faq_sidebar_id' );
	if ( ! function_exists( 'lsvr_bluecollar_faq_sidebar_id' ) ) {
		function lsvr_bluecollar_faq_sidebar_id( $sidebar_id ) {

			// Is single
			if ( is_singular( 'lsvr_faq' ) ) {
				return get_theme_mod( 'lsvr_faq_single_sidebar_id' );
			}

			// Is archive
			elseif ( lsvr_bluecollar_is_faq() ) {
				return get_theme_mod( 'lsvr_faq_archive_sidebar_id' );
			}

			return $sidebar_id;

		}
	}

?>