<?php

/**
 * GENERAL
 */

	// Set current post type
	add_filter( 'lsvr_bluecollar_current_post_type', 'lsvr_bluecollar_gallery_set_current_post_type' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_set_current_post_type' ) ) {
		function lsvr_bluecollar_gallery_set_current_post_type( $post_type ) {

			if ( lsvr_bluecollar_is_gallery() ) {
				return 'lsvr_gallery';
			}
			return $post_type;

		}
	}

	// Document title
	add_filter( 'document_title_parts', 'lsvr_bluecollar_gallery_document_title' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_document_title' ) ) {
		function lsvr_bluecollar_gallery_document_title( $title ) {

			if ( is_post_type_archive( 'lsvr_gallery' ) ) {
				$title['title'] = sanitize_text_field( lsvr_bluecollar_get_gallery_archive_title() );
			}
			return $title;

		}
	}

	// Load gallery JS files
	add_action( 'lsvr_bluecollar_load_assets', 'lsvr_bluecollar_gallery_load_js' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_load_js' ) ) {
		function lsvr_bluecollar_gallery_load_js() {

			// Masonry
			if ( is_singular( 'lsvr_gallery' ) ) {
				wp_enqueue_script( 'masonry' );
			}

		}
	}


/**
 * CORE
 */

	// Page title
	add_filter( 'lsvr_bluecollar_page_title_title', 'lsvr_bluecollar_gallery_page_title' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_page_title' ) ) {
		function lsvr_bluecollar_gallery_page_title( $title ) {

			if ( is_post_type_archive( 'lsvr_gallery' ) ) {
				return lsvr_bluecollar_get_gallery_archive_title();
			} elseif ( is_tax( 'lsvr_gallery_tag' ) ) {
				return sprintf( esc_html__( 'Tag: %s', 'bluecollar' ), single_term_title( '', false ) );
			}

			return $title;

		}
	}

	// Breadcrumbs
	add_filter( 'lsvr_bluecollar_add_to_breadcrumbs', 'lsvr_bluecollar_gallery_breadcrumbs' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_breadcrumbs' ) ) {
		function lsvr_bluecollar_gallery_breadcrumbs( $breadcrumbs ) {

			if ( lsvr_bluecollar_is_gallery() && ! is_post_type_archive( 'lsvr_gallery' ) ) {
				return array(
					array(
						'url' => get_post_type_archive_link( 'lsvr_gallery' ),
						'label' => lsvr_bluecollar_get_gallery_archive_title(),
					),
				);
			}
			return $breadcrumbs;

		}
	}

	// Archive intro title
	add_filter( 'lsvr_bluecollar_post_archive_intro_title', 'lsvr_bluecollar_gallery_archive_intro_title' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_archive_intro_title' ) ) {
		function lsvr_bluecollar_gallery_archive_intro_title( $title ) {

			if ( lsvr_bluecollar_is_gallery() && ! empty( get_theme_mod( 'lsvr_gallery_archive_intro_title', '' ) ) ) {
				$title = get_theme_mod( 'lsvr_gallery_archive_intro_title', '' );
			}

			return $title;

		}
	}

	// Archive intro text
	add_filter( 'lsvr_bluecollar_post_archive_intro_text', 'lsvr_bluecollar_gallery_archive_intro_text' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_archive_intro_text' ) ) {
		function lsvr_bluecollar_gallery_archive_intro_text( $text ) {

			if ( lsvr_bluecollar_is_gallery() && ! empty( get_theme_mod( 'lsvr_gallery_archive_intro_text', '' ) ) ) {
				$text = get_theme_mod( 'lsvr_gallery_archive_intro_text', '' );
			}

			if ( is_tax( 'lsvr_gallery_cat' ) && ! empty( term_description( get_queried_object()->term_id, 'lsvr_gallery_cat' ) ) ) {
				$text = term_description( get_queried_object()->term_id, 'lsvr_gallery_cat' );
			}

			return $text;

		}
	}

	// Archive pre_get_posts actions
	add_action( 'pre_get_posts', 'lsvr_bluecollar_gallery_archive_pre_get_posts' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_archive_pre_get_posts' ) ) {
		function lsvr_bluecollar_gallery_archive_pre_get_posts( $query ) {

			if ( ! is_admin() && $query->is_main_query() && ( $query->is_post_type_archive( 'lsvr_gallery' ) ||
				$query->is_tax( 'lsvr_gallery_cat' ) || $query->is_tax( 'lsvr_gallery_tag' ) ) ) {

				// Posts per page
				if ( 0 === (int) get_theme_mod( 'lsvr_gallery_archive_posts_per_page', 12 ) ) {
					$query->set( 'posts_per_page', 1000 );
				} else {
					$query->set( 'posts_per_page', esc_attr( get_theme_mod( 'lsvr_gallery_archive_posts_per_page', 12 ) ) );
				}

				// Order
				if ( 'date_desc' == get_theme_mod( 'lsvr_gallery_archive_order', 'default' ) ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'date_asc' == get_theme_mod( 'lsvr_gallery_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'title_asc' == get_theme_mod( 'lsvr_gallery_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'title_desc' == get_theme_mod( 'lsvr_gallery_archive_order', 'default' )  ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'random' == get_theme_mod( 'lsvr_gallery_archive_order', 'default' )  ) {
					$query->set( 'orderby', 'rand' );
				}

			}

		}
	}

	// Enable archive categories
	add_filter( 'lsvr_bluecollar_post_archive_categories_enable', 'lsvr_bluecollar_gallery_archive_categories_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_archive_categories_enable' ) ) {
		function lsvr_bluecollar_gallery_archive_categories_enable( $enabled ) {

			if ( lsvr_bluecollar_is_gallery() && true === get_theme_mod( 'lsvr_gallery_archive_categories_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Get categories taxonomy
	add_filter( 'lsvr_bluecollar_post_archive_categories_taxonomy', 'lsvr_bluecollar_gallery_archive_categories_taxonomy' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_archive_categories_taxonomy' ) ) {
		function lsvr_bluecollar_gallery_archive_categories_taxonomy( $taxonomy ) {

			if ( lsvr_bluecollar_is_gallery() ) {
				return 'lsvr_gallery_cat';
			}

			return $taxonomy;

		}
	}

	// Enable single post single navigation
	add_filter( 'lsvr_bluecollar_post_single_navigation_enable', 'lsvr_bluecollar_gallery_single_post_navigation_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_single_post_navigation_enable' ) ) {
		function lsvr_bluecollar_gallery_single_post_navigation_enable( $enabled ) {

			if ( lsvr_bluecollar_is_gallery() && true === get_theme_mod( 'lsvr_gallery_single_navigation_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Sidebar position
	add_filter( 'lsvr_bluecollar_sidebar_position', 'lsvr_bluecollar_gallery_sidebar_position' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_sidebar_position' ) ) {
		function lsvr_bluecollar_gallery_sidebar_position( $sidebar_position ) {

			// Is gallery single
			if ( is_singular( 'lsvr_gallery' ) ) {
				return get_theme_mod( 'lsvr_gallery_single_sidebar_position', 'disable' );
			}

			// Is gallery archive
			elseif ( lsvr_bluecollar_is_gallery() ) {
				return get_theme_mod( 'lsvr_gallery_archive_sidebar_position', 'disable' );
			}

			return $sidebar_position;

		}
	}

	// Sidebar ID
	add_filter( 'lsvr_bluecollar_sidebar_id', 'lsvr_bluecollar_gallery_sidebar_id' );
	if ( ! function_exists( 'lsvr_bluecollar_gallery_sidebar_id' ) ) {
		function lsvr_bluecollar_gallery_sidebar_id( $sidebar_id ) {

			// Is gallery single
			if ( is_singular( 'lsvr_gallery' ) ) {
				return get_theme_mod( 'lsvr_gallery_single_sidebar_id' );
			}

			// Is gallery archive
			elseif ( lsvr_bluecollar_is_gallery() ) {
				return get_theme_mod( 'lsvr_gallery_archive_sidebar_id' );
			}

			return $sidebar_id;

		}
	}


/**
 * META DATA
 */

	// Add post meta data
	add_action( 'lsvr_bluecollar_gallery_single_bottom', 'lsvr_bluecollar_add_gallery_single_meta' );
	if ( ! function_exists( 'lsvr_bluecollar_add_gallery_single_meta' ) ) {
		function lsvr_bluecollar_add_gallery_single_meta() { ?>

			<script type="application/ld+json">
			{
				"@context" : "http://schema.org",
				"@type" : "ImageGallery",
				"headline": "<?php echo esc_js( get_the_title() ); ?>",
				"url" : "<?php echo esc_url( get_permalink() ); ?>",
				"mainEntityOfPage" : "<?php echo esc_url( get_permalink() ); ?>",
			 	"datePublished": "<?php echo esc_js( get_the_time( 'c' ) ); ?>",
			 	"dateModified": "<?php echo esc_js( get_the_modified_date( 'c' ) ); ?>",
			 	"description": "<?php echo esc_js( get_the_excerpt() ); ?>",
			 	"author": {
			 		"@type" : "person",
			 		"name" : "<?php echo esc_js( get_the_author() ); ?>",
			 		"url" : "<?php esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"
			 	},
			 	"publisher" : {
			 		"@id" : "<?php echo esc_url( home_url() ); ?>#WebSitePublisher"
			 	}

			 	<?php if ( lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_gallery_tag' ) ) : ?>
				,"keywords": "<?php echo esc_js( implode( ',', lsvr_bluecollar_get_post_term_names( get_the_ID(), 'lsvr_gallery_tag' ) ) ); ?>"
			 	<?php endif; ?>

				<?php if ( has_post_thumbnail() ) : ?>
			 	,"image": {
			 		"@type" : "ImageObject",
			 		"url" : "<?php the_post_thumbnail_url( 'full' ); ?>",
			 		"width" : "<?php echo esc_js( lsvr_bluecollar_get_image_width( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"height" : "<?php echo esc_js( lsvr_bluecollar_get_image_height( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"thumbnailUrl" : "<?php the_post_thumbnail_url( 'thumbnail' ); ?>"
			 	}
			 	<?php endif; ?>

			 	<?php if ( lsvr_bluecollar_has_gallery_images( get_the_ID() ) ) : ?>
			 		,"associatedMedia" : [
			 		<?php $i = 1; foreach ( lsvr_bluecollar_get_gallery_images( get_the_ID() ) as $image ) : ?>
						{
				 			"@type" : "ImageObject",
				 			"url" : "<?php echo esc_url( $image['full_url'] ); ?>",
				 			"width" : "<?php echo esc_js( $image['full_width'] ); ?>",
				 			"height" : "<?php echo esc_js( $image['full_height'] ); ?>",
				 			"thumbnailUrl" : "<?php echo esc_url( $image['thumb_url'] ); ?>"
				 		}<?php if ( $i < count( lsvr_bluecollar_get_gallery_images( get_the_ID() ) ) ) { echo ','; } ?>
			 		<?php $i++; endforeach; ?>
			 		]
			 	<?php endif; ?>

			}
			</script>

		<?php }
	}

?>