<?php

add_action( 'customize_register', 'lsvr_bluecollar_galleries_customize_register' );
if ( ! function_exists( 'lsvr_bluecollar_galleries_customize_register' ) ) {
    function lsvr_bluecollar_galleries_customize_register( $wp_customize ) {
        if ( class_exists( 'Lsvr_Customizer' ) ) {

            $lsvr_customizer = new Lsvr_Customizer( $wp_customize, 'lsvr_bluecollar_' );

            $lsvr_customizer->add_section( 'lsvr_gallery_settings', array(
                'title' => esc_html__( 'Galleries', 'bluecollar' ),
                'priority' => 150,
            ));

                // Archive settings
                $lsvr_customizer->add_info( 'lsvr_gallery_archive_info', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Archive Settings', 'bluecollar' ),
                    'description' => esc_html__( 'The following settings apply to post archive page. You can change your default post archive URL under Settings / Permalinks. Scroll down for post detail page settings.', 'bluecollar' ),
                    'priority' => 1005,
                ));

                // Title
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_title', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Gallery Archive Title', 'bluecollar' ),
                    'description' => esc_html__( 'This title will be used as the archive page headline and in breadcrumbs.', 'bluecollar' ),
                    'type' => 'text',
                    'default' => esc_html__( 'Galleries', 'bluecollar' ),
                    'priority' => 1010,
                ));

                // Intro title
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_intro_title', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Gallery Archive Intro Title', 'bluecollar' ),
                    'description' => esc_html__( 'Title of the intro section displayed right above the gallery post list. Leave blank to hide.', 'bluecollar' ),
                    'type' => 'text',
                    'default' => '',
                    'priority' => 1020,
                ));

                // Intro text
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_intro_text', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Gallery Archive Intro Text', 'bluecollar' ),
                    'description' => esc_html__( 'Content of the intro section displayed right above the gallery post list. Leave blank to hide.', 'bluecollar' ),
                    'type' => 'textarea',
                    'default' => '',
                    'priority' => 1030,
                ));

                // Archive posts per page
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_posts_per_page', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Posts Per Page', 'bluecollar' ),
                    'description' => esc_html__( 'How many gallery posts should be displayed per page. Set to 0 to display all.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ),
                    'default' => 12,
                    'priority' => 1040,
                ));

                // Archive grid columns
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_grid_columns', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Number of Columns on Archive', 'bluecollar' ),
                    'description' => esc_html__( 'Separate archive page layout into several columns.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'default' => 3,
                    'priority' => 1050,
                ));

                // Archive order
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_order', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Archive Order', 'bluecollar' ),
                    'description' => esc_html__( 'Change the posts order. Leave it on Default if you want to use 3rd party plugin to set the order.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'bluecollar' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'bluecollar' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'bluecollar' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'bluecollar' ),
                        'title_desc' => esc_html__( 'By title, descending', 'bluecollar' ),
                        'random' => esc_html__( 'Random', 'bluecollar' ),
                    ),
                    'default' => 'default',
                    'priority' => 1060,
                ));

                // Enable categories
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_categories_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Display Archive Categories', 'bluecollar' ),
                    'description' => esc_html__( 'Display links to gallery categories at the top of the archive page.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1130,
                ));

                // Enable archive date
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_date_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Display Date on Archive', 'bluecollar' ),
                    'description' => esc_html__( 'Display the gallery post date on post archive.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1140,
                ));

                // Enable archive images count
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_image_count_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Display Image Count on Archive', 'bluecollar' ),
                    'description' => esc_html__( 'Display the number of gallery images on post archive.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1150,
                ));

                // Archive sidebar position
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_sidebar_position', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Archive Sidebar Position', 'bluecollar' ),
                    'description' => esc_html__( 'Change the gallery post archive sidebar position.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'bluecollar' ),
                        'left' => esc_html__( 'Left', 'bluecollar' ),
                        'right' => esc_html__( 'Right', 'bluecollar' ),
                    ),
                    'default' => 'disable',
                    'priority' => 1500,
                ));

                // Archive sidebar ID
                $lsvr_customizer->add_field( 'lsvr_gallery_archive_sidebar_id', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Archive Sidebar', 'bluecollar' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => lsvr_bluecollar_get_sidebars(),
                    'priority' => 1510,
                    'required' => array(
                        'setting' => 'lsvr_gallery_archive_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

                // Separator
                $lsvr_customizer->add_separator( 'lsvr_gallery_separator_2', array(
                    'section' => 'lsvr_gallery_settings',
                    'priority' => 2000,
                ));

                // Detail settings
                $lsvr_customizer->add_info( 'lsvr_gallery_single_info', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Detail Settings', 'bluecollar' ),
                    'description' => esc_html__( 'The following settings apply to post detail pages.', 'bluecollar' ),
                    'priority' => 2005,
                ));

                // Single grid columns
                $lsvr_customizer->add_field( 'lsvr_gallery_single_grid_columns', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Number of Columns on Detail', 'bluecollar' ),
                    'description' => esc_html__( 'Separate detail page layout into several columns.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'default' => 3,
                    'priority' => 2010,
                ));

                // Enable detail date
                $lsvr_customizer->add_field( 'lsvr_gallery_single_date_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Display Date on Detail', 'bluecollar' ),
                    'description' => esc_html__( 'Display the gallery post date on post detail.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2020,
                ));

                // Enable post detail navigation
                $lsvr_customizer->add_field( 'lsvr_gallery_single_navigation_enable', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Enable Gallery Detail Navigation', 'bluecollar' ),
                    'description' => esc_html__( 'Display links to previous and next posts at the bottom of the current gallery.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2030,
                ));

                // Single sidebar position
                $lsvr_customizer->add_field( 'lsvr_gallery_single_sidebar_position', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Detail Sidebar Position', 'bluecollar' ),
                    'description' => esc_html__( 'Change the gallery post detail sidebar position.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'bluecollar' ),
                        'left' => esc_html__( 'Left', 'bluecollar' ),
                        'right' => esc_html__( 'Right', 'bluecollar' ),
                    ),
                    'default' => 'disable',
                    'priority' => 2040,
                ));

                // Single sidebar ID
                $lsvr_customizer->add_field( 'lsvr_gallery_single_sidebar_id', array(
                    'section' => 'lsvr_gallery_settings',
                    'label' => esc_html__( 'Detail Sidebar', 'bluecollar' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => lsvr_bluecollar_get_sidebars(),
                    'priority' => 2050,
                    'required' => array(
                        'setting' => 'lsvr_gallery_single_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));
        }
    }
}

?>