<?php

// Archive class
if ( ! function_exists( 'lsvr_bluecollar_the_gallery_post_archive_class' ) ) {
	function lsvr_bluecollar_the_gallery_post_archive_class( $class = '' ) {

		// Defaults
		$class_arr = array( 'lsvr_gallery-post-page post-archive lsvr_gallery-post-archive' );

		// Passed
		if ( ! empty( $class ) ) {
			$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
		}

		// Filter
		array_push( $class_arr, apply_filters( 'lsvr_bluecollar_gallery_post_archive_class', '' ) );

		// Echo
		if ( ! empty( $class_arr ) ) {
			echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
		}

	}
}

// Archive list class
if ( ! function_exists( 'lsvr_bluecollar_the_gallery_post_archive_list_class' ) ) {
	function lsvr_bluecollar_the_gallery_post_archive_list_class( $class = '' ) {

		// Defaults
		$class_arr = array( 'post-archive__list' );

		// Passed
		if ( ! empty( $class ) ) {
			$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
		}

		// Columns
		$number_of_columns = ! empty( get_theme_mod( 'lsvr_gallery_archive_grid_columns', 3 ) ) ? (int) get_theme_mod( 'lsvr_gallery_archive_grid_columns', 3 ) : 3;
		$span = 12 / $number_of_columns;
		$md_cols = $span > 2 ? 2 : $span;
		$sm_cols = $span > 2 ? 2 : $span;
		array_push( $class_arr, 'lsvr-grid lsvr-grid--' . $number_of_columns . '-cols lsvr-grid--md-' . $md_cols . '-cols lsvr-grid--sm-' . $sm_cols . '-cols' );

		// Filter
		array_push( $class_arr, apply_filters( 'lsvr_bluecollar_gallery_post_archive_list_class', '' ) );

		// Echo
		if ( ! empty( $class_arr ) ) {
			echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
		}

	}
}

// Archive grid column class
if ( ! function_exists( 'lsvr_bluecollar_the_gallery_post_archive_grid_column_class' ) ) {
	function lsvr_bluecollar_the_gallery_post_archive_grid_column_class( $class = '' ) {

		// Defaults
		$class_arr = array();

		// Passed
		if ( ! empty( $class ) ) {
			$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
		}

		// Columns
		$number_of_columns = ! empty( get_theme_mod( 'lsvr_gallery_archive_grid_columns', 3 ) ) ? (int) get_theme_mod( 'lsvr_gallery_archive_grid_columns', 3 ) : 3;
		$span = 12 / $number_of_columns;
		$span_md_class = 3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--md-span-6' : '';
		$span_sm_class = 3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--sm-span-6' : '';
		array_push( $class_arr, 'lsvr-grid__col lsvr-grid__col--span-' . $span . $span_md_class . $span_sm_class );

		// Filter
		array_push( $class_arr, apply_filters( 'lsvr_bluecollar_gallery_post_archive_grid_column_class', '' ) );

		// Echo
		if ( ! empty( $class_arr ) ) {
			echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
		}

	}
}

// Post background thumbnail
if ( ! function_exists( 'lsvr_bluecollar_the_gallery_post_background_thumbnail' ) ) {
	function lsvr_bluecollar_the_gallery_post_background_thumbnail( $post_id ) {
		if ( function_exists( 'lsvr_galleries_get_single_thumb' ) ) {

			$thumbnail = lsvr_galleries_get_single_thumb( $post_id );
			if ( ! empty( $thumbnail ) ) {

				if ( get_theme_mod( 'lsvr_gallery_archive_grid_columns', 3 ) > 2 && ! empty( $thumbnail['medium_url'] ) ) {
					$image_url = $thumbnail['medium_url'];
				} else {
					$image_url = $thumbnail['full_url'];
				}

				if ( ! empty( $image_url ) ) {
					echo ' style="background-image: url( \'' . esc_url( $image_url ) . '\' );"';
				}

			}

		}
	}
}

// Single image class
if ( ! function_exists( 'lsvr_bluecollar_the_gallery_post_single_grid_column_class' ) ) {
	function lsvr_bluecollar_the_gallery_post_single_grid_column_class( $class = '' ) {

		// Defaults
		$class_arr = array();

		// Passed
		if ( ! empty( $class ) ) {
			$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
		}

		// Columns
		$number_of_columns = ! empty( get_theme_mod( 'lsvr_gallery_single_grid_columns', 3 ) ) ? (int) get_theme_mod( 'lsvr_gallery_single_grid_columns', 3 ) : 3;
		$span = 12 / $number_of_columns;
		$span_md_class = 3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--md lsvr-grid__col--md-span-6' : '';
		$span_sm_class = 3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--sm lsvr-grid__col--sm-span-6' : '';
		array_push( $class_arr, 'lsvr-grid__col lsvr-grid__col--span-' . $span . $span_md_class . $span_sm_class );

		// Filter
		array_push( $class_arr, apply_filters( 'lsvr_bluecollar_gallery_post_single_grid_column_class', '' ) );

		// Echo
		if ( ! empty( $class_arr ) ) {
			echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
		}

	}
}

?>