<?php

/**
 * GENERAL
 */

	// Set current post type
	add_filter( 'lsvr_bluecollar_current_post_type', 'lsvr_bluecollar_person_set_current_post_type' );
	if ( ! function_exists( 'lsvr_bluecollar_person_set_current_post_type' ) ) {
		function lsvr_bluecollar_person_set_current_post_type( $post_type ) {

			if ( lsvr_bluecollar_is_person() ) {
				return 'lsvr_person';
			}
			return $post_type;

		}
	}

	// Document title
	add_filter( 'document_title_parts', 'lsvr_bluecollar_person_document_title' );
	if ( ! function_exists( 'lsvr_bluecollar_person_document_title' ) ) {
		function lsvr_bluecollar_person_document_title( $title ) {

			if ( is_post_type_archive( 'lsvr_person' ) ) {
				$title['title'] = sanitize_text_field( lsvr_bluecollar_get_person_archive_title() );
			}
			return $title;

		}
	}

	// Load JS files
	add_action( 'lsvr_bluecollar_load_assets', 'lsvr_bluecollar_people_load_js' );
	if ( ! function_exists( 'lsvr_bluecollar_people_load_js' ) ) {
		function lsvr_bluecollar_people_load_js() {

			// Masonry
			if ( lsvr_bluecollar_is_person() && ! is_singular( 'lsvr_person' ) &&
				get_theme_mod( 'lsvr_person_archive_grid_columns', 2 ) > 1 &&
				true === get_theme_mod( 'lsvr_person_archive_masonry_enable', true ) ) {
				wp_enqueue_script( 'masonry' );
			}

		}
	}


/**
 * CORE
 */

	// Set narrow layout
	add_filter( 'lsvr_bluecollar_narrow_layout_enable', 'lsvr_bluecollar_person_single_narrow_layout_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_person_single_narrow_layout_enable' ) ) {
		function lsvr_bluecollar_person_single_narrow_layout_enable( $enable ) {

			if ( is_singular( 'lsvr_person' ) && 'narrow' === get_theme_mod( 'lsvr_person_single_layout', 'default' ) ) {
				return true;
			}

			return $enable;

		}
	}

	// Page title
	add_filter( 'lsvr_bluecollar_page_title_title', 'lsvr_bluecollar_person_page_title' );
	if ( ! function_exists( 'lsvr_bluecollar_person_page_title' ) ) {
		function lsvr_bluecollar_person_page_title( $title ) {

			if ( is_post_type_archive( 'lsvr_person' ) ) {
				return lsvr_bluecollar_get_person_archive_title();
			}

			return $title;

		}
	}

	// Page header subtitle
	add_filter( 'lsvr_bluecollar_page_title_subtitle', 'lsvr_bluecollar_person_single_subtitle' );
	if ( ! function_exists( 'lsvr_bluecollar_person_single_subtitle' ) ) {
		function lsvr_bluecollar_person_single_subtitle( $subtitle ) {

			if ( is_singular( 'lsvr_person' ) && lsvr_bluecollar_has_person_role( get_the_ID() ) ) {
				return lsvr_bluecollar_get_person_role( get_the_ID() );
			}

			return $subtitle;

		}
	}

	// Display person portrait in the page title
	add_action( 'lsvr_bluecollar_page_title_top', 'lsvr_bluecollar_page_title_person_portrait' );
	if ( ! function_exists( 'lsvr_bluecollar_page_title_person_portrait' ) ) {
		function lsvr_bluecollar_page_title_person_portrait() {

			if ( is_singular( 'lsvr_person' ) && has_post_thumbnail( get_the_ID() ) ) {
				get_template_part( 'template-parts/lsvr_person/page-title-portrait' );
			}

		}
	}

	// Breadcrumbs
	add_filter( 'lsvr_bluecollar_add_to_breadcrumbs', 'lsvr_bluecollar_person_breadcrumbs' );
	if ( ! function_exists( 'lsvr_bluecollar_person_breadcrumbs' ) ) {
		function lsvr_bluecollar_person_breadcrumbs( $breadcrumbs ) {

			if ( lsvr_bluecollar_is_person() && ! is_post_type_archive( 'lsvr_person' ) ) {
				return array(
					array(
						'url' => get_post_type_archive_link( 'lsvr_person' ),
						'label' => lsvr_bluecollar_get_person_archive_title(),
					),
				);
			}

			return $breadcrumbs;

		}
	}

	// Archive intro title
	add_filter( 'lsvr_bluecollar_post_archive_intro_title', 'lsvr_bluecollar_person_archive_intro_title' );
	if ( ! function_exists( 'lsvr_bluecollar_person_archive_intro_title' ) ) {
		function lsvr_bluecollar_person_archive_intro_title( $title ) {

			if ( lsvr_bluecollar_is_person() && ! empty( get_theme_mod( 'lsvr_person_archive_intro_title', '' ) ) ) {
				$title = get_theme_mod( 'lsvr_person_archive_intro_title', '' );
			}

			return $title;

		}
	}

	// Archive intro text
	add_filter( 'lsvr_bluecollar_post_archive_intro_text', 'lsvr_bluecollar_person_archive_intro_text' );
	if ( ! function_exists( 'lsvr_bluecollar_person_archive_intro_text' ) ) {
		function lsvr_bluecollar_person_archive_intro_text( $text ) {

			if ( lsvr_bluecollar_is_person() && ! empty( get_theme_mod( 'lsvr_person_archive_intro_text', '' ) ) ) {
				$text = get_theme_mod( 'lsvr_person_archive_intro_text', '' );
			}

			if ( is_tax( 'lsvr_person_cat' ) && ! empty( term_description( get_queried_object()->term_id, 'lsvr_person_cat' ) ) ) {
				$text = term_description( get_queried_object()->term_id, 'lsvr_person_cat' );
			}

			return $text;

		}
	}

	// Archive pre_get_posts actions
	add_action( 'pre_get_posts', 'lsvr_bluecollar_person_archive_pre_get_posts' );
	if ( ! function_exists( 'lsvr_bluecollar_person_archive_pre_get_posts' ) ) {
		function lsvr_bluecollar_person_archive_pre_get_posts( $query ) {

			if ( ! is_admin() && $query->is_main_query() && ( $query->is_post_type_archive( 'lsvr_person' ) || $query->is_tax( 'lsvr_person_cat' ) ) ) {

				// Posts per page
				if ( 0 === (int) get_theme_mod( 'lsvr_person_archive_posts_per_page', 12 ) ) {
					$query->set( 'posts_per_page', 1000 );
				} else {
					$query->set( 'posts_per_page', esc_attr( get_theme_mod( 'lsvr_person_archive_posts_per_page', 12 ) ) );
				}

				// Order
				if ( 'date_desc' == get_theme_mod( 'lsvr_person_archive_order', 'default' ) ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'date_asc' == get_theme_mod( 'lsvr_person_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'title_asc' == get_theme_mod( 'lsvr_person_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'title_desc' == get_theme_mod( 'lsvr_person_archive_order', 'default' )  ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'random' == get_theme_mod( 'lsvr_person_archive_order', 'default' )  ) {
					$query->set( 'orderby', 'rand' );
				}

			}

		}
	}

	// Enable archive categories
	add_filter( 'lsvr_bluecollar_post_archive_categories_enable', 'lsvr_bluecollar_person_archive_categories_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_person_archive_categories_enable' ) ) {
		function lsvr_bluecollar_person_archive_categories_enable( $enabled ) {

			if ( lsvr_bluecollar_is_person() && true === get_theme_mod( 'lsvr_person_archive_categories_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Get categories taxonomy
	add_filter( 'lsvr_bluecollar_post_archive_categories_taxonomy', 'lsvr_bluecollar_person_archive_categories_taxonomy' );
	if ( ! function_exists( 'lsvr_bluecollar_person_archive_categories_taxonomy' ) ) {
		function lsvr_bluecollar_person_archive_categories_taxonomy( $taxonomy ) {

			if ( lsvr_bluecollar_is_person() ) {
				return 'lsvr_person_cat';
			}

			return $taxonomy;

		}
	}

	// Enable single post navigation
	add_filter( 'lsvr_bluecollar_post_single_navigation_enable', 'lsvr_bluecollar_person_single_post_navigation_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_person_single_post_navigation_enable' ) ) {
		function lsvr_bluecollar_person_single_post_navigation_enable( $enabled ) {

			if ( lsvr_bluecollar_is_person() && true === get_theme_mod( 'lsvr_person_single_navigation_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Sidebar position
	add_filter( 'lsvr_bluecollar_sidebar_position', 'lsvr_bluecollar_person_sidebar_position' );
	if ( ! function_exists( 'lsvr_bluecollar_person_sidebar_position' ) ) {
		function lsvr_bluecollar_person_sidebar_position( $sidebar_position ) {

			// Is person single
			if ( is_singular( 'lsvr_person' ) && 'narrow' !== get_theme_mod( 'lsvr_person_single_layout', 'default' ) ) {
				return get_theme_mod( 'lsvr_person_single_sidebar_position', 'disable' );
			}

			// Is person archive
			elseif ( lsvr_bluecollar_is_person() && ! is_singular( 'lsvr_person' ) ) {
				return get_theme_mod( 'lsvr_person_archive_sidebar_position', 'disable' );
			}

			return $sidebar_position;

		}
	}

	// Sidebar ID
	add_filter( 'lsvr_bluecollar_sidebar_id', 'lsvr_bluecollar_person_sidebar_id' );
	if ( ! function_exists( 'lsvr_bluecollar_person_sidebar_id' ) ) {
		function lsvr_bluecollar_person_sidebar_id( $sidebar_id ) {

			// Is person single
			if ( is_singular( 'lsvr_person' ) ) {
				return get_theme_mod( 'lsvr_person_single_sidebar_id' );
			}

			// Is person archive
			elseif ( lsvr_bluecollar_is_person() ) {
				return get_theme_mod( 'lsvr_person_archive_sidebar_id' );
			}

			return $sidebar_id;

		}
	}


/**
 * META DATA
 */

	// Add post meta data
	add_action( 'lsvr_bluecollar_person_single_bottom', 'lsvr_bluecollar_add_person_single_meta' );
	if ( ! function_exists( 'lsvr_bluecollar_add_person_single_meta' ) ) {
		function lsvr_bluecollar_add_person_single_meta() { ?>

			<script type="application/ld+json">
			{
				"@context" : "http://schema.org",
				"@type" : "Person",
				"name" : "<?php the_title(); ?>"

				<?php if ( lsvr_bluecollar_has_person_role( get_the_ID() ) ) : ?>
				,"jobTitle" : "<?php echo esc_js( lsvr_bluecollar_get_person_role( get_the_ID() ) ); ?>"
				<?php endif; ?>

				<?php if ( lsvr_bluecollar_has_person_email( get_the_ID() ) ) : ?>
				,"email" : "<?php echo esc_js( lsvr_bluecollar_get_person_email( get_the_ID() ) ); ?>"
				<?php endif; ?>

				<?php if ( lsvr_bluecollar_has_person_phone( get_the_ID() ) ) : ?>
				,"telephone" : "<?php echo esc_js( lsvr_bluecollar_get_person_phone( get_the_ID() ) ); ?>"
				<?php endif; ?>

				<?php if ( lsvr_bluecollar_has_person_website( get_the_ID() ) ) : ?>
				,"url" : "<?php echo esc_url( lsvr_bluecollar_get_person_website( get_the_ID() ) ); ?>"
				<?php endif; ?>

				<?php if ( lsvr_bluecollar_has_person_social_links( get_the_ID() ) ) : ?>
				,"sameAs" : [
					<?php $i = 1; foreach( lsvr_bluecollar_get_person_social_links( get_the_ID() ) as $profile => $fields ) : ?>
			    		"<?php echo esc_url( $fields['url'] ); ?>"
			    		<?php if ( $i < count( lsvr_bluecollar_get_person_social_links( get_the_ID() ) ) ) { echo ','; } ?>
					<?php $i++; endforeach; ?>
			  	]
			  	<?php endif; ?>

				<?php if ( has_post_thumbnail() ) : ?>
			 	,"image": {
			 		"@type" : "ImageObject",
			 		"url" : "<?php the_post_thumbnail_url( 'full' ); ?>",
			 		"width" : "<?php echo esc_js( lsvr_bluecollar_get_image_width( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"height" : "<?php echo esc_js( lsvr_bluecollar_get_image_height( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"thumbnailUrl" : "<?php the_post_thumbnail_url( 'thumbnail' ); ?>"
			 	}
			 	<?php endif; ?>

			}
			</script>

		<?php }
	}

?>