<?php

// Archive class
if ( ! function_exists( 'lsvr_bluecollar_the_person_post_archive_class' ) ) {
	function lsvr_bluecollar_the_person_post_archive_class( $class = '' ) {

		// Defaults
		$class_arr = array( 'lsvr_person-post-page post-archive lsvr_person-post-archive' );

		// Passed
		if ( ! empty( $class ) ) {
			$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
		}

		// Masonry
		if ( true === get_theme_mod( 'lsvr_person_archive_masonry_enable', true ) ) {
			array_push( $class_arr, 'lsvr_person-post-archive--is-masonry' );
		}

		// Filter
		array_push( $class_arr, apply_filters( 'lsvr_bluecollar_person_post_archive_class', '' ) );

		// Echo
		if ( ! empty( $class_arr ) ) {
			echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
		}

	}
}

// Archive list class
if ( ! function_exists( 'lsvr_bluecollar_the_person_post_archive_list_class' ) ) {
	function lsvr_bluecollar_the_person_post_archive_list_class( $class = '' ) {

		// Defaults
		$class_arr = array( 'post-archive__list' );

		// Passed
		if ( ! empty( $class ) ) {
			$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
		}

		// Columns
		$number_of_columns = ! empty( get_theme_mod( 'lsvr_person_archive_grid_columns', 2 ) ) ? (int) get_theme_mod( 'lsvr_person_archive_grid_columns', 2 ) : 2;
		$span = 12 / $number_of_columns;
		$md_cols = $span > 2 ? 2 : $span;
		array_push( $class_arr, 'lsvr-grid lsvr-grid--' . $number_of_columns . '-cols lsvr-grid--md-' . $md_cols . '-cols' );

		// Filter
		array_push( $class_arr, apply_filters( 'lsvr_bluecollar_person_post_archive_list_class', '' ) );

		// Echo
		if ( ! empty( $class_arr ) ) {
			echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
		}

	}
}

// Archive grid column class
if ( ! function_exists( 'lsvr_bluecollar_the_person_post_archive_grid_column_class' ) ) {
	function lsvr_bluecollar_the_person_post_archive_grid_column_class( $class = '' ) {

		// Defaults
		$class_arr = array();

		// Passed
		if ( ! empty( $class ) ) {
			$class_arr = array_merge( $class_arr, explode( ' ', $class ) );
		}

		// Columns
		$number_of_columns = ! empty( get_theme_mod( 'lsvr_person_archive_grid_columns', 2 ) ) ? (int) get_theme_mod( 'lsvr_person_archive_grid_columns', 2 ) : 2;
		$span = 12 / $number_of_columns;
		$span_class = ' lsvr-grid__col--span-' . $span;
		$span_md_class = 3 === $span || 4 === $span || 6 === $span ? ' lsvr-grid__col--md-span-6' : '';
		array_push( $class_arr, 'lsvr-grid__col ' . $span_class . $span_md_class );

		// Filter
		array_push( $class_arr, apply_filters( 'lsvr_bluecollar_person_post_archive_grid_column_class', '' ) );

		// Echo
		if ( ! empty( $class_arr ) ) {
			echo ' class="' . esc_attr( implode( ' ', $class_arr ) ) . '"';
		}

	}
}

// Person role
if ( ! function_exists( 'lsvr_bluecollar_the_person_role' ) ) {
	function lsvr_bluecollar_the_person_role( $post_id ) {

		$person_role = lsvr_bluecollar_get_person_role( $post_id );
		echo ! empty( $person_role ) ? esc_html( $person_role ) : '';

	}
}

?>