<?php

// Include additional files
require_once( get_template_directory() . '/inc/lsvr-portfolio/actions.php' );
require_once( get_template_directory() . '/inc/lsvr-portfolio/frontend-functions.php' );
require_once( get_template_directory() . '/inc/lsvr-portfolio/customizer-config.php' );
require_once( get_template_directory() . '/inc/lsvr-portfolio/metaboxes-config.php' );

// Is project page
if ( ! function_exists( 'lsvr_bluecollar_is_project' ) ) {
	function lsvr_bluecollar_is_project() {

		if ( is_post_type_archive( 'lsvr_project' ) || is_tax( 'lsvr_project_cat' ) || is_tax( 'lsvr_project_tag' ) ||
			is_singular( 'lsvr_project' ) ) {
			return true;
		} else {
			return false;
		}

	}
}

// Get project archive title
if ( ! function_exists( 'lsvr_bluecollar_get_project_archive_title' ) ) {
	function lsvr_bluecollar_get_project_archive_title() {

		return get_theme_mod( 'lsvr_project_archive_title', esc_html__( 'Portfolio', 'bluecollar' ) );

	}
}

// Get project images
if ( ! function_exists( 'lsvr_bluecollar_get_project_images' ) ) {
	function lsvr_bluecollar_get_project_images( $post_id ) {
		if ( function_exists( 'lsvr_portfolio_get_project_images' ) ) {

			$project_images = lsvr_portfolio_get_project_images( $post_id );
			return ! empty( $project_images ) ? $project_images : false;

		}
	}
}

// Has project images
if ( ! function_exists( 'lsvr_bluecollar_has_project_images' ) ) {
	function lsvr_bluecollar_has_project_images( $post_id ) {
		if ( function_exists( 'lsvr_portfolio_get_project_images_count' ) ) {

			$images_count = lsvr_portfolio_get_project_images_count( $post_id );
			return $images_count > 0 ? true : false;

		}
	}
}

// Get project layout
if ( ! function_exists( 'lsvr_bluecollar_get_project_layout' ) ) {
	function lsvr_bluecollar_get_project_layout( $post_id ) {

		$default_layout = get_theme_mod( 'lsvr_project_single_layout', 'gallery-top' );
		$single_layout = get_post_meta( $post_id, 'lsvr_bluecollar_project_layout', true );
		$layout = 'default' === $single_layout ? $default_layout : $single_layout;

		return ! empty( $layout ) ? $layout : $default_layout;

	}
}

// Get project gallery grid columns
if ( ! function_exists( 'lsvr_bluecollar_get_project_gallery_grid_columns' ) ) {
	function lsvr_bluecollar_get_project_gallery_grid_columns( $post_id ) {

		$default_columns = get_theme_mod( 'lsvr_project_single_gallery_grid_columns', 3 );
		$single_columns = get_post_meta( $post_id, 'lsvr_bluecollar_project_gallery_grid_columns', true );
		$columns = 'default' === $single_columns ? $default_columns : $single_columns;

		return ! empty( $columns ) ? $columns : $default_columns;

	}
}

// Get project custom fields
if ( ! function_exists( 'lsvr_bluecollar_get_project_custom_fields' ) ) {
	function lsvr_bluecollar_get_project_custom_fields( $post_id ) {
		if ( function_exists( 'lsvr_portfolio_get_project_meta' ) ) {

			$project_meta = lsvr_portfolio_get_project_meta( $post_id );
			return ! empty( $project_meta['custom_fields'] ) ? $project_meta['custom_fields'] : false;

		}
	}
}

// Has project custom fields
if ( ! function_exists( 'lsvr_bluecollar_has_project_custom_fields' ) ) {
	function lsvr_bluecollar_has_project_custom_fields( $post_id ) {

		$custom_fields = lsvr_bluecollar_get_project_custom_fields( $post_id );
		return ! empty( $custom_fields ) ? true : false;

	}
}

?>