<?php

// Add additional metafields into Project Settings metabox
add_filter( 'lsvr_project_settings_metabox_fields', 'lsvr_bluecollar_project_settings_metabox_fields' );
if ( ! function_exists( 'lsvr_bluecollar_project_settings_metabox_fields' ) ) {
	function lsvr_bluecollar_project_settings_metabox_fields() {

		return array(

			// Layout
			'lsvr_bluecollar_project_layout' => array(
				'title' => esc_html__( 'Project Layout', 'bluecollar' ),
                'description' => esc_html__( 'Change the project layout. Choose default to use the value set under Appearance / Customize / Portfolio.', 'bluecollar' ),
                'type' => 'select',
                'choices' => array(
                	'default' => esc_html__( 'Default', 'bluecollar' ),
                    'gallery-top' => esc_html__( 'Gallery on the top', 'bluecollar' ),
                    'gallery-left' => esc_html__( 'Gallery on the left', 'bluecollar' ),
                    'gallery-right' => esc_html__( 'Gallery on the right', 'bluecollar' ),
                    'gallery-bottom' => esc_html__( 'Gallery on the bottom', 'bluecollar' ),
                ),
                'default' => 'default',
				'priority' => 100,
			),

			// Gallery grid columns
			'lsvr_bluecollar_project_gallery_grid_columns' => array(
				'title' => esc_html__( 'Number of Gallery Columns', 'bluecollar' ),
                'description' => esc_html__( 'Divide project gallery into several columns. Choose default to use the value set under Appearance / Customize / Portfolio.', 'bluecollar' ),
                'type' => 'select',
                'choices' => array(
                	'default' => esc_html__( 'Default', 'bluecollar' ),
                    '1' => 1,
                    '2' => 2,
                    '3' => 3,
                    '4' => 4,
                ),
                'default' => 'default',
				'priority' => 110,
			),

		);

	}
}

?>