<?php

/**
 * GENERAL
 */

	// Set current post type
	add_filter( 'lsvr_bluecollar_current_post_type', 'lsvr_bluecollar_service_set_current_post_type' );
	if ( ! function_exists( 'lsvr_bluecollar_service_set_current_post_type' ) ) {
		function lsvr_bluecollar_service_set_current_post_type( $post_type ) {

			if ( lsvr_bluecollar_is_service() ) {
				return 'lsvr_service';
			}
			return $post_type;

		}
	}

	// Document title
	add_filter( 'document_title_parts', 'lsvr_bluecollar_service_title' );
	if ( ! function_exists( 'lsvr_bluecollar_service_title' ) ) {
		function lsvr_bluecollar_service_title( $title ) {

			if ( is_post_type_archive( 'lsvr_service' ) ) {
				$title['title'] = sanitize_text_field( lsvr_bluecollar_get_service_archive_title() );
			}
			return $title;

		}
	}

	// Load project JS files
	add_action( 'lsvr_bluecollar_load_assets', 'lsvr_bluecollar_service_load_js' );
	if ( ! function_exists( 'lsvr_bluecollar_service_load_js' ) ) {
		function lsvr_bluecollar_service_load_js() {

			// Masonry
			if ( lsvr_bluecollar_is_service() && ! is_singular( 'lsvr_service' ) && get_theme_mod( 'lsvr_service_archive_grid_columns', 2 ) > 1 &&
				true === get_theme_mod( 'lsvr_service_archive_masonry_enable', false ) ) {
				wp_enqueue_script( 'masonry' );
			}

		}
	}


/**
 * CORE
 */

	// Page title
	add_filter( 'lsvr_bluecollar_page_title_title', 'lsvr_bluecollar_service_page_title' );
	if ( ! function_exists( 'lsvr_bluecollar_service_page_title' ) ) {
		function lsvr_bluecollar_service_page_title( $title ) {

			if ( is_post_type_archive( 'lsvr_service' ) ) {
				return lsvr_bluecollar_get_service_archive_title();
			} elseif ( is_tax( 'lsvr_service_tag' ) ) {
				return sprintf( esc_html__( 'Tag: %s', 'bluecollar' ), single_term_title( '', false ) );
			}

			return $title;

		}
	}

	// Breadcrumbs
	add_filter( 'lsvr_bluecollar_add_to_breadcrumbs', 'lsvr_bluecollar_service_breadcrumbs' );
	if ( ! function_exists( 'lsvr_bluecollar_service_breadcrumbs' ) ) {
		function lsvr_bluecollar_service_breadcrumbs( $breadcrumbs ) {

			if ( lsvr_bluecollar_is_service() && ! is_post_type_archive( 'lsvr_service' ) ) {
				$breadcrumbs = array(
					array(
						'url' => get_post_type_archive_link( 'lsvr_service' ),
						'label' => lsvr_bluecollar_get_service_archive_title(),
					),
				);
			}
			return $breadcrumbs;

		}
	}

	// Archive intro title
	add_filter( 'lsvr_bluecollar_post_archive_intro_title', 'lsvr_bluecollar_service_archive_intro_title' );
	if ( ! function_exists( 'lsvr_bluecollar_service_archive_intro_title' ) ) {
		function lsvr_bluecollar_service_archive_intro_title( $title ) {

			if ( lsvr_bluecollar_is_service() && ! empty( get_theme_mod( 'lsvr_service_archive_intro_title', '' ) ) ) {
				$title = get_theme_mod( 'lsvr_service_archive_intro_title', '' );
			}

			return $title;

		}
	}

	// Archive intro text
	add_filter( 'lsvr_bluecollar_post_archive_intro_text', 'lsvr_bluecollar_service_archive_intro_text' );
	if ( ! function_exists( 'lsvr_bluecollar_service_archive_intro_text' ) ) {
		function lsvr_bluecollar_service_archive_intro_text( $text ) {

			if ( lsvr_bluecollar_is_service() && ! empty( get_theme_mod( 'lsvr_service_archive_intro_text', '' ) ) ) {
				$text = get_theme_mod( 'lsvr_service_archive_intro_text', '' );
			}

			if ( is_tax( 'lsvr_service_cat' ) && ! empty( term_description( get_queried_object()->term_id, 'lsvr_service_cat' ) ) ) {
				$text = term_description( get_queried_object()->term_id, 'lsvr_service_cat' );
			}

			return $text;

		}
	}

	// Archive pre_get_posts actions
	add_action( 'pre_get_posts', 'lsvr_bluecollar_service_archive_pre_get_posts' );
	if ( ! function_exists( 'lsvr_bluecollar_service_archive_pre_get_posts' ) ) {
		function lsvr_bluecollar_service_archive_pre_get_posts( $query ) {
			if ( ! is_admin() && $query->is_main_query() && ( $query->is_post_type_archive( 'lsvr_service' ) || $query->is_tax( 'lsvr_service_cat' ) || $query->is_tax( 'lsvr_service_tag' ) ) ) {

				// Posts per page
				if ( 0 === (int) get_theme_mod( 'lsvr_service_archive_posts_per_page', 12 ) ) {
					$query->set( 'posts_per_page', 1000 );
				} else {
					$query->set( 'posts_per_page', esc_attr( get_theme_mod( 'lsvr_service_archive_posts_per_page', 12 ) ) );
				}

				// Order
				if ( 'date_desc' == get_theme_mod( 'lsvr_service_archive_order', 'default' ) ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'date_asc' == get_theme_mod( 'lsvr_service_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'title_asc' == get_theme_mod( 'lsvr_service_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'title_desc' == get_theme_mod( 'lsvr_service_archive_order', 'default' )  ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'random' == get_theme_mod( 'lsvr_service_archive_order', 'default' )  ) {
					$query->set( 'orderby', 'rand' );
				}

			}
		}
	}

	// Enable archive categories
	add_filter( 'lsvr_bluecollar_post_archive_categories_enable', 'lsvr_bluecollar_service_archive_categories_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_service_archive_categories_enable' ) ) {
		function lsvr_bluecollar_service_archive_categories_enable( $enabled ) {

			if ( lsvr_bluecollar_is_service() && true === get_theme_mod( 'lsvr_service_archive_categories_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Get categories taxonomy
	add_filter( 'lsvr_bluecollar_post_archive_categories_taxonomy', 'lsvr_bluecollar_service_archive_categories_taxonomy' );
	if ( ! function_exists( 'lsvr_bluecollar_service_archive_categories_taxonomy' ) ) {
		function lsvr_bluecollar_service_archive_categories_taxonomy( $taxonomy ) {

			if ( lsvr_bluecollar_is_service() ) {
				return 'lsvr_service_cat';
			}

			return $taxonomy;

		}
	}

	// Enable post detail navigation
	add_filter( 'lsvr_bluecollar_post_single_navigation_enable', 'lsvr_bluecollar_service_single_post_navigation_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_service_single_post_navigation_enable' ) ) {
		function lsvr_bluecollar_service_single_post_navigation_enable( $enabled ) {

			if ( is_singular( 'lsvr_service' ) && true === get_theme_mod( 'lsvr_service_single_navigation_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Sidebar position
	add_filter( 'lsvr_bluecollar_sidebar_position', 'lsvr_bluecollar_service_sidebar_position' );
	if ( ! function_exists( 'lsvr_bluecollar_service_sidebar_position' ) ) {
		function lsvr_bluecollar_service_sidebar_position( $sidebar_position ) {

			// Is service single
			if ( is_singular( 'lsvr_service' ) ) {
				$sidebar_position = get_theme_mod( 'lsvr_service_single_sidebar_position', 'disable' );
			}

			// Is service archive
			else if ( lsvr_bluecollar_is_service() ) {
				$sidebar_position = get_theme_mod( 'lsvr_service_archive_sidebar_position', 'disable' );
			}

			return $sidebar_position;

		}
	}

	// Sidebar ID
	add_filter( 'lsvr_bluecollar_sidebar_id', 'lsvr_bluecollar_service_sidebar_id' );
	if ( ! function_exists( 'lsvr_bluecollar_service_sidebar_id' ) ) {
		function lsvr_bluecollar_service_sidebar_id( $sidebar_id ) {

			// Is service single
			if ( is_singular( 'lsvr_service' ) ) {
				$sidebar_id = get_theme_mod( 'lsvr_service_single_sidebar_id' );
			}

			// Is service archive
			else if ( lsvr_bluecollar_is_service() ) {
				$sidebar_id = get_theme_mod( 'lsvr_service_archive_sidebar_id' );
			}

			return $sidebar_id;

		}
	}


/**
 * META DATA
 */

	// Add post meta data
	add_action( 'lsvr_bluecollar_service_single_bottom', 'lsvr_bluecollar_add_service_single_meta' );
	if ( ! function_exists( 'lsvr_bluecollar_add_service_single_meta' ) ) {
		function lsvr_bluecollar_add_service_single_meta() { ?>

			<script type="application/ld+json">
			{
				"@context" : "http://schema.org",
				"@type" : "Service",
				"name": "<?php echo esc_js( get_the_title() ); ?>",
				"url" : "<?php echo esc_url( get_permalink() ); ?>",
				"mainEntityOfPage" : "<?php echo esc_url( get_permalink() ); ?>",
			 	"description": "<?php echo esc_js( get_the_excerpt() ); ?>"

				<?php if ( has_post_thumbnail() ) : ?>
			 	,"image": {
			 		"@type" : "ImageObject",
			 		"url" : "<?php the_post_thumbnail_url( 'full' ); ?>",
			 		"width" : "<?php echo esc_js( lsvr_bluecollar_get_image_width( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"height" : "<?php echo esc_js( lsvr_bluecollar_get_image_height( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"thumbnailUrl" : "<?php the_post_thumbnail_url( 'thumbnail' ); ?>"
			 	}
			 	<?php endif; ?>

			}
			</script>

		<?php }
	}

?>