<?php

add_action( 'customize_register', 'lsvr_bluecollar_services_customize_register' );
if ( ! function_exists( 'lsvr_bluecollar_services_customize_register' ) ) {
    function lsvr_bluecollar_services_customize_register( $wp_customize ) {
        if ( class_exists( 'Lsvr_Customizer' ) ) {

            $lsvr_customizer = new Lsvr_Customizer( $wp_customize, 'lsvr_bluecollar_' );

            $lsvr_customizer->add_section( 'lsvr_service_settings', array(
                'title' => esc_html__( 'Services', 'bluecollar' ),
                'priority' => 130,
            ));

                // Archive settings
                $lsvr_customizer->add_info( 'lsvr_service_archive_info', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Archive Settings', 'bluecollar' ),
                    'description' => esc_html__( 'The following settings apply to post archive page. You can change your default post archive URL under Settings / Permalinks. Scroll down for post detail page settings.', 'bluecollar' ),
                    'priority' => 1005,
                ));

                // Title
                $lsvr_customizer->add_field( 'lsvr_service_archive_title', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Service Archive Title', 'bluecollar' ),
                    'description' => esc_html__( 'This title will be used as the archive page headline and in breadcrumbs.', 'bluecollar' ),
                    'type' => 'text',
                    'default' => esc_html__( 'Services', 'bluecollar' ),
                    'priority' => 1010,
                ));

                // Intro title
                $lsvr_customizer->add_field( 'lsvr_service_archive_intro_title', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Service Archive Intro Title', 'bluecollar' ),
                    'description' => esc_html__( 'Title of the intro section displayed right above the service post list. Leave blank to hide.', 'bluecollar' ),
                    'type' => 'text',
                    'default' => '',
                    'priority' => 1020,
                ));

                // Intro text
                $lsvr_customizer->add_field( 'lsvr_service_archive_intro_text', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Service Archive Intro Text', 'bluecollar' ),
                    'description' => esc_html__( 'Content of the intro section displayed right above the service post list. Leave blank to hide.', 'bluecollar' ),
                    'type' => 'textarea',
                    'default' => '',
                    'priority' => 1030,
                ));

                // Archive posts per page
                $lsvr_customizer->add_field( 'lsvr_service_archive_posts_per_page', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Posts Per Page', 'bluecollar' ),
                    'description' => esc_html__( 'How many service posts should be displayed per page. Set to 0 to display all.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ),
                    'default' => 12,
                    'priority' => 1040,
                ));

                // Archive grid columns
                $lsvr_customizer->add_field( 'lsvr_service_archive_grid_columns', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Number of Columns', 'bluecollar' ),
                    'description' => esc_html__( 'Separate layout into several columns.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'default' => 4,
                    'priority' => 1050,
                ));

                // Archive order
                $lsvr_customizer->add_field( 'lsvr_service_archive_order', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Archive Order', 'bluecollar' ),
                    'description' => esc_html__( 'Change the posts order. Leave it on Default if you want to use 3rd party plugin to set the order.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'bluecollar' ),
                        'date_desc' => esc_html__( 'By date, newest first', 'bluecollar' ),
                        'date_asc' => esc_html__( 'By date, oldest first', 'bluecollar' ),
                        'title_asc' => esc_html__( 'By title, ascending', 'bluecollar' ),
                        'title_desc' => esc_html__( 'By title, descending', 'bluecollar' ),
                        'random' => esc_html__( 'Random', 'bluecollar' ),
                    ),
                    'default' => 'default',
                    'priority' => 1060,
                ));

                // Enable categories
                $lsvr_customizer->add_field( 'lsvr_service_archive_categories_enable', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Display Archive Categories', 'bluecollar' ),
                    'description' => esc_html__( 'Display links to service categories at the top of the archive page.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1110,
                ));

                // Enable masonry on archive
                $lsvr_customizer->add_field( 'lsvr_service_archive_masonry_enable', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Enable Masonry On Archive', 'bluecollar' ),
                    'description' => esc_html__( 'Display service posts grid using the masonry layout.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => false,
                    'priority' => 1120,
                ));

                // Archive sidebar position
                $lsvr_customizer->add_field( 'lsvr_service_archive_sidebar_position', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Archive Sidebar Position', 'bluecollar' ),
                    'description' => esc_html__( 'Change the service post archive sidebar position.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'bluecollar' ),
                        'left' => esc_html__( 'Left', 'bluecollar' ),
                        'right' => esc_html__( 'Right', 'bluecollar' ),
                    ),
                    'default' => 'disable',
                    'priority' => 1210,
                ));

                // Archive sidebar ID
                $lsvr_customizer->add_field( 'lsvr_service_archive_sidebar_id', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Archive Sidebar', 'bluecollar' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => lsvr_bluecollar_get_sidebars(),
                    'priority' => 1220,
                    'required' => array(
                        'setting' => 'lsvr_service_archive_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

                // Separator
                $lsvr_customizer->add_separator( 'lsvr_service_separator_2', array(
                    'section' => 'lsvr_service_settings',
                    'priority' => 2000,
                ));

                // Detail settings
                $lsvr_customizer->add_info( 'lsvr_service_single_info', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Detail Settings', 'bluecollar' ),
                    'description' => esc_html__( 'The following settings apply to post detail pages.', 'bluecollar' ),
                    'priority' => 2005,
                ));

                // Gallery title
                $lsvr_customizer->add_field( 'lsvr_service_single_gallery_title', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Service Gallery Title', 'bluecollar' ),
                    'description' => esc_html__( 'This title will be displayed above service post gallery on its detail page.', 'bluecollar' ),
                    'type' => 'text',
                    'default' => esc_html__( 'Gallery', 'bluecollar' ),
                    'priority' => 2010,
                ));

                // Enable post detail navigation
                $lsvr_customizer->add_field( 'lsvr_service_single_navigation_enable', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Enable Service Detail Navigation', 'bluecollar' ),
                    'description' => esc_html__( 'Display links to previous and next posts at the bottom of the current service.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2030,
                ));

                // Single sidebar position
                $lsvr_customizer->add_field( 'lsvr_service_single_sidebar_position', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Detail Sidebar Position', 'bluecollar' ),
                    'description' => esc_html__( 'Change the service post detail sidebar position.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'bluecollar' ),
                        'left' => esc_html__( 'Left', 'bluecollar' ),
                        'right' => esc_html__( 'Right', 'bluecollar' ),
                    ),
                    'default' => 'disable',
                    'priority' => 2110,
                ));

                // Single sidebar ID
                $lsvr_customizer->add_field( 'lsvr_service_single_sidebar_id', array(
                    'section' => 'lsvr_service_settings',
                    'label' => esc_html__( 'Detail Sidebar', 'bluecollar' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => lsvr_bluecollar_get_sidebars(),
                    'priority' => 2120,
                    'required' => array(
                        'setting' => 'lsvr_service_single_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

        }
    }
}

?>