<?php

// Include additional files
require_once( get_template_directory() . '/inc/lsvr-services/actions.php' );
require_once( get_template_directory() . '/inc/lsvr-services/frontend-functions.php' );
require_once( get_template_directory() . '/inc/lsvr-services/customizer-config.php' );

// Is service page
if ( ! function_exists( 'lsvr_bluecollar_is_service' ) ) {
	function lsvr_bluecollar_is_service() {

		if ( is_post_type_archive( 'lsvr_service' ) || is_tax( 'lsvr_service_cat' ) || is_tax( 'lsvr_service_tag' ) ||
			is_singular( 'lsvr_service' ) ) {
			return true;
		} else {
			return false;
		}

	}
}

// Get service archive title
if ( ! function_exists( 'lsvr_bluecollar_get_service_archive_title' ) ) {
	function lsvr_bluecollar_get_service_archive_title() {

		return get_theme_mod( 'lsvr_service_archive_title', esc_html__( 'Services', 'bluecollar' ) );

	}
}

// Get service icon class
if ( ! function_exists( 'lsvr_bluecollar_get_service_icon_class' ) ) {
	function lsvr_bluecollar_get_service_icon_class( $post_id ) {
		if ( function_exists( 'lsvr_services_get_service_meta' ) ) {

			$service_meta = lsvr_services_get_service_meta( $post_id );
			return ! empty( $service_meta['icon_class'] ) ? $service_meta['icon_class'] : '';

		}
	}
}

// Has service icon class
if ( ! function_exists( 'lsvr_bluecollar_has_service_icon_class' ) ) {
	function lsvr_bluecollar_has_service_icon_class( $post_id ) {

		$service_icon_class = lsvr_bluecollar_get_service_icon_class( $post_id );
		return ! empty( $service_icon_class ) ? true : false;

	}
}

// Get service images
if ( ! function_exists( 'lsvr_bluecollar_get_service_images' ) ) {
	function lsvr_bluecollar_get_service_images( $post_id ) {
		if ( function_exists( 'lsvr_services_get_service_images' ) ) {

			$service_images = lsvr_services_get_service_images( $post_id );
			return ! empty( $service_images ) ? $service_images : false;

		}
	}
}

// Service images count
if ( ! function_exists( 'lsvr_bluecollar_get_service_images_count' ) ) {
	function lsvr_bluecollar_get_service_images_count( $post_id ) {
		if ( function_exists( 'lsvr_services_get_service_images_count' ) ) {

			return (int) lsvr_services_get_service_images_count( $post_id );

		}
	}
}

// Has service images
if ( ! function_exists( 'lsvr_bluecollar_has_service_images' ) ) {
	function lsvr_bluecollar_has_service_images( $post_id ) {

		$images_count = (int) lsvr_bluecollar_get_service_images_count( $post_id );
		return $images_count > 0 ? true : false;

	}
}

?>