<?php

/**
 * GENERAL
 */

	// Set current post type
	add_filter( 'lsvr_bluecollar_current_post_type', 'lsvr_bluecollar_testimonial_set_current_post_type' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_set_current_post_type' ) ) {
		function lsvr_bluecollar_testimonial_set_current_post_type( $post_type ) {

			if ( lsvr_bluecollar_is_testimonial() ) {
				return 'lsvr_testimonial';
			}
			return $post_type;

		}
	}

	// Document title
	add_filter( 'document_title_parts', 'lsvr_bluecollar_testimonial_document_title' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_document_title' ) ) {
		function lsvr_bluecollar_testimonial_document_title( $title ) {

			if ( is_post_type_archive( 'lsvr_testimonial' ) ) {
				$title['title'] = sanitize_text_field( lsvr_bluecollar_get_testimonial_archive_title() );
			}
			return $title;

		}
	}

	// Load JS files
	add_action( 'lsvr_bluecollar_load_assets', 'lsvr_bluecollar_testimonial_load_js' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_load_js' ) ) {
		function lsvr_bluecollar_testimonial_load_js() {

			// Masonry
			if ( lsvr_bluecollar_is_testimonial() && ! is_singular( 'lsvr_testimonial' ) &&
				get_theme_mod( 'lsvr_testimonial_archive_grid_columns', 2 ) > 1 &&
				true === get_theme_mod( 'lsvr_testimonial_archive_masonry_enable', true ) ) {
				wp_enqueue_script( 'masonry' );
			}

		}
	}


/**
 * CORE
 */

	// Set narrow layout
	add_filter( 'lsvr_bluecollar_narrow_layout_enable', 'lsvr_bluecollar_testimonial_single_narrow_layout_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_single_narrow_layout_enable' ) ) {
		function lsvr_bluecollar_testimonial_single_narrow_layout_enable( $enable ) {

			if ( is_singular( 'lsvr_testimonial' ) && 'narrow' === get_theme_mod( 'lsvr_testimonial_single_layout', 'default' ) ) {
				return true;
			}

			return $enable;

		}
	}

	// Page header title
	add_filter( 'lsvr_bluecollar_page_title_title', 'lsvr_bluecollar_testimonial_page_title' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_page_title' ) ) {
		function lsvr_bluecollar_testimonial_page_title( $title ) {

			if ( is_post_type_archive( 'lsvr_testimonial' ) ) {
				return lsvr_bluecollar_get_testimonial_archive_title();
			}

			return $title;

		}
	}

	// Single page header title
	add_filter( 'lsvr_bluecollar_page_title_title', 'lsvr_bluecollar_testimonial_single_page_title' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_single_page_title' ) ) {
		function lsvr_bluecollar_testimonial_single_page_title( $title ) {

			if ( is_singular( 'lsvr_testimonial' ) && ! empty( lsvr_bluecollar_get_testimonial_single_title() ) ) {
				return lsvr_bluecollar_get_testimonial_single_title();
			}

			return $title;

		}
	}

	// Breadcrumbs
	add_filter( 'lsvr_bluecollar_add_to_breadcrumbs', 'lsvr_bluecollar_testimonial_breadcrumbs' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_breadcrumbs' ) ) {
		function lsvr_bluecollar_testimonial_breadcrumbs( $breadcrumbs ) {

			if ( lsvr_bluecollar_is_testimonial() && ! is_post_type_archive( 'lsvr_testimonial' ) ) {
				return array(
					array(
						'url' => get_post_type_archive_link( 'lsvr_testimonial' ),
						'label' => lsvr_bluecollar_get_testimonial_archive_title(),
					),
				);
			}

			return $breadcrumbs;

		}
	}

	// Archive intro title
	add_filter( 'lsvr_bluecollar_post_archive_intro_title', 'lsvr_bluecollar_testimonial_archive_intro_title' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_archive_intro_title' ) ) {
		function lsvr_bluecollar_testimonial_archive_intro_title( $title ) {

			if ( lsvr_bluecollar_is_testimonial() && ! empty( get_theme_mod( 'lsvr_testimonial_archive_intro_title', '' ) ) ) {
				$title = get_theme_mod( 'lsvr_testimonial_archive_intro_title', '' );
			}

			return $title;

		}
	}

	// Archive intro text
	add_filter( 'lsvr_bluecollar_post_archive_intro_text', 'lsvr_bluecollar_testimonial_archive_intro_text' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_archive_intro_text' ) ) {
		function lsvr_bluecollar_testimonial_archive_intro_text( $text ) {

			if ( lsvr_bluecollar_is_testimonial() && ! empty( get_theme_mod( 'lsvr_testimonial_archive_intro_text', '' ) ) ) {
				$text = get_theme_mod( 'lsvr_testimonial_archive_intro_text', '' );
			}

			return $text;

		}
	}

	// Archive pre_get_posts actions
	add_action( 'pre_get_posts', 'lsvr_bluecollar_testimonial_archive_pre_get_posts' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_archive_pre_get_posts' ) ) {
		function lsvr_bluecollar_testimonial_archive_pre_get_posts( $query ) {

			if ( ! is_admin() && $query->is_main_query() && ( $query->is_post_type_archive( 'lsvr_testimonial' ) ) ) {

				// Posts per page
				if ( 0 === (int) get_theme_mod( 'lsvr_testimonial_archive_posts_per_page', 12 ) ) {
					$query->set( 'posts_per_page', 1000 );
				} else {
					$query->set( 'posts_per_page', esc_attr( get_theme_mod( 'lsvr_testimonial_archive_posts_per_page', 12 ) ) );
				}

				// Order
				if ( 'date_desc' == get_theme_mod( 'lsvr_testimonial_archive_order', 'default' ) ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'date_asc' == get_theme_mod( 'lsvr_testimonial_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'date' );
				}
				elseif ( 'title_asc' == get_theme_mod( 'lsvr_testimonial_archive_order', 'default' )  ) {
					$query->set( 'order', 'ASC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'title_desc' == get_theme_mod( 'lsvr_testimonial_archive_order', 'default' )  ) {
					$query->set( 'order', 'DESC' );
					$query->set( 'orderby', 'title' );
				}
				elseif ( 'random' == get_theme_mod( 'lsvr_testimonial_archive_order', 'default' )  ) {
					$query->set( 'orderby', 'rand' );
				}

			}

		}
	}

	// Enable single post navigation
	add_filter( 'lsvr_bluecollar_post_single_navigation_enable', 'lsvr_bluecollar_testimonial_single_post_navigation_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_single_post_navigation_enable' ) ) {
		function lsvr_bluecollar_testimonial_single_post_navigation_enable( $enabled ) {

			if ( lsvr_bluecollar_is_testimonial() && true === get_theme_mod( 'lsvr_testimonial_single_navigation_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Sidebar position
	add_filter( 'lsvr_bluecollar_sidebar_position', 'lsvr_bluecollar_testimonial_sidebar_position' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_sidebar_position' ) ) {
		function lsvr_bluecollar_testimonial_sidebar_position( $sidebar_position ) {

			// Is testimonial single
			if ( is_singular( 'lsvr_testimonial' ) && 'narrow' !== get_theme_mod( 'lsvr_testimonial_single_layout', 'default' ) ) {
				return get_theme_mod( 'lsvr_testimonial_single_sidebar_position', 'disable' );
			}

			// Is testimonial archive
			elseif ( lsvr_bluecollar_is_testimonial() && ! is_singular( 'lsvr_testimonial' ) ) {
				return get_theme_mod( 'lsvr_testimonial_archive_sidebar_position', 'disable' );
			}

			return $sidebar_position;

		}
	}

	// Sidebar ID
	add_filter( 'lsvr_bluecollar_sidebar_id', 'lsvr_bluecollar_testimonial_sidebar_id' );
	if ( ! function_exists( 'lsvr_bluecollar_testimonial_sidebar_id' ) ) {
		function lsvr_bluecollar_testimonial_sidebar_id( $sidebar_id ) {

			// Is testimonial single
			if ( is_singular( 'lsvr_testimonial' ) ) {
				return get_theme_mod( 'lsvr_testimonial_single_sidebar_id' );
			}

			// Is testimonial archive
			elseif ( lsvr_bluecollar_is_testimonial() ) {
				return get_theme_mod( 'lsvr_testimonial_archive_sidebar_id' );
			}

			return $sidebar_id;

		}
	}

?>