<?php

// Include additional files
require_once( get_template_directory() . '/inc/lsvr-testimonials/actions.php' );
require_once( get_template_directory() . '/inc/lsvr-testimonials/frontend-functions.php' );
require_once( get_template_directory() . '/inc/lsvr-testimonials/customizer-config.php' );

// Is testimonial page
if ( ! function_exists( 'lsvr_bluecollar_is_testimonial' ) ) {
    function lsvr_bluecollar_is_testimonial() {

        if ( is_post_type_archive( 'lsvr_testimonial' ) || is_singular( 'lsvr_testimonial' ) ) {
            return true;
        } else {
            return false;
        }

    }
}

// Get testimonial archive title
if ( ! function_exists( 'lsvr_bluecollar_get_testimonial_archive_title' ) ) {
    function lsvr_bluecollar_get_testimonial_archive_title() {

        return get_theme_mod( 'lsvr_testimonial_archive_title', esc_html__( 'Testimonials', 'bluecollar' ) );

    }
}

// Get testimonial single title
if ( ! function_exists( 'lsvr_bluecollar_get_testimonial_single_title' ) ) {
    function lsvr_bluecollar_get_testimonial_single_title() {

        return sprintf( get_theme_mod( 'lsvr_testimonial_single_title', '' ), get_the_title( get_the_ID() ) );

    }
}

// Get testimonial author description
if ( ! function_exists( 'lsvr_bluecollar_get_testimonial_author_description' ) ) {
    function lsvr_bluecollar_get_testimonial_author_description( $post_id ) {

        $author_description = get_post_meta( $post_id, 'lsvr_testimonial_author_description', true );
        return ! empty( $author_description ) ? $author_description : false;

    }
}

// Has testimonial author description
if ( ! function_exists( 'lsvr_bluecollar_has_testimonial_author_description' ) ) {
    function lsvr_bluecollar_has_testimonial_author_description( $post_id ) {

        $author_description = lsvr_bluecollar_get_testimonial_author_description( $post_id );
        return ! empty( $author_description ) ? true : false;

    }
}

?>