<?php get_header(); ?>

<?php // Page title
get_template_part( 'template-parts/page-title' ); ?>

<!-- CORE COLUMNS : begin -->
<div class="core__columns core__columns--narrow">
	<div class="core__columns-inner">
		<div class="lsvr-container">
			<div class="core__columns-bg">

				<!-- MAIN : begin -->
				<main id="main">
					<div class="main__inner">

						<div <?php post_class( 'search-results-page' ); ?>>

							<!-- PAGE CONTENT : begin -->
							<div class="page__content">

								<?php // Search form
								get_search_form() ?>

								<?php // Results info
								global $wp_query; if ( ! empty( $wp_query->found_posts ) ) : ?>

									<?php lsvr_bluecollar_the_alert_message( sprintf( esc_html__( 'Showing %d results for "%s".', 'bluecollar' ), $wp_query->found_posts, get_search_query() ) ); ?>

								<?php endif; ?>

								<?php if ( have_posts() ) : ?>

									<ul class="search-results-page__list">

										<?php while ( have_posts() ) : the_post(); ?>

											<li class="search-results-page__item">

												<h3 class="search-results-page__item-title">
													<a href="<?php the_permalink(); ?>" class="search-results-page__item-title-link"><?php the_title(); ?></a>
												</h3>

												<?php $post_object = get_post_type_object( get_post_type() ); ?>
												<p class="search-results-page__item-type"><?php echo esc_html( $post_object->labels->singular_name ); ?></p>

												<?php if ( true === get_theme_mod( 'search_results_excerpt_enable', false ) && ! empty( $post->post_excerpt ) ) : ?>

													<div class="search-results-page__item-excerpt">

														<?php the_excerpt(); ?>

													</div>

												<?php endif; ?>

											</li>

										<?php endwhile; ?>

									</ul>

									<?php // Pagination
									the_posts_pagination(); ?>

								<?php else : ?>

									<?php lsvr_bluecollar_the_alert_message( sprintf( esc_html__( 'Sorry, no results for %s.', 'bluecollar' ), get_search_query() ) ); ?>

								<?php endif; ?>

							</div>
							<!-- PAGE CONTENT : end -->

						</div>

					</div>
				</main>
				<!-- MAIN : end -->

			</div>
		</div>
	</div>
</div>
<!-- CORE COLUMNS : end -->

<?php get_footer(); ?>