<?php get_header(); ?>

<?php // Page title
get_template_part( 'template-parts/page-title' ); ?>

<?php // Main begin
get_template_part( 'template-parts/main-begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_gallery-post-page post-single lsvr_gallery-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<?php // Gallery  images
				if ( ! empty( lsvr_bluecollar_get_gallery_images( get_the_ID() ) ) ) : ?>

					<!-- IMAGE LIST : begin -->
					<ul class="post__image-list lsvr-grid">

						<?php foreach ( lsvr_bluecollar_get_gallery_images( get_the_ID() ) as $image ) : ?>
							<li <?php lsvr_bluecollar_the_gallery_post_single_grid_column_class( 'post__image-item' ); ?>>
								<a href="<?php echo esc_url( $image[ 'full_url' ] ); ?>"
									class="post__image-link lsvr-open-in-lightbox"
									title="<?php echo esc_attr( $image[ 'title' ] ); ?>">
									<img class="post__image"
										<?php if ( get_theme_mod( 'lsvr_gallery_single_grid_columns', 3 ) > 2 &&
										! empty( $image[ 'medium_url' ] ) ) : ?>
											src="<?php echo esc_url( $image[ 'medium_url' ] ); ?>"
										<?php else : ?>
											src="<?php echo esc_url( $image[ 'full_url' ] ); ?>"
										<?php endif; ?>
										alt="<?php echo esc_attr( $image[ 'alt' ] ); ?>">
								</a>
							</li>
						<?php endforeach; ?>

					</ul>
					<!-- IMAGE LIST : end -->

				<?php endif; ?>

				<?php if ( ! empty( get_post()->post_content ) ) : ?>

					<!-- POST CONTENT : begin -->
					<div class="post__content">
						<?php the_content(); ?>
					</div>
					<!-- POST CONTENT : end -->

				<?php endif; ?>

				<?php if ( ( true === get_theme_mod( 'lsvr_gallery_single_date_enable', true ) ) ||
					( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' ) ) ||
					( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_gallery_tag' ) ) ) : ?>

					<!-- POST FOOTER : begin -->
					<footer class="post__footer">

						<!-- POST META : begin -->
						<p class="post__meta">

							<?php if ( true === get_theme_mod( 'lsvr_gallery_single_date_enable', true ) ) : ?>

								<time class="post__meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>">
									<?php echo get_the_date(); ?>
								</time>

							<?php endif; ?>

							<?php if ( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' ) ) : ?>
								<span class="post__meta-categories"><?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'lsvr_gallery_cat', esc_html__( 'in %s', 'bluecollar' ) ); ?></span>
							<?php endif; ?>

						</p>
						<!-- POST META : end -->

						<?php if ( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_gallery_tag' ) ) : ?>

							<!-- POST TAGS : begin -->
							<div class="post__tags">
								<h6 class="screen-reader-text"><?php esc_html_e( 'Tags:', 'bluecollar' ); ?></h6>
								<?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'lsvr_gallery_tag', '%s', '' ); ?>
							</div>
							<!-- POST TAGS : end -->

						<?php endif; ?>

					</footer>
					<!-- POST FOOTER : end -->

				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_bluecollar_gallery_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

		<?php // Post navigation
		get_template_part( 'template-parts/single-navigation' ); ?>

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // Main end
get_template_part( 'template-parts/main-end' ); ?>

<?php get_footer(); ?>