<?php get_header(); ?>

<?php // Page title
get_template_part( 'template-parts/page-title' ); ?>

<?php // Main begin
get_template_part( 'template-parts/main-begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_person-post-page post-single lsvr_person-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<?php if ( ! empty( get_post()->post_content ) ) : ?>

					<!-- POST CONTENT : begin -->
					<div class="post__content">
						<?php the_content(); ?>
					</div>
					<!-- POST CONTENT : end -->

				<?php endif; ?>

				<?php // Contact info
				get_template_part( 'template-parts/lsvr_person/contact-info' ); ?>

				<?php // Person social links
				if ( ! empty( lsvr_bluecollar_get_person_social_links( get_the_ID() ) ) ) : ?>

					<ul class="post__social-list">
						<?php foreach ( lsvr_bluecollar_get_person_social_links( get_the_ID() ) as $type => $link ) : ?>
							<li class="post__social-item">
								<a href="<?php echo esc_url( $link ); ?>" class="post__social-link" target="_blank">
									<i class="post__social-icon lsvr_person-social-icon lsvr_person-social-icon--<?php echo esc_attr( $type ); ?>"></i>
								</a>
							</li>
						<?php endforeach; ?>
					</ul>

				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_bluecollar_person_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

		<?php // Post navigation
		get_template_part( 'template-parts/single-navigation' ); ?>

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // Main end
get_template_part( 'template-parts/main-end' ); ?>

<?php get_footer(); ?>