<?php get_header(); ?>

<?php // Page title
get_template_part( 'template-parts/page-title' ); ?>

<?php // Main begin
get_template_part( 'template-parts/main-begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_project-post-page post-single lsvr_project-post-single lsvr_project-post-single--layout-<?php echo esc_attr( lsvr_bluecollar_get_project_layout( get_the_ID() ) ); ?>">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<?php // Layout
				get_template_part( 'template-parts/lsvr_project/single-layout', lsvr_bluecollar_get_project_layout( get_the_ID() ) ); ?>

				<?php if ( ( true === get_theme_mod( 'lsvr_project_single_date_enable', true ) ) ||
					( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_project_cat' ) ) ||
					( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_project_tag' ) ) ) : ?>

					<!-- POST FOOTER : begin -->
					<footer class="post__footer">

						<!-- POST META : begin -->
						<p class="post__meta">

							<?php if ( true === get_theme_mod( 'lsvr_project_single_date_enable', true ) ) : ?>

								<time class="post__meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>">
									<?php echo get_the_date(); ?>
								</time>

							<?php endif; ?>

							<?php if ( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_project_cat' ) ) : ?>
								<span class="post__meta-categories"><?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'lsvr_project_cat', esc_html__( 'in %s', 'bluecollar' ) ); ?></span>
							<?php endif; ?>

						</p>
						<!-- POST META : end -->

						<?php if ( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_project_tag' ) ) : ?>

							<!-- POST TAGS : begin -->
							<div class="post__tags">
								<h6 class="screen-reader-text"><?php esc_html_e( 'Tags:', 'bluecollar' ); ?></h6>
								<?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'lsvr_project_tag', '%s', '' ); ?>
							</div>
							<!-- POST TAGS : end -->

						<?php endif; ?>

					</footer>
					<!-- POST FOOTER : end -->

				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_bluecollar_project_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

		<?php // Post navigation
		get_template_part( 'template-parts/single-navigation' ); ?>

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // Main end
get_template_part( 'template-parts/main-end' ); ?>

<?php get_footer(); ?>