<?php get_header(); ?>

<?php // Page title
get_template_part( 'template-parts/page-title' ); ?>

<?php // Main begin
get_template_part( 'template-parts/main-begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_service-post-page post-single lsvr_service-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">


				<?php if ( ! empty( get_post()->post_content ) ) : ?>

					<!-- POST CONTENT : begin -->
					<div class="post__content">
						<?php the_content(); ?>
					</div>
					<!-- POST CONTENT : end -->

				<?php endif; ?>

				<?php // Service gallery
				if ( true === lsvr_bluecollar_has_service_images( get_the_ID() ) ) : ?>

					<div class="post__gallery">

						<?php if ( ! empty( get_theme_mod( 'lsvr_service_single_gallery_title', esc_html__( 'Gallery', 'bluecollar' ) ) ) ) : ?>
							<h3 class="post__gallery-title">
								<?php echo esc_html( get_theme_mod( 'lsvr_service_single_gallery_title', esc_html__( 'Gallery', 'bluecollar' ) ) ); ?>
							</h3>
						<?php endif; ?>

						<!-- IMAGE LIST : begin -->
						<ul class="post__image-list lsvr-grid">

							<?php foreach ( lsvr_bluecollar_get_service_images( get_the_ID() ) as $image ) : ?>
								<li class="post__image-item">
									<a href="<?php echo esc_url( $image[ 'full_url' ] ); ?>"
										class="post__image-link lsvr-open-in-lightbox"
										title="<?php echo esc_attr( $image[ 'title' ] ); ?>">
										<img class="post__image" src="<?php echo esc_url( $image[ 'medium_url' ] ); ?>"
											alt="<?php echo esc_attr( $image[ 'alt' ] ); ?>">
									</a>
								</li>
							<?php endforeach; ?>

						</ul>
						<!-- IMAGE LIST : end -->

					</div>

				<?php endif; ?>

				<?php if ( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_service_cat' ) ||
					( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_service_tag' ) ) ) : ?>

					<!-- POST FOOTER : begin -->
					<footer class="post__footer">

						<?php if ( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_service_cat' ) ) : ?>

							<!-- POST META : begin -->
							<p class="post__meta">

								<?php if ( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_service_cat' ) ) : ?>
									<span class="post__meta-categories"><?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'lsvr_service_cat', esc_html__( 'in %s', 'bluecollar' ) ); ?></span>
								<?php endif; ?>

							</p>
							<!-- POST META : end -->

						<?php endif; ?>

						<?php if ( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_service_tag' ) ) : ?>

							<!-- POST TAGS : begin -->
							<div class="post__tags">
								<h6 class="screen-reader-text"><?php esc_html_e( 'Tags:', 'bluecollar' ); ?></h6>
								<?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'lsvr_service_tag', '%s', '' ); ?>
							</div>
							<!-- POST TAGS : end -->

						<?php endif; ?>

					</footer>
					<!-- POST FOOTER : end -->

				<?php endif; ?>

				<?php // Add custom code at post bottom
				do_action( 'lsvr_bluecollar_service_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

		<?php // Post navigation
		get_template_part( 'template-parts/single-navigation' ); ?>

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // Main end
get_template_part( 'template-parts/main-end' ); ?>

<?php get_footer(); ?>