<?php get_header(); ?>

<?php // Page title
get_template_part( 'template-parts/page-title' ); ?>

<?php // Main begin
get_template_part( 'template-parts/main-begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="lsvr_testimonial-post-page post-single lsvr_testimonial-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class( 'post' ); ?>>
			<div class="post__inner">

				<!-- POST QUOTE : begin -->
				<blockquote class="post__quote">

					<?php the_content(); ?>

					<footer class="post__footer<?php if ( has_post_thumbnail() ) { echo ' post__footer--has-thumbnail'; } ?>">

						<?php if ( has_post_thumbnail() ) : ?>
							<p class="post__thumbnail">
								<?php the_post_thumbnail( 'thumbnail' ); ?>
							</p>
						<?php endif; ?>

						<cite class="post__title">

							<span class="post__title-name"><?php the_title(); ?></span>

							<?php if ( lsvr_bluecollar_has_testimonial_author_description( get_the_ID() ) ) : ?>
								<span class="post__title-description">
									<?php lsvr_bluecollar_the_testimonial_author_description( get_the_ID() ); ?>
								</span>
							<?php endif; ?>

						</cite>

					</footer>

				</blockquote>
				<!-- POST QUOTE : end -->

			</div>
		</article>
		<!-- POST : end -->

		<?php // Post navigation
		get_template_part( 'template-parts/single-navigation' ); ?>

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // Main end
get_template_part( 'template-parts/main-end' ); ?>

<?php get_footer(); ?>