<?php get_header(); ?>

<?php // Page title
get_template_part( 'template-parts/page-title' ); ?>

<?php // Main begin
get_template_part( 'template-parts/main-begin' ); ?>

<!-- POST SINGLE : begin -->
<div class="post-single blog-post-single">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<!-- POST : begin -->
		<article <?php post_class(); ?>>
			<div class="post__inner">

				<?php if ( has_post_thumbnail() ) : ?>

					<!-- POST THUMBNAIL : begin -->
					<p class="post__thumbnail">
						<?php the_post_thumbnail(); ?>
					</p>
					<!-- POST THUMBNAIL : end -->

				<?php endif; ?>

				<!-- POST CONTENT : begin -->
				<div class="post__content">
					<?php the_content(); ?>
					<?php wp_link_pages(); ?>
				</div>
				<!-- POST CONTENT : end -->

				<!-- POST FOOTER : begin -->
				<footer class="post__footer">

					<!-- POST META : begin -->
					<p class="post__meta">

						<time class="post__meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>">
							<?php echo get_the_date(); ?>
						</time>

						<?php if ( true === get_theme_mod( 'blog_single_author_enable', true ) ) : ?>
							<span class="post__meta-author"><?php echo sprintf( esc_html__( 'by %s', 'bluecollar' ), '<a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" class="post__meta-author-link" rel="author">' . get_the_author() . '</a>' ); ?></span>
						<?php endif; ?>

						<?php if ( lsvr_bluecollar_has_post_terms( get_the_ID(), 'category' ) ) : ?>
							<span class="post__meta-categories"><?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'category', esc_html__( 'in %s', 'bluecollar' ) ); ?></span>
						<?php endif; ?>

					</p>
					<!-- POST META : end -->

					<?php if ( true === lsvr_bluecollar_has_post_terms( get_the_ID(), 'post_tag' ) ) : ?>

						<!-- POST TAGS : begin -->
						<div class="post__tags">
							<h6 class="screen-reader-text"><?php esc_html_e( 'Tags:', 'bluecollar' ); ?></h6>
							<?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'post_tag', '%s', '' ); ?>
						</div>
						<!-- POST TAGS : end -->

					<?php endif; ?>

				</footer>
				<!-- POST FOOTER : end -->

				<?php // Add custom code at post bottom
				do_action( 'lsvr_bluecollar_blog_single_bottom' ); ?>

			</div>
		</article>
		<!-- POST : end -->

		<?php // Post navigation
		get_template_part( 'template-parts/single-navigation' ); ?>

	    <?php // Post comments
	    comments_template(); ?>

	<?php endwhile; endif; ?>

</div>
<!-- POST SINGLE : end -->

<?php // Main end
get_template_part( 'template-parts/main-end' ); ?>

<?php get_footer(); ?>