<?php if ( true === apply_filters( 'lsvr_bluecollar_post_archive_categories_enable', false ) &&
	taxonomy_exists( apply_filters( 'lsvr_bluecollar_post_archive_categories_taxonomy', '' ) ) &&
	! empty( get_terms( apply_filters( 'lsvr_bluecollar_post_archive_categories_taxonomy', '' ) ) ) ) : ?>

	<!-- POST ARCHIVE CATEGORIES : begin -->
	<div class="post-archive-categories">
		<h6 class="screen-reader-text"><?php esc_html_e( 'Categories:', 'bluecollar' ); ?></h6>
		<ul class="post-archive-categories__list">

			<?php // "All" link
			if ( is_category() || is_tax( apply_filters( 'lsvr_bluecollar_post_archive_categories_taxonomy', '' ) ) ) : ?>

				<li class="post-archive-categories__item post-archive-categories__item--all">
					<a href="<?php echo esc_url( get_post_type_archive_link( apply_filters( 'lsvr_bluecollar_current_post_type', '' ) ) ); ?>"
						class="post-archive-categories__item-link"><?php esc_html_e( 'All', 'bluecollar' ); ?></a>
				</li>

			<?php else : ?>

				<li class="post-archive-categories__item post-archive-categories__item--all post-archive-categories__item--active">
					<?php esc_html_e( 'All', 'bluecollar' ); ?>
				</li>

			<?php endif; ?>

			<?php // Categories
			foreach ( get_terms( apply_filters( 'lsvr_bluecollar_post_archive_categories_taxonomy', '' ) ) as $term ) : ?>

				<?php if ( get_queried_object_id() === $term->term_id ) : ?>

					<li class="post-archive-categories__item post-archive-categories__item--category post-archive-categories__item--active">
						<?php echo esc_html( $term->name ); ?>
					</li>

				<?php else : ?>

					<li class="post-archive-categories__item post-archive-categories__item--category">
						<a href="<?php echo esc_url( get_term_link( $term->term_id, apply_filters( 'lsvr_bluecollar_post_archive_categories_taxonomy', '' ) ) ); ?>"
							class="post-archive-categories__item-link"><?php echo esc_html( $term->name ); ?></a>
					</li>

				<?php endif; ?>

			<?php endforeach; ?>

		</ul>
	</div>
	<!-- POST ARCHIVE CATEGORIES : end -->

<?php endif; ?>