<!-- POST ARCHIVE : begin -->
<div <?php lsvr_bluecollar_the_blog_post_archive_class( 'blog-post-archive--grid' ); ?>>

	<?php // Archive intro
	get_template_part( 'template-parts/archive-intro' ); ?>

	<?php // Archive categories
	get_template_part( 'template-parts/archive-categories' ); ?>

	<?php if ( have_posts() ) : ?>

		<!-- POST ARCHIVE LIST : begin -->
		<div <?php lsvr_bluecollar_the_blog_post_archive_list_class(); ?>>

			<?php while ( have_posts() ) : the_post(); ?>

				<div <?php lsvr_bluecollar_the_blog_post_archive_grid_column_class(); ?>>

					<!-- POST : begin -->
					<article <?php post_class(); ?>>
						<div class="post__inner">

							<?php if ( has_post_thumbnail() ) : ?>

								<!-- POST THUMBNAIL : begin -->
								<p class="post__thumbnail">
									<a href="<?php the_permalink(); ?>" class="post__thumbnail-link"><?php the_post_thumbnail(); ?></a>
								</p>
								<!-- POST THUMBNAIL : end -->

							<?php endif; ?>

							<!-- POST HEADER : begin -->
							<header class="post__header">

								<!-- POST TITLE : begin -->
								<h2 class="post__title">
									<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark"><?php the_title(); ?></a>
								</h2>
								<!-- POST TITLE : end -->

								<!-- POST META : begin -->
								<p class="post__meta">

									<time class="post__meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>">
										<?php echo get_the_date(); ?>
									</time>

									<?php if ( lsvr_bluecollar_has_post_terms( get_the_ID(), 'category' ) ) : ?>

										<span class="post__meta-categories">
											<?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'category', esc_html__( 'in %s', 'bluecollar' ) ); ?>
										</span>

									<?php endif; ?>

								</p>
								<!-- POST META : end -->

							</header>
							<!-- POST HEADER : end -->

							<!-- POST CONTENT : begin -->
							<div class="post__content">
								<?php if ( ! empty( $post->post_excerpt ) ) : ?>

									<?php the_excerpt(); ?>

									<!-- POST PERMALINK : begin -->
									<p class="post__permalink">
										<a href="<?php the_permalink(); ?>" class="post__permalink-link" rel="bookmark">
											<?php esc_html_e( 'Read More', 'bluecollar' ); ?>
										</a>
									</p>
									<!-- POST PERMALINK : end -->

								<?php else : ?>

									<?php the_content(); ?>

								<?php endif; ?>
							</div>
							<!-- POST CONTENT : end -->

						</div>
					</article>
					<!-- POST : end -->

				</div>

			<?php endwhile; ?>

		</div>
		<!-- POST ARCHIVE LIST : end -->

		<?php // Pagination
		the_posts_pagination(); ?>

	<?php else : ?>

		<?php lsvr_bluecollar_the_alert_message( esc_html__( 'There are no posts', 'bluecollar' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->