<?php if ( true === get_theme_mod( 'footer_cta_enable', false ) ) : ?>

	<!-- FOOTER CTA : begin -->
	<div class="footer-cta<?php if ( ! empty( get_theme_mod( 'footer_cta_button_label', '' ) ) && ! empty( get_theme_mod( 'footer_cta_button_url', '' ) ) ) { echo ' footer-cta--has-button'; } ?>">
		<div class="lsvr-container">
			<div class="footer-cta__inner">

				<?php // CTA Title
				if ( ! empty( get_theme_mod( 'footer_cta_title', '' ) ) ) : ?>

					<h3 class="footer-cta__title">
						<?php echo wp_kses( get_theme_mod( 'footer_cta_title', '' ), array(
							'strong' => array(),
						) ); ?>
					</h3>

				<?php endif; ?>

				<?php // CTA Text
				if ( ! empty( get_theme_mod( 'footer_cta_text', '' ) ) ) : ?>

					<div class="footer-cta__text">
						<?php echo wpautop( wp_kses( get_theme_mod( 'footer_cta_text', '' ), array(
							'a' => array(
								'href' => array(),
								'target' => array(),
							),
							'br' => array(),
							'em' => array(),
							'p' => array(),
							'strong' => array(),
						) ) ); ?>
					</div>

				<?php endif; ?>

				<?php // CTA Button
				if ( ! empty( get_theme_mod( 'footer_cta_button_label', '' ) ) && ! empty( get_theme_mod( 'footer_cta_button_url', '' ) ) ) : ?>

					<a href="<?php echo esc_url( get_theme_mod( 'footer_cta_button_url', '' ) ); ?>" class="c-button footer-cta__button"
						<?php if ( true === get_theme_mod( 'footer_cta_button_url_new_tab_enable', false ) ) { echo ' target="_blank"'; } ?>>
						<?php echo esc_html( get_theme_mod( 'footer_cta_button_label', '' ) ); ?>
					</a>

				<?php endif; ?>

			</div>
		</div>
	</div>
	<!-- FOOTER CTA : end -->

<?php endif; ?>