<?php if ( has_nav_menu( 'lsvr-bluecollar-header-menu-primary' ) ) : ?>

	<!-- HEADER MENU PRIMARY : begin -->
	<nav id="header-menu-primary" class="header-menu-primary"
        data-label-expand-popup="<?php echo esc_attr( esc_html__( 'Expand submenu', 'bluecollar' ) ); ?>"
        data-label-collapse-popup="<?php echo esc_attr( esc_html__( 'Collapse submenu', 'bluecollar' ) ); ?>"

		<?php if ( ! empty( lsvr_bluecollar_get_menu_name_by_location( 'lsvr-bluecollar-header-menu-primary' ) ) ) : ?>
			aria-label="<?php echo lsvr_bluecollar_get_menu_name_by_location( 'lsvr-bluecollar-header-menu-primary' ); ?>"
		<?php endif; ?>>

	    <?php wp_nav_menu(
	        array(
	            'theme_location' => 'lsvr-bluecollar-header-menu-primary',
				'container' => '',
				'menu_class' => 'header-menu-primary__list',
				'fallback_cb' => '',
				'items_wrap' => '<ul id="%1$s" class="%2$s" role="menu">%3$s</ul>',
				'walker' => new Lsvr_Bluecollar_Header_Menu_Primary_Walker(),
				'depth' => 4,
			)
		); ?>

	</nav>
	<button type="button" class="header-menu-primary__toggle"><i class="header-menu-primary__toggle-icon" aria-hidden="true"></i></button>
	<!-- HEADER MENU PRIMARY : end -->

<?php endif; ?>