<?php if ( true === get_theme_mod( 'header_social_links_enable', true ) &&
	! empty( lsvr_bluecollar_get_social_links() ) ) : ?>

	<!-- HEADER SOCIAL LINKS : begin -->
	<div class="header-social header-topbar__item">
		<ul class="header-social__list">

			<?php foreach ( lsvr_bluecollar_get_social_links() as $social_link ) : ?>

				<?php if ( ! empty( $social_link['url'] ) && ! empty( $social_link['icon'] ) && ! empty( $social_link['name'] ) ) : ?>

					<li class="header-social__item header-social__item--<?php echo esc_attr( $social_link['name'] ); ?>">
						<a class="header-social__item-link header-social__item-link--<?php echo esc_attr( $social_link['name'] ); ?>" target="_blank"
							<?php if ( filter_var( $social_link['url'], FILTER_VALIDATE_EMAIL ) ) : ?>
								href="mailto:<?php echo esc_attr( $social_link['url'] ); ?>"
							<?php else : ?>
								href="<?php echo esc_url( $social_link['url'] ); ?>"
							<?php endif; ?>
							<?php if ( ! empty( $social_link['label'] ) ) { echo ' title="' . esc_attr( $social_link['label'] ) . '"'; } ?>>
							<i class="header-social__icon <?php echo esc_attr( $social_link['icon'] ); ?>"></i>
						</a>
					</li>

				<?php endif; ?>

			<?php endforeach; ?>

		</ul>
	</div>
	<!-- HEADER SOCIAL LINKS : end -->

<?php endif; ?>