<!-- POST ARCHIVE : begin -->
<div <?php lsvr_bluecollar_the_faq_post_archive_class( 'lsvr_faq-post-archive--default' ); ?>>

	<?php // Archive intro
	get_template_part( 'template-parts/archive-intro' ); ?>

	<?php // Archive categories
	get_template_part( 'template-parts/archive-categories' ); ?>

	<?php if ( have_posts() ) : ?>

		<!-- POST ARCHIVE LIST : begin -->
		<div <?php lsvr_bluecollar_the_faq_post_archive_list_class(); ?>>

			<?php while ( have_posts() ) : the_post(); ?>

				<!-- POST : begin -->
				<article <?php post_class( 'post' ); ?> id="<?php echo esc_attr( $post->post_name ); ?>">
					<div class="post__inner">

						<!-- POST HEADER : begin -->
						<header class="post__header">

							<!-- POST TITLE : begin -->
							<h2 class="post__title">
								<?php the_title(); ?>
							</h2>
							<!-- POST TITLE : end -->

						</header>
						<!-- POST HEADER : end -->

						<!-- POST CONTENT WRAPPER : begin -->
						<div class="post__content-wrapper">

							<!-- POST CONTENT : begin -->
							<div class="post__content">

								<?php if ( ! empty( $post->post_excerpt ) ) : ?>

									<?php the_excerpt(); ?>

									<!-- POST PERMALINK : begin -->
									<p class="post__permalink">
										<a href="<?php the_permalink(); ?>" class="post__permalink-link" rel="bookmark">
											<?php esc_html_e( 'Read More', 'bluecollar' ); ?>
										</a>
									</p>
									<!-- POST PERMALINK : end -->

								<?php else : ?>

									<?php the_content(); ?>

								<?php endif; ?>

							</div>
							<!-- POST CONTENT : end -->

							<?php if ( lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_faq_cat' ) || empty( $post->post_excerpt ) ) : ?>

								<!-- POST FOOTER : begin -->
								<footer class="post__footer">

									<?php if ( lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_faq_cat' ) ) : ?>

										<!-- POST META : begin -->
										<p class="post__meta">
											<span class="post__meta-category">
												<?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'lsvr_faq_cat', esc_html__( 'in %s', 'bluecollar' ) ); ?>
											</span>
										</p>
										<!-- POST META : end -->

									<?php endif; ?>

									<?php if ( empty( $post->post_excerpt ) ) : ?>

										<!-- POST PERMALINK : begin -->
										<p class="post__footer-permalink">
											<a href="<?php the_permalink(); ?>" class="post__footer-permalink-link" rel="bookmark"><?php esc_html_e( 'Permalink', 'bluecollar' ); ?></a>
										</p>
										<!-- POST PERMALINK : end -->

									<?php endif; ?>

								</footer>
								<!-- POST FOOTER : end -->

							<?php endif; ?>

						</div>
						<!-- POST CONTENT WRAPPER : end -->

					</div>
				</article>
				<!-- POST : end -->

			<?php endwhile; ?>

		</div>
		<!-- POST ARCHIVE LIST : end -->

		<?php // Pagination
		the_posts_pagination(); ?>

	<?php else : ?>

		<?php lsvr_bluecollar_the_alert_message( esc_html__( 'There are no FAQ', 'bluecollar' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->