<!-- POST ARCHIVE : begin -->
<div <?php lsvr_bluecollar_the_gallery_post_archive_class( 'lsvr_gallery-post-archive--default' ); ?>>

	<?php // Archive intro
	get_template_part( 'template-parts/archive-intro' ); ?>

	<?php // Archive categories
	get_template_part( 'template-parts/archive-categories' ); ?>

	<?php if ( have_posts() ) : ?>

		<!-- POST ARCHIVE LIST : begin -->
		<div <?php lsvr_bluecollar_the_gallery_post_archive_list_class(); ?>>

			<?php while ( have_posts() ) : the_post(); ?>

				<div <?php lsvr_bluecollar_the_gallery_post_archive_grid_column_class(); ?>>

					<!-- POST : begin -->
					<article <?php post_class( 'post' ); ?>
						<?php lsvr_bluecollar_the_gallery_post_background_thumbnail( get_the_ID() ); ?>>
						<div class="post__inner">
							<div class="post__bg">

								<!-- POST HEADER : begin -->
								<header class="post__header">

									<!-- POST TITLE : begin -->
									<h2 class="post__title">
										<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark"><?php the_title(); ?></a>
									</h2>
									<!-- POST TITLE : end -->

								</header>
								<!-- POST HEADER : end -->

								<?php if ( true === get_theme_mod( 'lsvr_gallery_archive_date_enable', true ) ||
									lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' ) ||
									true === get_theme_mod( 'lsvr_gallery_archive_image_count_enable', true ) ) : ?>

									<!-- POST META : begin -->
									<p class="post__meta">

										<?php if ( true === get_theme_mod( 'lsvr_gallery_archive_date_enable', true ) ) : ?>

											<time class="post__meta-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>">
												<?php echo esc_html( get_the_date() ); ?>
											</time>

										<?php endif; ?>

										<?php if ( lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_gallery_cat' ) ) : ?>

											<span class="post__meta-category">
												<?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'lsvr_gallery_cat', esc_html__( 'in %s', 'bluecollar' ) ); ?>
											</span>

										<?php endif; ?>

										<?php if ( true === get_theme_mod( 'lsvr_gallery_archive_image_count_enable', true ) ) : ?>

											<span class="post__meta-images">
												<?php echo esc_html( sprintf( _n( '%d image', '%d images', lsvr_bluecollar_get_gallery_images_count( get_the_ID() ), 'bluecollar' ), lsvr_bluecollar_get_gallery_images_count( get_the_ID() ) ) ); ?>
											</span>

										<?php endif; ?>

									</p>
									<!-- POST META : end -->

								<?php endif; ?>

								<!-- OVERLAY LINK : begin -->
								<a href="<?php the_permalink(); ?>"
									class="post__overlay-link">
									<span class="screen-reader-text"><?php esc_html_e( 'Open Gallery', 'bluecollar' ); ?></span>
								</a>
								<!-- OVERLAY LINK : end -->

							</div>
						</div>
					</article>
					<!-- POST : end -->

				</div>

			<?php endwhile; ?>

		</div>
		<!-- POST ARCHIVE LIST : end -->

		<?php // Pagination
		the_posts_pagination(); ?>

	<?php else : ?>

		<?php lsvr_bluecollar_the_alert_message( esc_html__( 'There are no galleries', 'bluecollar' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->