<!-- POST ARCHIVE : begin -->
<div <?php lsvr_bluecollar_the_person_post_archive_class( 'lsvr_person-post-archive--default' );?>>

	<?php // Archive intro
	get_template_part( 'template-parts/archive-intro' ); ?>

	<?php // Archive categories
	get_template_part( 'template-parts/archive-categories' ); ?>

	<?php if ( have_posts() ) : ?>

		<!-- POST ARCHIVE LIST : begin -->
		<div <?php lsvr_bluecollar_the_person_post_archive_list_class(); ?>>

			<?php while ( have_posts() ) : the_post(); ?>

				<div <?php lsvr_bluecollar_the_person_post_archive_grid_column_class(); ?>>

					<!-- POST : begin -->
					<article <?php post_class( 'post' ); ?>>
						<div class="post__inner">

							<?php if ( has_post_thumbnail() ) : ?>

								<!-- POST THUMBNAIL : begin -->
								<p class="post__thumbnail">
									<a href="<?php the_permalink(); ?>" class="post__thumbnail-link">
										<?php the_post_thumbnail( 'thumbnail' ); ?>
									</a>
								</p>
								<!-- POST THUMBNAIL : end -->

							<?php endif; ?>

							<!-- POST TITLE : begin -->
							<h2 class="post__title">
								<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark"><?php the_title(); ?></a>
							</h2>
							<!-- POST TITLE : end -->

							<?php if ( lsvr_bluecollar_has_person_role( get_the_ID() ) ) : ?>
								<h4 class="post__subtitle"><?php lsvr_bluecollar_the_person_role( get_the_ID() ); ?></h4>
							<?php endif; ?>

							<?php if ( ! empty( $post->post_excerpt ) || ! empty( $post->post_content ) ) : ?>

								<!-- POST CONTENT : begin -->
								<div class="post__content">

									<?php if ( ! empty( $post->post_excerpt ) ) : ?>

										<?php the_excerpt(); ?>

									<?php else : ?>

										<?php the_content(); ?>

									<?php endif; ?>

								</div>
								<!-- POST CONTENT : end -->

							<?php endif; ?>

							<?php // Contact info
							get_template_part( 'template-parts/lsvr_person/contact-info' ); ?>

							<?php // Social links
							get_template_part( 'template-parts/lsvr_person/social-links' ); ?>

						</div>
					</article>
					<!-- POST : end -->

				</div>

			<?php endwhile; ?>

		</div>
		<!-- POST ARCHIVE LIST : end -->

		<?php // Pagination
		the_posts_pagination(); ?>

	<?php else : ?>

		<?php lsvr_bluecollar_the_alert_message( esc_html__( 'There are no person posts', 'bluecollar' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->