<?php if ( lsvr_bluecollar_has_person_contact_info( get_the_ID() ) ) : ?>

	<ul class="post__contact">

		<?php // Add custom code at the top of person contact info
		do_action( 'lsvr_bluecollar_person_contact_info_top' ); ?>

		<?php foreach ( lsvr_bluecollar_get_person_contact_info( get_the_ID() ) as $profile => $fields ) : ?>

			<li class="post__contact-item post__contact-item--<?php echo esc_attr( $profile ); ?>"
				<?php if ( ! empty( $fields['title'] ) ) { echo ' title="' . esc_attr( $fields['title'] ) . '"'; } ?>>

				<i class="post__contact-item-icon post__contact-item-icon--<?php echo esc_attr( $profile ); echo ! empty( $fields['icon'] ) ? ' ' . esc_attr( $fields['icon'] ) : ''; ?>"
					aria-hidden="true"></i>

				<?php echo wp_kses( $fields['label'], array(
					'a' => array(
						'href' => array(),
						'target' => array(),
						'title' => array(),
					),
					'strong' => array(),
				)); ?>

			</li>

		<?php endforeach; ?>

		<?php // Add custom code at the bottom of person contact info
		do_action( 'lsvr_bluecollar_person_contact_info_bottom' ); ?>

	</ul>

<?php endif; ?>