<?php if ( lsvr_bluecollar_has_project_custom_fields( get_the_ID() ) ) : ?>

	<!-- POST FIELDS : begin -->
	<div class="post__fields">

		<dl class="post__fields-list">

			<?php foreach ( lsvr_bluecollar_get_project_custom_fields( get_the_ID() ) as $field ) : ?>

				<?php if ( ! empty( $field['title'] ) ) : ?>
					<dt class="post__fields-item-title"><?php echo esc_html( $field['title'] ); ?></dt>
				<?php endif; ?>

				<?php if ( ! empty( $field['text'] ) ) : ?>
					<dd class="post__fields-item-text">
						<?php echo wp_kses( $field['text'], array(
							'a' => array(
								'href' => array(),
							),
							'strong' => array(),
						) ); ?>
					</dd>
				<?php endif; ?>

			<?php endforeach; ?>

		</dl>

	</div>
	<!-- POST FIELDS : end -->

<?php endif; ?>