<?php // Gallery  images
if ( ! empty( lsvr_bluecollar_has_project_images( get_the_ID() ) ) ) : ?>

	<!-- IMAGE LIST : begin -->
	<ul class="post__image-list lsvr-grid">

		<?php foreach ( lsvr_bluecollar_get_project_images( get_the_ID() ) as $image ) : ?>
			<li <?php lsvr_bluecollar_the_project_post_single_grid_column_class( 'post__image-item' ); ?>>
				<a href="<?php echo esc_url( $image[ 'full_url' ] ); ?>"
					class="post__image-link lsvr-open-in-lightbox"
					title="<?php echo esc_attr( $image[ 'title' ] ); ?>">
					<img class="post__image"
						<?php if ( (int) lsvr_bluecollar_get_project_gallery_grid_columns( get_the_ID() ) > 2 &&
						! empty( $image[ 'medium_url' ] ) ) : ?>
							src="<?php echo esc_url( $image[ 'medium_url' ] ); ?>"
						<?php else : ?>
							src="<?php echo esc_url( $image[ 'full_url' ] ); ?>"
						<?php endif; ?>
						alt="<?php echo esc_attr( $image[ 'alt' ] ); ?>">
				</a>
			</li>
		<?php endforeach; ?>

	</ul>
	<!-- IMAGE LIST : end -->

<?php endif; ?>