<!-- POST ARCHIVE : begin -->
<div <?php lsvr_bluecollar_the_service_post_archive_class( 'lsvr_service-post-archive--default' ); ?>>

	<?php // Archive intro
	get_template_part( 'template-parts/archive-intro' ); ?>

	<?php // Archive categories
	get_template_part( 'template-parts/archive-categories' ); ?>

	<?php if ( have_posts() ) : ?>

		<!-- POST ARCHIVE LIST : begin -->
		<div <?php lsvr_bluecollar_the_service_post_archive_list_class(); ?>>

			<?php while ( have_posts() ) : the_post(); ?>

				<div <?php lsvr_bluecollar_the_service_post_archive_grid_column_class(); ?>>

					<!-- POST : begin -->
					<article <?php post_class( 'post' ); ?>>
						<div class="post__inner">

							<?php if ( has_post_thumbnail() ) : ?>

								<!-- POST THUMBNAIL : begin -->
								<p class="post__thumbnail">
									<a href="<?php the_permalink(); ?>" class="post__thumbnail-link"><?php the_post_thumbnail(); ?></a>
								</p>
								<!-- POST THUMBNAIL : end -->

							<?php endif; ?>

							<?php if ( lsvr_bluecollar_has_service_icon_class( get_the_ID() ) ) : ?>
								<p class="post__icon">
									<i class="post__icon-image <?php echo esc_attr( lsvr_bluecollar_get_service_icon_class( get_the_ID() ) ); ?>"></i>
								</p>
							<?php endif; ?>


							<!-- POST HEADER : begin -->
							<header class="post__header<?php if ( has_post_thumbnail() ) { echo ' post__header--has-thumbnail'; } ?>">

								<!-- POST TITLE : begin -->
								<h2 class="post__title">
									<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark">
										<?php the_title(); ?>
									</a>
								</h2>
								<!-- POST TITLE : end -->

								<?php if ( lsvr_bluecollar_has_post_terms( get_the_ID(), 'lsvr_service_cat' ) ) : ?>

									<!-- POST META : begin -->
									<p class="post__meta">

										<span class="post__meta-category">
											<?php lsvr_bluecollar_the_post_terms( get_the_ID(), 'lsvr_service_cat', esc_html__( 'in %s', 'bluecollar' ) ); ?>
										</span>

									</p>
									<!-- POST META : end -->

								<?php endif; ?>

							</header>
							<!-- POST HEADER : end -->

							<!-- POST CONTENT : begin -->
							<div class="post__content">
								<?php if ( ! empty( $post->post_excerpt ) ) : ?>

									<?php the_excerpt(); ?>

									<!-- POST PERMALINK : begin -->
									<p class="post__permalink">
										<a href="<?php the_permalink(); ?>" class="post__permalink-link" rel="bookmark">
											<?php esc_html_e( 'More Info', 'bluecollar' ); ?>
										</a>
									</p>
									<!-- POST PERMALINK : end -->

								<?php else : ?>

									<?php the_content(); ?>

								<?php endif; ?>
							</div>
							<!-- POST CONTENT : end -->

						</div>
					</article>
					<!-- POST : end -->

				</div>

			<?php endwhile; ?>

		</div>
		<!-- POST ARCHIVE LIST : end -->

		<?php // Pagination
		the_posts_pagination(); ?>

	<?php else : ?>

		<?php lsvr_bluecollar_the_alert_message( esc_html__( 'There are no services', 'bluecollar' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->