<!-- POST ARCHIVE : begin -->
<div <?php lsvr_bluecollar_the_testimonial_post_archive_class( 'lsvr_testimonial-post-archive--default' ); ?>>

	<?php // Archive intro
	get_template_part( 'template-parts/archive-intro' ); ?>

	<?php if ( have_posts() ) : ?>

		<!-- POST ARCHIVE LIST : begin -->
		<div <?php lsvr_bluecollar_the_testimonial_post_archive_list_class(); ?>>

			<?php while ( have_posts() ) : the_post(); ?>

				<div <?php lsvr_bluecollar_the_testimonial_post_archive_grid_column_class(); ?>>

					<!-- POST : begin -->
					<article <?php post_class( 'post' ); ?>>
						<div class="post__inner">

							<!-- POST QUOTE : begin -->
							<blockquote class="post__quote">

								<?php the_content(); ?>

								<footer class="post__footer<?php if ( has_post_thumbnail() ) { echo ' post__footer--has-thumbnail'; } ?>">

									<?php if ( has_post_thumbnail() ) : ?>
										<p class="post__thumbnail">
											<a href="<?php the_permalink(); ?>" class="post__thumbnail-link">
												<?php the_post_thumbnail( 'thumbnail' ); ?>
											</a>
										</p>
									<?php endif; ?>

									<cite class="post__title">

										<a href="<?php the_permalink(); ?>" class="post__title-link" rel="bookmark">
											<?php the_title(); ?>
										</a>

										<?php if ( lsvr_bluecollar_has_testimonial_author_description( get_the_ID() ) ) : ?>
											<span class="post__title-description">
												<?php lsvr_bluecollar_the_testimonial_author_description( get_the_ID() ); ?>
											</span>
										<?php endif; ?>

									</cite>

								</footer>

							</blockquote>
							<!-- POST QUOTE : end -->

						</div>
					</article>
					<!-- POST : end -->

				</div>

			<?php endwhile; ?>

		</div>
		<!-- POST ARCHIVE LIST : end -->

		<?php // Pagination
		the_posts_pagination(); ?>

	<?php else : ?>

		<?php lsvr_bluecollar_the_alert_message( esc_html__( 'There are no testimonials', 'bluecollar' ) ); ?>

	<?php endif; ?>

</div>
<!-- POST ARCHIVE : end -->