<?php if ( true === apply_filters( 'lsvr_bluecollar_page_title_enable', true ) ) : ?>

	<?php // Add custom code before page title
	do_action( 'lsvr_bluecollar_page_title_before' ); ?>

	<!-- PAGE TITLE : begin -->
	<div <?php lsvr_bluecollar_the_page_title_class(); ?>
		<?php lsvr_bluecollar_the_page_title_background_image(); ?>>
		<?php lsvr_bluecollar_the_page_title_overlay(); ?>
		<div class="page-title__inner">
			<div class="lsvr-container">

				<?php // Add custom code at the top of the page title
				do_action( 'lsvr_bluecollar_page_title_top' ); ?>

				<?php // Title
				if ( ! empty( apply_filters( 'lsvr_bluecollar_page_title_title', '' ) ) ) : ?>

					<h1 class="page-title__title">
						<?php echo wp_kses( apply_filters( 'lsvr_bluecollar_page_title_title', '' ), array(
							'a' => array(
								'href' => array(),
							),
							'br' => array(),
							'em' => array(),
							'strong' => array(),
						) ); ?>
					</h1>

				<?php endif; ?>

				<?php // Add custom code after the page title title
				do_action( 'lsvr_bluecollar_page_title_title_after' ); ?>

				<?php // Subtitle
				if ( ! empty( apply_filters( 'lsvr_bluecollar_page_title_subtitle', '' ) ) ) : ?>
					<h3 class="page-title__subtitle">
						<?php echo esc_html( apply_filters( 'lsvr_bluecollar_page_title_subtitle', '' ) ); ?>
					</h3>
				<?php endif; ?>

				<?php // Add custom code at the bottom of the page title
				do_action( 'lsvr_bluecollar_page_title_bottom' ); ?>

			</div>
		</div>
	</div>
	<!-- PAGE TITLE : end -->

	<?php // Add custom code after page title
	do_action( 'lsvr_bluecollar_page_title_after' ); ?>

<?php endif; ?>