<?php if ( true === apply_filters( 'lsvr_bluecollar_post_single_navigation_enable', false ) &&
	( lsvr_bluecollar_has_previous_post() || lsvr_bluecollar_has_next_post() ) ) : ?>

	<!-- POST NAVIGATION : begin -->
	<div class="post-navigation">

		<ul class="post-navigation__list">

			<?php if ( lsvr_bluecollar_has_previous_post() ) : ?>
				<!-- PREVIOUS POST : begin -->
				<li class="post-navigation__prev">
					<div class="post-navigation__prev-inner">
						<h6 class="post-navigation__title">
							<a href="<?php echo esc_url( lsvr_bluecollar_get_previous_post_url() ); ?>"
								class="post-navigation__title-link">
								<?php esc_html_e( 'Previous', 'bluecollar' ); ?>
							</a>
						</h6>
						<a href="<?php echo esc_url( lsvr_bluecollar_get_previous_post_url() ); ?>"
							class="post-navigation__link">
							<?php echo esc_html( lsvr_bluecollar_get_previous_post_title() ); ?>
						</a>
					</div>
				</li>
				<!-- PREVIOUS POST : end -->
			<?php endif; ?>

			<?php if ( lsvr_bluecollar_has_next_post() ) : ?>
				<!-- NEXT POST : begin -->
				<li class="post-navigation__next">
					<div class="post-navigation__next-inner">
						<h6 class="post-navigation__title">
							<a href="<?php echo esc_url( lsvr_bluecollar_get_next_post_url() ); ?>"
								class="post-navigation__title-link">
								<?php esc_html_e( 'Next', 'bluecollar' ); ?>
							</a>
						</h6>
						<a href="<?php echo esc_url( lsvr_bluecollar_get_next_post_url() ); ?>"
							class="post-navigation__link">
							<?php echo esc_html( lsvr_bluecollar_get_next_post_title() ); ?>
						</a>
					</div>
				</li>
				<!-- NEXT POST : end -->
			<?php endif; ?>

		</ul>

	</div>
	<!-- POST NAVIGATION : end -->

<?php endif; ?>