<?php get_header();?>

<!-- CORE : begin -->
<div id="core">

	<?php // PAGE HEADER
	get_template_part( 'components/page-header' ); ?>

	<div class="container">

		<!-- PAGE CONTENT : begin -->
		<div id="page-content">

			<!-- ERROR 404 PAGE : begin -->
			<div class="error-404-page">

				<p class="c-alert-message m-info">
					<i class="ico fa fa-info-circle"></i>
					<?php if ( function_exists( 'pll__' ) ) : ?>
						<?php echo pll__( lsvr_get_field( 'page404_subtitle', __( 'The page you are looking for is no longer available or has been moved.', 'lsvrtheme' ) ) ); ?>
					<?php else: ?>
						<?php echo lsvr_get_field( 'page404_subtitle', __( 'The page you are looking for is no longer available or has been moved.', 'lsvrtheme' ) ); ?>
					<?php endif; ?>
				</p>

				<hr class="c-separator m-size-medium">

				<?php if ( lsvr_get_field( 'page404_enable_posts', true, true ) && lsvr_get_field( 'page404_enable_search', true, true ) ) : ?>
				<div class="row">
					<div class="col-md-6">
				<?php endif; ?>

				<?php // RECENT POSTS
				if ( lsvr_get_field( 'page404_enable_posts', true, true ) ) : ?>

					<?php $recent_posts = wp_get_recent_posts( array(
						'numberposts' => 4,
					)); ?>

					<?php if ( ! empty( $recent_posts ) ) : ?>
					<!-- RECENT POSTS : begin -->
					<h2><?php _e( 'Recent <strong>Posts</strong>', 'lsvrtheme' ); ?></h2>
					<ul>
					<?php foreach( $recent_posts as $recent ) : ?>
						<li><a href="<?php get_permalink( $recent["ID"] ); ?>"><?php echo $recent["post_title"]; ?></a></li>
					<?php endforeach; ?>
					</ul>
					<!-- RECENT POSTS : end -->
					<?php endif; ?>

				<?php endif; ?>

				<?php if ( lsvr_get_field( 'page404_enable_posts', true, true ) && lsvr_get_field( 'page404_enable_search', true, true ) ) : ?>
					</div>
					<div class="col-md-6">
				<?php endif; ?>

				<?php // SEARCH
				if ( lsvr_get_field( 'page404_enable_search', true, true ) ) : ?>
					<!-- SEARCH : begin -->
					<h2><?php _e( '<strong>Search</strong> This Site', 'lsvrtheme' ); ?></h2>
					<?php get_search_form() ?>
					<!-- SEARCH : end -->
				<?php endif; ?>

				<?php if ( lsvr_get_field( 'page404_enable_posts', true, true ) && lsvr_get_field( 'page404_enable_search', true, true ) ) : ?>
					</div>
				</div>
				<?php endif; ?>

			</div>
			<!-- ERROR 404 PAGE : end -->

		</div>
		<!-- PAGE CONTENT : end -->

	</div>

</div>
<!-- CORE : end -->

<?php get_footer(); ?>