<?php get_header();?>

<!-- CORE : begin -->
<div id="core" <?php post_class(); ?>>

	<?php // PAGE HEADER
	get_template_part( 'components/page-header' ); ?>

	<?php if ( have_posts() ) : ?>
	<div class="container">

		<?php if ( lsvr_get_field( 'project_list_categories_enable', true, true ) ) : ?>
		<div class="row">
			<div class="col-md-9<?php if ( lsvr_get_field( 'project_list_categories_position', 'left' ) === 'left' ) : ?> col-md-push-3<?php endif; ?>">
		<?php endif; ?>

		<!-- PAGE CONTENT : begin -->
		<div id="page-content">

			<?php if ( lsvr_get_field( 'project_list_subtitle', '' ) !== '' ) : ?>

				<?php if ( ! lsvr_get_field( 'project_list_categories_enable', true, true ) ) : ?>
					<h2>
				<?php else : ?>
					<h2 class="hidden-md hidden-lg">
				<?php endif; ?>

				<?php if ( function_exists( 'pll__' ) ) : ?>
					<?php echo pll__( lsvr_get_field( 'project_list_subtitle', '' ) ); ?></h2>
				<?php else: ?>
					<?php echo lsvr_get_field( 'project_list_subtitle', '' ); ?></h2>
				<?php endif; ?>

			<?php endif; ?>

			<!-- PROJECT LIST : begin -->
			<div class="project-list-page">
				<div class="c-project-list m-<?php echo lsvr_get_field( 'project_list_items_per_row', 2 ); ?>-per-row">
					<ul class="project-list-items">

					<?php while ( have_posts() ) : the_post(); ?>

						<!-- PROJECT : begin -->
						<li class="c-project">
							<div class="project-inner">

								<?php $thumb_data = lsvr_get_image_field( 'meta_project_thumb_image' ) ? lsvr_get_image_data( lsvr_get_image_field( 'meta_project_thumb_image', 'id' ) ) : ''; ?>
								<?php if ( is_array( $thumb_data ) ) : ?>
									<?php if ( lsvr_get_field( 'project_list_items_per_row', 2 ) < 4 ) : ?>
										<?php $thumb_url = $thumb_data['large']; ?>
									<?php else : ?>
										<?php $thumb_url = $thumb_data['medium']; ?>
									<?php endif; ?>
								<?php else : ?>
									<?php $thumb_url = false; ?>
								<?php endif; ?>
								<?php if ( $thumb_url ) : ?>
									<div class="project-thumb">
										<p><a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url( $thumb_url ); ?>" alt="<?php the_title(); ?>"></a></p>
									</div>
								<?php endif; ?>
								<div class="project-description">
									<h3 class="project-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
									<?php if ( lsvr_get_field( 'project_list_excerpt_enable', true, true ) ) : ?>

										<?php if( $post->post_excerpt ) : ?>
											<?php the_excerpt(); ?>
										<?php else: ?>
											<?php the_content( '[&#8230;]' ); ?>
										<?php endif; ?>

									<?php endif; ?>
									<?php if ( lsvr_get_field( 'project_list_more_enable', true, true ) ) : ?>
										<p><a href="<?php the_permalink(); ?>" class="c-button m-size-small"><?php _e( 'More Info', 'lsvrtheme' ); ?></a></p>
									<?php endif; ?>

								</div>

							</div>
						</li>
						<!-- PROJECT : end -->

					<?php endwhile; ?>

					</ul>
				</div>
			</div>
			<!-- PROJECT LIST : end -->

			<?php // PAGINATION
			get_template_part( 'components/pagination' ); ?>

		</div>
		<!-- PAGE CONTENT : end -->

		<?php if ( lsvr_get_field( 'project_list_categories_enable', true, true ) ) : ?>
			</div>
			<div class="col-md-3<?php if ( lsvr_get_field( 'project_list_categories_position', 'left' ) === 'left' ) : ?> col-md-pull-9<?php endif; ?>">

				<!-- SIDEBAR : end -->
				<hr class="c-separator m-size-medium m-type-2 hidden-lg hidden-md">
				<div id="sidebar">

					<?php if ( lsvr_get_field( 'project_list_subtitle', '' ) !== '' ) : ?>
						<?php if ( function_exists( 'pll__' ) ) : ?>
							<h2 class="hidden-xs hidden-sm"><?php echo pll__( lsvr_get_field( 'project_list_subtitle', '' ) ); ?></h2>
						<?php else: ?>
							<h2 class="hidden-xs hidden-sm"><?php echo lsvr_get_field( 'project_list_subtitle', '' ); ?></h2>
						<?php endif; ?>
					<?php endif; ?>

					<div class="widget-list">

						<?php // CATEGORY LIST WIDGET
						if ( class_exists( 'Lsvr_Project_Category_List' ) ) {
							the_widget( 'Lsvr_Project_Category_List',
							array( 'title' => __( 'Categories', 'lsvrtheme' ) ),
							array( 'before_widget' => '<div class="widget project-cat-list"><div class="widget-inner">',
								'after_widget'  => '</div></div>',
								'before_title'  => '<h3 class="widget-title">',
								'after_title'   => '</h3>' )
						); } ?>

					</div>
				</div>
				<!-- SIDEBAR : begin -->

			</div>
		</div>
		<?php endif; ?>

	</div>
	<?php endif; ?>

</div>
<!-- CORE : end -->

<?php get_footer(); ?>