<?php get_header();?>

<!-- CORE : begin -->
<div id="core" <?php post_class(); ?>>

	<?php // PAGE HEADER
	get_template_part( 'components/page-header' ); ?>

	<?php if ( have_posts() ) : ?>
	<div class="container">

		<!-- PAGE CONTENT : begin -->
		<div id="page-content">

			<?php if ( lsvr_get_field( 'service_list_subtitle', '' ) !== '' ) : ?>
				<?php if ( function_exists( 'pll__' ) ) : ?>
					<h2><?php echo pll__( lsvr_get_field( 'service_list_subtitle', '' ) ); ?></h2>
				<?php else: ?>
					<h2><?php echo lsvr_get_field( 'service_list_subtitle', '' ); ?></h2>
				<?php endif; ?>
			<?php endif; ?>

			<!-- SERVICE LIST : begin -->
			<div class="service-list-page">
			<ul class="c-service-list m-<?php echo lsvr_get_field( 'service_list_items_per_row', 4 ); ?>-per-row">

			<?php while ( have_posts() ) : the_post(); ?>

				<!-- SERVICE : begin -->
				<li class="c-service slug-<?php echo $post->post_name;?>">
					<div class="service-inner">

						<?php $thumb_data = lsvr_get_image_field( 'meta_service_thumb_image' ) ? lsvr_get_image_data( lsvr_get_image_field( 'meta_service_thumb_image', 'id' ) ) : ''; ?>
						<?php if ( is_array( $thumb_data ) ) : ?>
							<?php if ( lsvr_get_field( 'service_list_items_per_row', 4 ) < 4 ) : ?>
								<?php $thumb_url = $thumb_data['large']; ?>
							<?php else : ?>
								<?php $thumb_url = $thumb_data['medium']; ?>
							<?php endif; ?>
						<?php else : ?>
							<?php $thumb_url = false; ?>
						<?php endif; ?>
						<div class="service-header"<?php if ( $thumb_url ) { ?> style="background-image: url( '<?php echo esc_url( $thumb_url ); ?>' );"<?php } ?>>
							<div><div>

								<?php if ( lsvr_get_field( 'services_link_to_detail', true, true ) ) : ?>
									<a class="service-header-inner" href="<?php the_permalink(); ?>">
								<?php else : ?>
									<div class="service-header-inner">
								<?php endif; ?>

								<?php if ( lsvr_get_field( 'meta_service_icon', '' ) !== '' ) : ?>
								<span class="service-icon"><i class="<?php echo lsvr_get_field( 'meta_service_icon', '' ); ?>"></i></span>
								<?php endif; ?>

								<h3 class="service-title"><?php the_title(); ?></h3>

								<?php if ( lsvr_get_field( 'services_link_to_detail', true, true ) ) : ?>
									</a>
								<?php else : ?>
									</div>
								<?php endif; ?>

							</div></div>
						</div>

						<?php if ( lsvr_get_field( 'service_list_excerpt_enable', true, true )
						|| lsvr_get_field( 'service_list_more_enable', true, true ) ) : ?>
						<div class="service-description">
							<div><div>

								<?php if ( lsvr_get_field( 'service_list_excerpt_enable', true, true ) ) : ?>
									<?php the_excerpt(); ?>
								<?php endif; ?>

								<?php if ( lsvr_get_field( 'service_list_more_enable', true, true ) ) : ?>
									<p><a href="<?php the_permalink(); ?>" class="c-button m-size-small"><?php _e( 'More Info', 'lsvrtheme' ); ?></a></p>
								<?php endif; ?>

							</div></div>
						</div>
						<?php endif; ?>

					</div>
				</li>
				<!-- SERVICE : end -->

			<?php endwhile; ?>
			</ul>
			</div>
			<!-- SERVICE LIST : end -->

			<?php // PAGINATION
			get_template_part( 'components/pagination' ); ?>

		</div>
		<!-- PAGE CONTENT : end -->

	</div>
	<?php else: ?>
	<div class="container">
		<div id="page-content">
			<p class="c-alert-message m-info"><i class="ico fa fa-info-circle"></i><?php _e( 'There are no services.', 'lsvrtheme' ); ?></p>
		</div>
	</div>
	<?php endif; ?>

</div>
<!-- CORE : end -->

<?php get_footer(); ?>