<?php
// GET POST THUMB
if ( has_post_thumbnail() ) { $thumb_data = lsvr_get_image_data( get_post_thumbnail_id() ); }
?>

<?php // SINGLE POST
if ( is_single() ) : ?>

    <article <?php post_class(); ?>>
		<div class="article-inner">

			<!-- ARTICLE HEADER : begin -->
			<header class="article-header">
				<h2 class="article-title"><?php the_title(); ?></h2>
				<p class="article-date">
					<?php $post_categories = wp_get_post_categories( get_the_ID() ); ?>
					<?php $post_category_html = ''; ?>
					<?php foreach ( $post_categories as $cat_id ) : ?>
						<?php $cat = get_category( $cat_id ); ?>
						<?php $post_category_html .= '<a href="' . get_category_link( $cat_id ) . '">' . $cat->name . '</a>'; ?>
						<?php if ( $cat_id !== end( $post_categories ) ) { $post_category_html .= ', '; } ?>
					<?php endforeach; ?>
					<?php if ( lsvr_get_field( 'blog_categories_enable', true, true ) && $post_category_html !== '') : ?>
						<?php echo @sprintf( __( '%s in %s', 'lsvrtheme' ), get_the_date(), $post_category_html ); ?>
					<?php else : ?>
						<?php the_date(); ?>
					<?php endif; ?>
				</p>
			</header>
			<!-- ARTICLE HEADER : end -->

			<?php if ( isset ( $thumb_data ) ) : ?>
			<!-- ARTICLE IMAGE : begin -->
			<div class="article-image">
				<p><img src="<?php echo $thumb_data[ 'full' ]; ?>" alt="<?php echo $thumb_data[ 'alt' ]; ?>"></p>
			</div>
			<!-- ARTICLE IMAGE : begin -->
			<?php endif; ?>

			<!-- ARTICLE CONTENT : begin -->
			<div class="article-content various-content">
				<?php the_content(); ?>
				<?php wp_link_pages(); ?>
			</div>
			<!-- ARTICLE CONTENT : end -->

			<?php if( has_tag() && lsvr_get_field( 'blog_detail_tags_enable', true, true ) ) : ?>
			<hr class="c-separator m-transparent">
			<!-- ARTICLE TAGS : begin -->
			<div class="article-tags">
				<?php $article_tags = wp_get_post_tags( get_the_ID() ); ?>
				<i class="icon fa fa-tags"></i>
				<?php foreach ( $article_tags as $tag ) : ?>
					<a href="<?php echo get_tag_link( $tag->term_id ); ?>"><?php echo $tag->name; ?></a><?php if ( $tag !== end( $article_tags ) ) { echo ', '; } ?>
				<?php endforeach; ?>
			</div>
			<!-- ARTICLE TAGS : end -->
			<?php endif; ?>

		</div>
    </article>

	<?php if ( lsvr_get_field( 'blog_detail_author_bio_enable', false, true ) ) : ?>
	<hr class="c-separator m-size-medium">
	<!-- ARTICLE AUTHOR : begin -->
	<div class="article-author">
		<div class="author-inner">
			<h4 class="author-name"><?php echo get_the_author(); ?></h4>
			<div class="author-description">
				<?php echo wpautop( get_the_author_meta( 'description' ) ); ?>
			</div>
		</div>
	</div>
	<!-- ARTICLE AUTHOR : end -->
	<?php endif; ?>

	<?php if ( lsvr_get_field( 'blog_detail_navigation_enable', true, true ) ) : ?>
	<hr class="c-separator m-size-medium">
	<!-- ARTICLE NAVIGATION : begin -->
	<ul class="article-navigation">

		<?php $prev_post = get_adjacent_post( false, '', true ); ?>
		<?php if ( ! empty( $prev_post ) ): ?>
			<!-- PREV ARTICLE : begin -->
			<li class="prev<?php if ( has_post_thumbnail( $prev_post->ID ) ) { echo ' m-has-thumb'; } ?>">
				<div class="prev-inner">
					<?php if ( has_post_thumbnail( $prev_post->ID ) ) : ?>
						<?php $thumb_data = lsvr_get_image_data( get_post_thumbnail_id( $prev_post->ID ) ); ?>
						<div class="nav-thumb"><a href="<?php echo get_permalink( $prev_post->ID ); ?>"><img src="<?php echo $thumb_data['thumbnail']; ?>" alt=""></a></div>
					<?php endif; ?>
					<h5><?php _e( 'Previous Post', 'lsvrtheme' ); ?></h5>
					<a href="<?php echo get_permalink( $prev_post->ID ); ?>"><?php echo $prev_post->post_title; ?></a>
				</div>
			</li>
			<!-- PREV ARTICLE : end -->
		<?php endif; ?>

		<?php $next_post = get_adjacent_post( false, '', false ); ?>
		<?php if ( ! empty( $next_post ) ): ?>
			<!-- NEXT ARTICLE : begin -->
			<li class="next<?php if ( has_post_thumbnail( $next_post->ID ) ) { echo ' m-has-thumb'; } ?>">
				<div class="next-inner">
					<?php if ( has_post_thumbnail( $next_post->ID ) ) : ?>
						<?php $thumb_data = lsvr_get_image_data( get_post_thumbnail_id( $next_post->ID ) ); ?>
						<div class="nav-thumb"><a href="<?php echo get_permalink( $next_post->ID ); ?>"><img src="<?php echo $thumb_data['thumbnail']; ?>" alt=""></a></div>
					<?php endif; ?>
					<h5><?php _e( 'Next Post', 'lsvrtheme' ); ?></h5>
					<a href="<?php echo get_permalink( $next_post->ID ); ?>"><?php echo $next_post->post_title; ?></a>
				</div>
			</li>
			<!-- NEXT ARTICLE : end -->
		<?php endif; ?>

	</ul>
	<!-- ARTICLE NAVIGATION : end -->
	<?php endif; ?>

    <?php if ( comments_open() ) : ?>
	<hr class="c-separator m-size-medium">
    <!-- ARTICLE COMMENTS : begin -->
    <div class="article-comments" id="comments">
      <?php comments_template(); ?>
    </div>
    <!-- ARTICLE COMMENTS : end -->
    <?php endif; ?>

<?php // POST LIST
else : ?>

	<?php $post_class = 'c-article'; ?>
	<?php if ( lsvr_get_field( 'blog_list_crop_excerpt', false, true ) ) : ?>
		<?php $post_class .= ' m-cropped'; ?>
	<?php endif; ?>

    <article <?php post_class( $post_class ); ?>>
		<div class="article-inner">

			<?php if ( isset ( $thumb_data ) ) : ?>
			<!-- ARTICLE IMAGE : begin -->
			<div class="article-image">
				<p><a href="<?php the_permalink(); ?>"><img src="<?php echo $thumb_data[ 'large' ]; ?>" alt="<?php echo $thumb_data[ 'alt' ]; ?>"></a></p>
			</div>
			<!-- ARTICLE IMAGE : end -->
			<?php endif; ?>

			<!-- ARTICLE CONTENT : begin -->
			<div class="article-content">
				<div class="content-inner">
					<p class="article-date">
						<?php $post_categories = wp_get_post_categories( get_the_ID() ); ?>
						<?php $post_category_html = ''; ?>
						<?php foreach ( $post_categories as $cat_id ) : ?>
							<?php $cat = get_category( $cat_id ); ?>
							<?php $post_category_html .= '<a href="' . get_category_link( $cat_id ) . '">' . $cat->name . '</a>'; ?>
							<?php if ( $cat_id !== end( $post_categories ) ) { $post_category_html .= ', '; } ?>
						<?php endforeach; ?>

						<?php if ( lsvr_get_field( 'blog_categories_enable', true, true ) && $post_category_html !== '' ) : ?>
							<?php echo @sprintf( __( '%s in %s', 'lsvrtheme' ), get_the_date(), $post_category_html ); ?>
						<?php else : ?>
							<?php echo get_the_date(); ?>
						<?php endif; ?>
						<?php if( comments_open() ) : ?>
							<?php $comment_count = get_comment_count( get_the_ID() ); ?>
							<?php if( $comment_count['approved'] > 0 ) : ?>
								<span class="article-comment-count">- <a href="<?php the_permalink(); ?>#comments" title="<?php echo @sprintf( __( 'Comments (%d)', 'lsvrtheme' ), $comment_count['approved'] ); ?>"><i class="im im-comment"></i> <?php echo $comment_count['approved']; ?></a></span>
							<?php endif; ?>
						<?php endif; ?>
					</p>
					<h2 class="article-title">
					<?php if ( is_sticky() ) : ?><i class="fa fa-thumb-tack"></i><?php endif; ?>
					<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
					<?php if( $post->post_excerpt ) : ?>

						<?php the_excerpt(); ?>
						<?php if ( lsvr_get_field( 'blog_list_more_enable', true, true ) ) : ?>

							<?php if ( function_exists( 'pll__' ) ) : ?>
								<p><a class="c-button m-size-small" href="<?php the_permalink(); ?>"><?php echo esc_attr( pll__( lsvr_get_field( 'blog_list_more_label', __( 'Read More', 'lsvrtheme' ) ) ) ); ?></a></p>
							<?php else: ?>
								<p><a class="c-button m-size-small" href="<?php the_permalink(); ?>"><?php echo esc_attr( lsvr_get_field( 'blog_list_more_label', __( 'Read More', 'lsvrtheme' ) ) ); ?></a></p>
							<?php endif; ?>

						<?php endif; ?>

					<?php else: ?>

						<?php the_content( '[&#8230;]' ); ?>

					<?php endif; ?>
				</div>
			</div>
			<!-- ARTICLE CONTENT : end -->

		</div>
    </article>

<?php endif; ?>