<ul>

<?php // HOME LINK
if ( lsvr_get_field( 'header_breadcrumbs_home_enable', true, true ) ) : ?>

	<?php if ( function_exists( 'pll__' ) ) : ?>
		<li class="home"><a href="<?php echo home_url(); ?>"><?php echo pll__( lsvr_get_field( 'header_breadcrumbs_home_label', __( 'Home', 'lsvrtheme' ) ) ); ?></a></li>
	<?php else: ?>
		<li class="home"><a href="<?php echo home_url(); ?>"><?php echo lsvr_get_field( 'header_breadcrumbs_home_label', __( 'Home', 'lsvrtheme' ) ); ?></a></li>
	<?php endif; ?>

<?php endif; ?>

<?php // BLOG
$blog_page_id = get_option( 'page_for_posts' ); ?>
<?php if ( $blog_page_id ) : ?>
	<?php $blog_page_html = '<li><a href="' . get_permalink( $blog_page_id ) . '">' . get_the_title( $blog_page_id ) . '</a></li>';	?>
<?php else : ?>
	<?php $blog_page_html = '<li><a href="' . home_url() . '">' . __( 'Blog', 'lsvrtheme' ) . '</a></li>';	?>
<?php endif; ?>

<?php if ( is_home() ) : ?>

	<li><?php echo get_the_title( $blog_page_id ); ?></li>

<?php elseif ( is_tag() ) : ?>

	<?php echo $blog_page_html; ?>
	<li><?php single_tag_title( '', false ); ?></li>

<?php elseif ( is_day() ) : ?>

	<?php echo $blog_page_html; ?>
	<li><?php echo sprintf( __( 'Archive for %s', 'lsvrtheme' ), get_the_time( 'F jS, Y' ) ); ?></li>

<?php elseif ( is_year() ) : ?>

	<?php echo $blog_page_html; ?>
	<li><?php echo sprintf( __( 'Archive for %s', 'lsvrtheme' ), get_the_time( 'Y' ) ); ?></li>

<?php elseif ( is_author() ) : ?>

	<?php echo $blog_page_html; ?>
	<li><?php echo __( 'Author Archive', 'lsvrtheme' ); ?></li>

<?php elseif ( is_singular( 'post' ) ) : ?>

	<?php echo $blog_page_html; ?>
	<li><?php echo get_the_title(); ?></li>

<?php elseif ( is_category() ) : ?>

	<?php global $wp_query;
	$current_term = $wp_query->queried_object;
	$current_term_id = $current_term->term_id;
	$parent_ids = lsvr_get_term_parents( $current_term_id, 'category' );
	$parents_html = '';
	foreach( $parent_ids as $parent_id ){
		$parent = get_term( $parent_id, 'category' );
		$parents_html .= '<li><a href="' . get_term_link( $parent, 'category' ) .'">' . $parent->name . '</a></li>';
	} ?>

	<?php echo $blog_page_html . $parents_html; ?>
	<li><?php echo $current_term->name; ?></li>

<?php // PAGE
elseif ( is_page() ) : ?>

	<?php global $post;
	$parent_id  = $post->post_parent;
	$breadcrumbs = array();
	while ( $parent_id ) {
		$page = get_page( $parent_id );
		$breadcrumbs[] = '<a href="' . get_permalink( $page->ID ) . '" title="">' . get_the_title( $page->ID ) . '</a>';
		$parent_id = $page->post_parent;
	}
	$breadcrumbs = array_reverse( $breadcrumbs );
	$parents_html = '';
	foreach ( $breadcrumbs as $crumb ) {
		$parents_html .= '<li>' . $crumb . '</li>';
	} ?>

	<?php echo $parents_html; ?>
	<li><?php echo get_the_title(); ?></li>

<?php // SERVICE CPT
elseif ( is_post_type_archive( 'lsvrservice' ) ) : ?>

	<?php if ( function_exists( 'pll__' ) ) : ?>
		<li><?php echo pll__( lsvr_get_field( 'services_page_title', __( 'Services', 'lsvrtheme' ) ) ); ?></li>
	<?php else: ?>
		<li><?php echo lsvr_get_field( 'services_page_title', __( 'Services', 'lsvrtheme' ) ); ?></li>
	<?php endif; ?>

<?php elseif ( is_singular( 'lsvrservice' ) ) : ?>

	<?php if ( function_exists( 'pll__' ) ) : ?>
		<li><a href="<?php echo get_post_type_archive_link( 'lsvrservice' ); ?>"><?php echo pll__( lsvr_get_field( 'services_page_title', __( 'Services', 'lsvrtheme' ) ) ); ?></a></li>
	<?php else: ?>
		<li><a href="<?php echo get_post_type_archive_link( 'lsvrservice' ); ?>"><?php echo lsvr_get_field( 'services_page_title', __( 'Services', 'lsvrtheme' ) ); ?></a></li>
	<?php endif; ?>
	<li><?php echo get_the_title(); ?></li>

<?php // PROJECT CPT
elseif ( is_post_type_archive( 'lsvrproject' ) ) : ?>

	<?php if ( function_exists( 'pll__' ) ) : ?>
		<li><?php echo pll__( lsvr_get_field( 'projects_page_title', __( 'Projects', 'lsvrtheme' ) ) ); ?></li>
	<?php else: ?>
		<li><?php echo lsvr_get_field( 'projects_page_title', __( 'Projects', 'lsvrtheme' ) ); ?></li>
	<?php endif; ?>

<?php elseif ( is_singular( 'lsvrproject' ) ) : ?>

	<?php if ( function_exists( 'pll__' ) ) : ?>
		<li><a href="<?php echo get_post_type_archive_link( 'lsvrproject' ); ?>"><?php echo pll__( lsvr_get_field( 'projects_page_title', __( 'Projects', 'lsvrtheme' ) ) ); ?></a></li>
	<?php else: ?>
		<li><a href="<?php echo get_post_type_archive_link( 'lsvrproject' ); ?>"><?php echo lsvr_get_field( 'projects_page_title', __( 'Projects', 'lsvrtheme' ) ); ?></a></li>
	<?php endif; ?>
	<li><?php echo get_the_title(); ?></li>

<?php elseif ( is_tax( 'lsvrprojectcat' ) ) : ?>

        <?php global $wp_query;
        $current_term = $wp_query->queried_object; ?>

		<?php if ( function_exists( 'pll__' ) ) : ?>
			<li><a href="<?php echo get_post_type_archive_link( 'lsvrproject' ); ?>"><?php echo pll__( lsvr_get_field( 'projects_page_title', __( 'Projects', 'lsvrtheme' ) ) ); ?></a></li>
		<?php else: ?>
			<li><a href="<?php echo get_post_type_archive_link( 'lsvrproject' ); ?>"><?php echo lsvr_get_field( 'projects_page_title', __( 'Projects', 'lsvrtheme' ) ); ?></a></li>
		<?php endif; ?>
		<li><?php echo $current_term->name; ?></li>

<?php // SEARCH
elseif ( is_search() ) : ?>

	<li><?php echo __( 'Search Results', 'lsvrtheme' ); ?></li>

<?php endif; ?>

</ul>