<!-- PAGE HEADER : begin -->
<?php $page_header_class = ''; ?>
<?php if ( lsvr_get_field( 'header_bg_parallax', true, true ) ) { $page_header_class .= ' m-parallax'; } ?>
<?php if ( ! lsvr_get_field( 'header_color_overlay', true, true ) ) { $page_header_class .= ' m-no-overlay'; } ?>
<div id="page-header" class="<?php echo trim( $page_header_class ); ?>">

	<?php $blog_page_id = get_option( 'page_for_posts' ); ?>
	<?php $blog_page_id = $blog_page_id && $blog_page_id > 0 ? $blog_page_id : false; ?>

	<?php if ( $blog_page_id && ( is_home() || is_singular( 'post' ) || is_category() || is_tag() || is_day() || is_year() || is_author() ) && has_post_thumbnail( $blog_page_id ) ) : ?>
		<?php $image_data = lsvr_get_image_data( get_post_thumbnail_id( $blog_page_id ) ); ?>
		<?php $background_image = $image_data['full']; ?>
	<?php elseif ( ( is_page() || is_singular( 'lsvrservice' ) || is_singular( 'lsvrproject' ) ) && has_post_thumbnail() ) : ?>
		<?php $image_data = lsvr_get_image_data( get_post_thumbnail_id() ); ?>
		<?php $background_image = $image_data['full']; ?>
	<?php elseif ( lsvr_get_image_field( 'header_bg_image' ) ) : ?>
		<?php $background_image = lsvr_get_image_field( 'header_bg_image' ); ?>
	<?php else : ?>
		<?php $background_image = false; ?>
	<?php endif; ?>

	<!-- PAGE HEADER TOP : begin -->
	<div class="page-header-top"
		<?php if ( $background_image ) : ?>style="background-image: url( '<?php echo esc_url( $background_image ); ?>' );"<?php endif; ?>>
		<div class="page-header-top-inner">

			<!-- PAGE TITLE : begin -->
			<div class="page-title">
				<div class="container">
					<h1>
					<?php if ( $blog_page_id && ( is_home() || is_singular( 'post' ) || is_category() || is_tag() || is_day() || is_year() || is_author() ) ) : ?>
						<?php echo get_the_title( $blog_page_id ); ?>
					<?php elseif ( is_post_type_archive( 'lsvrservice' ) ) : ?>
						<?php if ( function_exists( 'pll__' ) ) : ?>
							<?php echo pll__( lsvr_get_field( 'services_page_title', __( 'Services', 'lsvrtheme' ) ) ); ?>
						<?php else: ?>
							<?php echo lsvr_get_field( 'services_page_title', __( 'Services', 'lsvrtheme' ) ); ?>
						<?php endif; ?>
					<?php elseif ( is_post_type_archive( 'lsvrproject' ) ) : ?>
						<?php if ( function_exists( 'pll__' ) ) : ?>
							<?php echo pll__( lsvr_get_field( 'projects_page_title', __( 'Projects', 'lsvrtheme' ) ) ); ?>
						<?php else: ?>
							<?php echo lsvr_get_field( 'projects_page_title', __( 'Projects', 'lsvrtheme' ) ); ?>
						<?php endif; ?>
					<?php elseif ( is_tax( 'lsvrprojectcat' ) ) : ?>
						<?php global $wp_query; ?>
						<?php $current_term = $wp_query->queried_object; ?>
						<?php echo $current_term->name; ?>
					<?php elseif ( is_404() ) : ?>
						<?php if ( function_exists( 'pll__' ) ) : ?>
							<?php echo pll__( lsvr_get_field( 'page404_title', __( '<strong>404</strong><br>Page Not Found', 'lsvrtheme' ) ) ); ?>
						<?php else: ?>
							<?php echo lsvr_get_field( 'page404_title', __( '<strong>404</strong><br>Page Not Found', 'lsvrtheme' ) ); ?>
						<?php endif; ?>
					<?php elseif ( is_search() ) : ?>
						<?php _e( 'Search Results', 'lsvrtheme' ); ?>
					<?php elseif ( is_page() && lsvr_get_field( 'meta_header_title', '' ) !== '' ) : ?>
						<?php echo lsvr_get_field( 'meta_header_title', '' ); ?>
					<?php else: ?>
						<?php the_title(); ?>
					<?php endif; ?>
					</h1>
				</div>
			</div>
			<!-- PAGE TITLE : end -->

			<?php $header_services_enable = lsvr_get_field( 'header_services_enable', true, true ); ?>
			<?php $is_page = is_page(); ?>
			<?php if ( $blog_page_id && ( is_home() || is_singular( 'post' ) || is_category() || is_tag() || is_day() || is_year() || is_author() ) ) : ?>
				<?php $is_page = true; ?>
				<?php if ( get_post_meta( $blog_page_id, 'meta_header_services_enable', true ) === 'enable' ) { $header_services_enable = true; } ?>
				<?php if ( get_post_meta( $blog_page_id, 'meta_header_services_enable', true ) === 'disable' ) { $header_services_enable = false; } ?>
			<?php elseif ( is_page() && lsvr_get_field( 'meta_header_services_enable', 'global' ) === 'enable' ) : $header_services_enable = true; ?>
			<?php elseif ( is_page() && lsvr_get_field( 'meta_header_services_enable', 'global' ) === 'disable' ) : $header_services_enable = false; ?>
			<?php elseif ( is_404() || is_search() ) : $header_services_enable = false; ?>
			<?php endif; ?>

			<?php if ( $is_page && $header_services_enable ) : ?>
			<!-- PAGE HEADER SERVICES : begin -->
			<div class="page-header-services">
				<div class="container">

					<?php // QUERY
					$q_args = array(
						'posts_per_page' => 100,
						'post_type' => 'lsvrservice',
						'order' => 'DESC',
						'orderby' => 'post_date',
						'post_status' => array( 'publish' ),
						'suppress_filters' => false,
					);
					$loop = new WP_Query( $q_args ); ?>

					<?php if ( $loop->have_posts() ) : ?>
					<!-- SERVICE LIST : begin -->
					<ul class="c-service-list m-type-2 m-<?php echo lsvr_get_field( 'header_services_items_per_row', 4 ); ?>-per-row">

						<?php while ( $loop->have_posts() ) : ?>

							<?php $loop->the_post(); ?>

							<!-- SERVICE : begin -->
							<li class="c-service m-type-2 slug-<?php echo $post->post_name;?>">
								<div class="service-inner">

										<div class="service-header"
											<?php $thumb_data = lsvr_get_image_field( 'meta_service_thumb_image' ) ? lsvr_get_image_data( lsvr_get_image_field( 'meta_service_thumb_image', 'id' ) ) : ''; ?>
											<?php if ( is_array( $thumb_data ) ) : ?>
												<?php if ( lsvr_get_field( 'header_services_items_per_row', 4 ) < 4 ) : ?>
													<?php $thumb_url = $thumb_data['large']; ?>
												<?php else : ?>
													<?php $thumb_url = $thumb_data['medium']; ?>
												<?php endif; ?>
											<?php else : ?>
												<?php $thumb_url = false; ?>
											<?php endif; ?>
											<?php if ( $thumb_url ) : ?>
												style="background-image: url( '<?php echo esc_url( $thumb_url ); ?>' );"
											<?php endif; ?>>

											<div><div>

												<?php if ( lsvr_get_field( 'services_link_to_detail', true, true ) ) : ?>
													<a class="service-header-inner" href="<?php the_permalink(); ?>">
												<?php else : ?>
													<div class="service-header-inner">
												<?php endif; ?>

												<?php if ( lsvr_get_field( 'meta_service_icon', '' ) !== '' ) : ?>
												<span class="service-icon"><i class="<?php echo lsvr_get_field( 'meta_service_icon', '' ); ?>"></i></span>
												<?php endif; ?>

												<h3 class="service-title"><?php the_title(); ?></h3>

												<?php if ( lsvr_get_field( 'services_link_to_detail', true, true ) ) : ?>
													</a>
												<?php else : ?>
													</div>
												<?php endif; ?>

											</div></div>

										</div>


									<?php if ( lsvr_get_field( 'header_services_excerpt_enable', true, true )
									|| lsvr_get_field( 'header_services_more_enable', true, true ) ) : ?>
									<div class="service-description">
										<div><div>

											<?php if ( lsvr_get_field( 'header_services_excerpt_enable', true, true ) ) : ?>
											<?php the_excerpt(); ?>
											<?php endif; ?>

											<?php if ( lsvr_get_field( 'header_services_more_enable', true, true ) ) : ?>
											<p><a href="<?php the_permalink(); ?>" class="c-button m-size-small"><?php echo __( 'More info', 'lsvrtheme' ); ?></a></p>
											<?php endif; ?>

										</div></div>
									</div>
									<?php endif; ?>

								</div>
							</li>
							<!-- SERVICE : end -->

						<?php endwhile; ?>
						<?php wp_reset_query(); ?>

					</ul>
					<!-- SERVICE LIST : end -->
					<?php endif; ?>

				</div>
			</div>
			<!-- PAGE HEADER SERVICES : end -->
			<?php endif; ?>

		</div>
	</div>
	<!-- PAGE HEADER TOP : end -->

	<!-- PAGE HEADER BOTTOM : begin -->
	<div class="page-header-bottom">
		<div class="container">
			<div class="page-header-bottom-inner">
				<div class="page-header-bottom-inner2">

					<?php // BREADCRUMBS
					$header_breadcrumbs_enable = lsvr_get_field( 'header_breadcrumbs_enable', true, true ); ?>
					<?php if ( $blog_page_id && ( is_home() || is_singular( 'post' ) || is_category() || is_tag() || is_day() || is_year() || is_author() ) ) : ?>
						<?php if ( get_post_meta( $blog_page_id, 'meta_header_breadcrumbs_enable', true ) === 'enable' ) { $header_breadcrumbs_enable = true; } ?>
						<?php if ( get_post_meta( $blog_page_id, 'meta_header_breadcrumbs_enable', true ) === 'disable' ) { $header_breadcrumbs_enable = false; } ?>
					<?php elseif ( is_page() && lsvr_get_field( 'meta_header_breadcrumbs_enable', 'global' ) === 'enable' ) : $header_breadcrumbs_enable = true; ?>
					<?php elseif ( is_page() && lsvr_get_field( 'meta_header_breadcrumbs_enable', 'global' ) === 'disable' ) : $header_breadcrumbs_enable = false; ?>
					<?php elseif ( is_404() ) : $header_breadcrumbs_enable = false; ?>
					<?php endif; ?>
					<?php if ( $header_breadcrumbs_enable ) : ?>
					<!-- PAGE HEADER BREADCRUMBS : begin -->
					<div class="page-header-breadcrumbs">

						<?php // BREADCRUMBS
						get_template_part( 'components/breadcrumbs' ); ?>

					</div>
					<!-- PAGE HEADER BREADCRUMBS : end -->
					<?php endif; ?>

					<?php // CONTACT PANEL
					$header_contact_panel_enable = lsvr_get_field( 'header_contact_panel_enable', true, true ); ?>
					<?php if ( $blog_page_id && ( is_home() || is_singular( 'post' ) || is_category() || is_tag() || is_day() || is_year() || is_author() ) ) : ?>
						<?php if ( get_post_meta( $blog_page_id, 'meta_header_contact_panel_enable', true ) === 'enable' ) { $header_contact_panel_enable = true; } ?>
						<?php if ( get_post_meta( $blog_page_id, 'meta_header_contact_panel_enable', true ) === 'disable' ) { $header_contact_panel_enable = false; } ?>
					<?php elseif ( is_page() && lsvr_get_field( 'meta_header_contact_panel_enable', 'global' ) === 'enable' ) : $header_contact_panel_enable = true; ?>
					<?php elseif ( is_page() && lsvr_get_field( 'meta_header_contact_panel_enable', 'global' ) === 'disable' ) : $header_contact_panel_enable = false; ?>
					<?php elseif ( ( is_post_type_archive( 'lsvrservice' ) || is_singular( 'lsvrservice' ) )
						&& lsvr_get_field( 'services_contact_panel_enable', 'global' ) === 'enable' ) : $header_contact_panel_enable = true; ?>
					<?php elseif ( ( is_post_type_archive( 'lsvrservice' ) || is_singular( 'lsvrservice' ) )
						&& lsvr_get_field( 'services_contact_panel_enable', 'global' ) === 'disable' ) : $header_contact_panel_enable = false; ?>
					<?php elseif ( ( is_post_type_archive( 'lsvrproject' ) || is_singular( 'lsvrproject' ) || is_tax( 'lsvrprojectcat' ) )
						&& lsvr_get_field( 'projects_contact_panel_enable', 'global' ) === 'enable' ) : $header_contact_panel_enable = true; ?>
					<?php elseif ( ( is_post_type_archive( 'lsvrproject' ) || is_singular( 'lsvrproject' ) || is_tax( 'lsvrprojectcat' ) )
						&& lsvr_get_field( 'projects_contact_panel_enable', 'global' ) === 'disable' ) : $header_contact_panel_enable = false; ?>
					<?php elseif ( is_search() ) : $header_contact_panel_enable = false; ?>
					<?php endif; ?>
					<?php if ( $header_contact_panel_enable ) : ?>
					<!-- PAGE TITLE BAR : begin -->
					<div class="page-header-bar">
						<div class="page-header-bar-inner">

							<ul class="page-header-bar-left">

								<?php // QUICK CONTACT
								for ( $i = 1; $i <= 3; $i++ ) : ?>

									<?php if ( lsvr_get_field( 'header_quick_contact_' . $i . '_text', '' ) !== '' ) : ?>
									<li>
										<?php if ( lsvr_get_field( 'header_quick_contact_' . $i . '_icon', '' ) !== '' ) : ?>
											<i class="<?php echo esc_attr( lsvr_get_field( 'header_quick_contact_' . $i . '_icon', '' ) ); ?>"></i>
										<?php endif; ?>
										<?php echo lsvr_get_field( 'header_quick_contact_' . $i . '_text', '' ); ?>
									</li>
									<?php endif; ?>

								<?php endfor; ?>

								<?php // SOCIAL ICONS
								$social_links = lsvr_get_social_links(); ?>
								<?php if ( $social_links && lsvr_get_field( 'header_social_enable', true, true ) ) : ?>
								<li class="social">
									<ul>
										<?php echo $social_links; ?>
									</ul>
								</li>
								<?php endif; ?>

							</ul>

							<?php // CTA BUTTON
							if ( lsvr_get_field( 'header_cta_label', '' ) !== '' ) : ?>
							<div class="page-header-bar-right">
								<?php if ( function_exists( 'pll__' ) ) : ?>
									<a href="<?php echo lsvr_get_field( 'header_cta_link' ); ?>" class="c-button m-type-2 m-size-medium"><?php echo pll__( lsvr_get_field( 'header_cta_label' ) ); ?></a>
								<?php else: ?>
									<a href="<?php echo lsvr_get_field( 'header_cta_link' ); ?>" class="c-button m-type-2 m-size-medium"><?php echo lsvr_get_field( 'header_cta_label' ); ?></a>
								<?php endif; ?>
							</div>
							<?php endif; ?>

						</div>
					</div>
					<!-- PAGE HEADER BAR : end -->
					<?php endif; ?>

				</div>
			</div>
		</div>
	</div>
	<!-- PAGE HEADER BOTTOM : end -->

</div>
<!-- PAGE HEADER : end -->