<?php

if ( ! isset( $content_width ) ) {
    $content_width = 750;
}


/* -----------------------------------------------------------------------------

    LOAD TEXTDOMAIN

----------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_load_textdomain' ) ) {
		function lsvr_load_textdomain(){
			load_theme_textdomain( 'lsvrtheme', get_template_directory() . '/languages' );
		}
	}
	add_action( 'after_setup_theme', 'lsvr_load_textdomain' );


/* -----------------------------------------------------------------------------

    INCLUDES

----------------------------------------------------------------------------- */

    /* -------------------------------------------------------------------------
        REDUX FRAMEWORK
    ------------------------------------------------------------------------- */

	// METABOXES CONFIG
	if ( class_exists( 'ReduxFramework' ) && file_exists( dirname( __FILE__ ) . '/includes/redux/meta-config.php' ) ) {
		require_once( dirname( __FILE__ ) . '/includes/redux/meta-config.php' );
	}

	// THEME OPTIONS CONFIG
	if ( ! isset( $theme_options ) && file_exists( dirname( __FILE__ ) . '/includes/redux/options-config.php' ) ) {
		require_once( dirname( __FILE__ ) . '/includes/redux/options-config.php' );
	}

    /* -------------------------------------------------------------------------
        TGM PLUGIN ACTIVATION
    ------------------------------------------------------------------------- */

    require_once( 'includes/tgm-plugin-settings.php' );

    /* -------------------------------------------------------------------------
        COMMENT WALKER CLASS
    ------------------------------------------------------------------------- */

    require_once( 'includes/lsvr-walker-comment.class.php' );

    /* -------------------------------------------------------------------------
        MAIN MENU WALKER CLASS
    ------------------------------------------------------------------------- */

    require_once( 'includes/lsvr-walker-main-nav.class.php' );

    /* -------------------------------------------------------------------------
        VISUAL COMPOSER SETTINGS
    ------------------------------------------------------------------------- */

    require_once( 'includes/visual-composer-settings.php' );


/* -----------------------------------------------------------------------------

    THEME SETUP

----------------------------------------------------------------------------- */

add_action( 'after_setup_theme', 'lsvr_theme_setup' );

function lsvr_theme_setup() {

    /* -------------------------------------------------------------------------
        REGISTER NAV MENUS
    ------------------------------------------------------------------------- */

    register_nav_menu( 'header', __( 'Header Menu', 'lsvrtheme' ) );
	register_nav_menu( 'header_onepage', __( 'Header Menu (One page)', 'lsvrtheme' ) );
    register_nav_menu( 'footer', __( 'Footer Menu', 'lsvrtheme' ) );

    /* -------------------------------------------------------------------------
        REGISTER SIDEBARS
    ------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_register_sidebars' ) ) {
		function lsvr_register_sidebars() {

			// DEFAULT SIDEBAR
			register_sidebar( array(
				'name' => __( 'Default Sidebar', 'lsvrtheme' ),
				'id' => 'default-sidebar',
				'description'   => __( 'Default sidebar located on a side of page template. You can change the side of sidebar separately for each page.', 'lsvrtheme' ),
				'class'         => '',
				'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-inner">',
				'after_widget'  => '</div></div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>'
			));

			// BOTTOM SIDEBAR
			global $theme_options;
			if ( isset( $theme_options ) && is_array( $theme_options ) && array_key_exists( 'bottom_panel_columns', $theme_options ) ) {
				$bottom_panel_columns = $theme_options[ 'bottom_panel_columns' ];
			}
			else {
				$bottom_panel_columns = 3;
			}
			$bottom_panel_col_number = 12 / intval( $bottom_panel_columns );
			register_sidebar( array(
				'name' => __( 'Bottom Panel', 'lsvrtheme' ),
				'id' => 'bottom-sidebar',
				'description'   => __( 'A widget area located in the footer of the site.', 'lsvrtheme' ),
				'class'         => '',
				'before_widget' => '<hr class="c-separator hidden-lg hidden-md"><div class="col-md-' . esc_attr( $bottom_panel_col_number ) . '"><div id="%1$s" class="widget %2$s"><div class="widget-inner">',
				'after_widget'  => '</div></div></div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>'
			));

			// CUSTOM SIDEBARS
			for ( $i = 1; $i <= 10; $i++ ) {
				if ( lsvr_get_field( 'sidebars_sidebar' . $i . '_enable', false, true ) ) {
					register_sidebar( array(
						//'name'          => lsvr_get_field( 'sidebars_sidebar' . $i . '_name', 'Custom Sidebar ' . $i ),
						'name'          => sprintf( __( 'Custom Sidebar %s', 'lsvrtheme' ), esc_attr( $i ) ),
						'description'   => __( 'You can manage custom sidebars under Theme Options / Custom Sidebars.', 'lsvrtheme' ),
						'id'            => 'custom-sidebar-' . esc_attr( $i ),
						'class'         => '',
						'before_widget' => '<div id="%1$s" class="widget %2$s"><div class="widget-inner">',
						'after_widget'  => '</div></div>',
						'before_title'  => '<h3 class="widget-title">',
						'after_title'   => '</h3>'
					));
				}
			}

		}
	}
    add_action( 'widgets_init', 'lsvr_register_sidebars' );

    /* -------------------------------------------------------------------------
        ADD THEME SUPPORT
    ------------------------------------------------------------------------- */

	// Post formats
    //add_theme_support( 'post-formats', array( 'image', 'gallery', 'audio', 'video', 'link', 'quote' ) );

	// Featured images
    add_theme_support( 'post-thumbnails' );

	// Automatic feed links
    add_theme_support( 'automatic-feed-links' );

	// Title tag
	add_theme_support( 'title-tag' );

    /* -------------------------------------------------------------------------
        LOAD CSS
    ------------------------------------------------------------------------- */

	$theme = wp_get_theme();
    $theme_version = $theme->Version;

	if ( ! function_exists( 'lsvr_load_theme_styles' ) ) {
		function lsvr_load_theme_styles(){

			global $theme_version;

			// Default style.css with theme's main styles
			wp_register_style( 'main-style', get_bloginfo( 'stylesheet_url' ), array(), $theme_version );
			wp_enqueue_style( 'main-style' );

			// Typography
			if ( lsvr_get_field( 'fonts_gf_enable', true, true ) ) {

				if ( is_array( lsvr_get_field( 'fonts_secondary' ) ) ) {
					$secondary_font = lsvr_get_field( 'fonts_secondary', 'Exo 2' );
					$secondary_font_family = array_key_exists( 'font-family', $secondary_font ) ? $secondary_font['font-family'] : 'Exo 2';
					$secondary_font_css = 'h1, h2, h3, h4, table th, label, input.c-button, .c-button, .article-navigation h5, .m-secondary-font';
					$secondary_font_css .= ' { font-family: \'' . esc_attr( $secondary_font_family ) . '\'; }';
					wp_add_inline_style( 'main-style', $secondary_font_css );
				}

				if ( is_array( lsvr_get_field( 'fonts_primary' ) ) ) {
					$primary_font = lsvr_get_field( 'fonts_primary', 'Source Sans Pro' );
					$primary_font_family = array_key_exists( 'font-family', $primary_font ) ? $primary_font['font-family'] : 'Source Sans Pro';
					$primary_font_size = array_key_exists( 'font-size', $primary_font ) ? $primary_font['font-size'] : '16px';
					$primary_font_weight = array_key_exists( 'font-weight', $primary_font ) ? $primary_font['font-weight'] : '300';
					$primary_font_css = 'body, input, textarea, select, .checkbox-input label, .radio-input label, .table-price > span, .m-primary-font';
					$primary_font_css .= ' { font-family: \'' . esc_attr( $primary_font_family ) . '\', Arial, sans-serif; }';
					$primary_font_css .= 'body { font-size: ' . esc_attr( $primary_font_size ) . '; font-weight: ' . esc_attr( $primary_font_weight ) . '; };';
					wp_add_inline_style( 'main-style', $primary_font_css );
				}

			}

			// Custom Color Skin
			if ( lsvr_get_field( 'skin_custom_enabled', false, true ) && lsvr_get_field( 'skin_custom_name' ) !== '' ){
				$custom_theme_skin_name = esc_attr( lsvr_get_field( 'skin_custom_name' ) );
				if ( strlen( $custom_theme_skin_name ) > 4 && substr( $custom_theme_skin_name, -4 ) === '.css' ) {
					$custom_theme_skin_name = substr( $custom_theme_skin_name, 0, -4 );
				}
				$theme_skin_file = '/library/css/skin/' . $custom_theme_skin_name . '.css';
				wp_register_style( 'theme-skin', get_stylesheet_directory_uri() . $theme_skin_file, array(), $theme_version );
			}
			// Predefined Color Skin
			else {
				$theme_skin_file = '/library/css/skin/' . lsvr_get_field( 'skin_default', 'default' ) . '.css';
				wp_register_style( 'theme-skin', get_template_directory_uri() . $theme_skin_file, array(), $theme_version );
			}
			wp_enqueue_style( 'theme-skin' );

			// IE8 (and lower) specific styles
			$oldie_styles = create_function( '', 'echo \'<!--[if lt IE 9]><link rel="stylesheet" type="text/css" href="' . get_template_directory_uri() . '/library/css/oldie.css"><![endif]-->\';' );
			add_action( 'wp_head', $oldie_styles );

			// CUSTOM CSS
			if ( lsvr_get_field( 'custom_css_code' ) !== '' ){
				wp_add_inline_style( 'theme-skin', lsvr_get_field( 'custom_css_code' ) );
			}

		}
	}
    add_action( 'wp_enqueue_scripts', 'lsvr_load_theme_styles' );

    /* -------------------------------------------------------------------------
        LOAD JS
    ------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_load_theme_scripts' ) ) {
		function lsvr_load_theme_scripts() {

			global $theme_version;

			// Modernizr
			// http://modernizr.com/
			wp_register_script( 'modernizr', get_template_directory_uri() . '/library/js/modernizr.custom.min.js', array( 'jquery' ), $theme_version, false );
			wp_enqueue_script( 'modernizr' );

			// Various Third Pary Scripts
			// http://jqueryui.com/
			wp_register_script( 'third-party', get_template_directory_uri() . '/library/js/third-party.js', array( 'jquery' ), $theme_version, true );
			wp_enqueue_script( 'third-party' );

			// Support for Media Queries in IE8 and lower
			$respondjs = create_function( '', 'echo \'<!--[if lt IE 9]><script src="' . get_template_directory_uri() . '/library/js/respond.min.js"></script><![endif]-->\';' );
			add_action( 'wp_head', $respondjs );

			// Theme's scripts library
			wp_register_script( 'scripts-library', get_template_directory_uri() . '/library/js/library.js', array( 'jquery' ), $theme_version, true );
			wp_enqueue_script( 'scripts-library' );

			// Theme's main scripts
			wp_register_script( 'main-scripts', get_template_directory_uri() . '/library/js/scripts.js', array( 'jquery' ), $theme_version, true );
			wp_enqueue_script( 'main-scripts' );

			/*
			// SHARING ADDTHIS
			if ( lsvr_get_field( 'sharing_addthis_id' ) !== '' ) {
				$addthisjs = create_function( '', 'echo "<script type=\"text/javascript\" src=\"//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-544e90e613ec503d\" async=\"async\"></script>";' );
				add_action( 'wp_head', $addthisjs );
			}*/

			// Comment reply
			if ( is_singular() ) { wp_enqueue_script( 'comment-reply' ); }

			// Add JS vars
			if ( lsvr_get_field( 'gmap_api_key', '' ) !== '' ) {
				wp_add_inline_script( 'main-scripts', 'var lsvrGmapApiKey = "' . lsvr_get_field( 'gmap_api_key' ) . '";' );
			}

			// Custom JS
			if ( lsvr_get_field( 'custom_js_code' ) !== '' ) {
				$custom_js_code = create_function( '', 'echo "<script type=\"text/javascript\">/* <![CDATA[ */' . lsvr_get_field( 'custom_js_code' ) . '/* ]]> */</script>";' );
				add_action( 'wp_footer', $custom_js_code );
			}

			// Any code
			if ( lsvr_get_field( 'custom_any_code' ) !== '' ) {
				function lsvr_custom_footer_code() {
					echo lsvr_get_field( 'custom_any_code' );
				}
				add_action( 'wp_footer', 'lsvr_custom_footer_code' );
			}

		}
	}
    add_action( 'wp_enqueue_scripts', 'lsvr_load_theme_scripts' );

    /* -------------------------------------------------------------------------
        CUSTOM ACTIONS
    ------------------------------------------------------------------------- */

	// ADD OFFSET FUNCTIONALITY TO POST LIST
	if ( ! function_exists( 'lsvr_query_offset' ) ) {
		function lsvr_query_offset( &$query ) {

			if ( ! ( ( $query->is_posts_page || $query->is_category || $query->is_archive() || $query->is_tax ) && isset( $_GET[ 'offset' ] ) ) ) {
				return;
			}

			$offset = (int) $_GET[ 'offset' ];
			if ( $query->is_archive( 'lsvrproject' ) || $query->is_tax( 'lsvrprojectcat' ) ) {
				$ppp = esc_attr( lsvr_get_field( 'portfolio_list_per_page', 12 ) );
			}
			else {
				$ppp = get_option( 'posts_per_page' );
			}

			if ( $query->is_paged ) {
				$page_offset = $offset + ( ( $query->query_vars['paged'] - 1) * $ppp );
				$query->set( 'offset', $page_offset );
			}
			else {
				$query->set( 'offset', $offset );
			}

			if ( isset( $_GET[ 'ignore_sticky_posts' ] ) && (bool) $_GET[ 'ignore_sticky_posts' ] ) {
				$query->set( 'ignore_sticky_posts', 1 );
			}

		}
	}
	add_action( 'pre_get_posts', 'lsvr_query_offset', 1 );

	if ( ! function_exists( 'lsvr_adjust_offset_pagination' ) ) {
		function lsvr_adjust_offset_pagination( $found_posts, $query ) {

			if ( ( $query->is_posts_page || $query->is_category || $query->is_archive() || $query->is_tax ) && isset( $_GET[ 'offset' ] ) ) {
				$offset = (int) $_GET[ 'offset' ];
				return $found_posts - $offset;
			}
			return $found_posts;

		}
	}
	add_filter( 'found_posts', 'lsvr_adjust_offset_pagination', 1, 2 );

	// CONTACT FORM 7 DEREGISTER CSS
	if ( ! function_exists( 'lsvr_cf7_deregister_styles' ) ) {
		function lsvr_cf7_deregister_styles() {
			wp_deregister_style( 'contact-form-7' );
		}
	}
	add_action( 'wp_print_styles', 'lsvr_cf7_deregister_styles', 100 );

	// ENABLE SHORTCODES FOR TEXT WIDGET
    add_filter( 'widget_text', 'do_shortcode' );

	// NAVIGATION FIX FOR CPT
	if ( ! function_exists( 'lsvr_is_blog' ) ) {
		function lsvr_is_blog() {
			global $post;
			$posttype = get_post_type( $post );
			return ( ( $posttype == 'post' ) && ( is_home() || is_single() || is_archive() || is_category() || is_tag() || is_author() ) ) ? true : false;
		}
	}
	if ( ! function_exists( 'lsvr_fix_blog_link_on_cpt' ) ) {
		function lsvr_fix_blog_link_on_cpt( $classes, $item ) {
			if( ! lsvr_is_blog() ) {
				$blog_page_id = intval( get_option( 'page_for_posts' ) );
				if( $blog_page_id != 0 && $item->object_id == $blog_page_id )
					unset( $classes[array_search( 'current_page_parent', $classes )] );
			}
			return $classes;
		}
	}
	add_filter( 'nav_menu_css_class', 'lsvr_fix_blog_link_on_cpt', 10, 3 );

	// NUMBER OF POSTS FOR SERVICES ARCHIVE
	if ( ! function_exists( 'lsvr_modify_service_posts_per_page' ) ) {
		function lsvr_modify_service_posts_per_page( $query ) {
			if ( $query->is_main_query() && ( $query->is_post_type_archive( 'lsvrservice' ) ) && ! is_admin() ) {
				$query->set( 'posts_per_page', 100 );
			}
		}
	}
	add_action( 'pre_get_posts', 'lsvr_modify_service_posts_per_page' );

	// NUMBER OF POSTS FOR PROJECT ARCHIVE
	if ( ! function_exists( 'lsvr_modify_project_posts_per_page' ) ) {
		function lsvr_modify_project_posts_per_page( $query ) {
			if ( $query->is_main_query() && ( $query->is_post_type_archive( 'lsvrproject' ) || $query->is_tax( 'lsvrprojectcat' ) ) && ! is_admin() ) {
				$query->set( 'posts_per_page', lsvr_get_field( 'project_list_items_per_page', 6 ) );
			}
		}
	}
	add_action( 'pre_get_posts', 'lsvr_modify_project_posts_per_page' );

	// ENABLE SHORTCODES IN EXCERPT
	add_filter( 'the_excerpt', 'do_shortcode' );

	// ENABLE HTML IN WIDGET TITLE
	if ( ! function_exists( 'lsvr_widget_title_html' ) ) {
		function lsvr_widget_title_html( $title ) {
			$title = str_replace( '[', '<', $title );
			$title = str_replace( '[/', '</', $title );
			$title = str_replace( 'strong]', 'strong>', $title );
			return $title;
		}
	}
	add_filter( 'widget_title', 'lsvr_widget_title_html' );

	// SORT SERVICES ALPHABETICALLY
	if ( ! function_exists( 'lsvr_sort_services' ) ) {
		function lsvr_sort_services( $query ) {

			if ( lsvr_get_field( 'services_sort_alphabetically', true, true ) ){
				if ( $query->is_post_type_archive( 'lsvrservice' ) && ! is_admin() ) {
					$query->set( 'orderby', 'title' );
					$query->set( 'order', 'ASC' );
				}
			}

		}
	}
	add_action( 'pre_get_posts', 'lsvr_sort_services' );

	// TITLE FILTER
	if ( ! function_exists( 'lsvr_document_title_parts' ) ) {
		function lsvr_document_title_parts( $title ){

			if ( is_home() || is_tag() || is_day() || is_year() || is_author() || is_category() ) {
				$blog_page_id = get_option( 'page_for_posts' );
				if ( $blog_page_id ) {
					$prefix = get_the_title( $blog_page_id );
				}
				else {
					$prefix = __( 'Blog', 'lsvrtheme' );
				}
			}
			elseif ( is_singular( 'post' ) ) {
				$prefix = get_the_title();
			}
			elseif ( is_page() ) {
				$prefix = get_the_title();
			}
			elseif ( is_post_type_archive( 'lsvrservice' ) ){
				$prefix = lsvr_get_field( 'services_page_title', 'Services' );
			}
			elseif ( is_singular( 'lsvrservice' ) ){
				$prefix = get_the_title();
			}
			elseif ( is_post_type_archive( 'lsvrproject' ) ){
				$prefix = lsvr_get_field( 'projects_page_title', 'Projects' );
			}
			elseif ( is_singular( 'lsvrproject' ) ){
				$prefix = get_the_title();
			}
			elseif ( is_tax( 'lsvrprojectcat' ) ) {
				global $wp_query;
				$current_term = $wp_query->queried_object;
				$prefix = $current_term->name ;
			}
			elseif ( is_search() ) {
				$prefix = __( 'Search Results', 'lsvrtheme' );
			}
			elseif ( is_404() ) {
				$prefix = __( '404 Page Not Found', 'lsvrtheme' );
			}
			else {
				$prefix = get_the_title();
			}

			$title['title'] = $prefix;
			return $title;

		}
	}
	add_filter( 'document_title_parts', 'lsvr_document_title_parts', 10, 2 );

	// TITLE SEPARATOR
	if ( ! function_exists( 'lsvr_document_title_separator' ) ) {
		function lsvr_document_title_separator( $sep ){
			$sep = '|';
			return $sep;
		}
	}
	add_filter( 'document_title_separator', 'lsvr_document_title_separator', 10 );

}


/* -----------------------------------------------------------------------------

    VARIOUS FUNCTIONS AND FIXES

----------------------------------------------------------------------------- */

    /* -------------------------------------------------------------------------
        GET FIELD
        For use with Redux Framework
    ------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_get_field' ) ) {
		function lsvr_get_field( $field_id, $default = '', $force_bool = false ){

			global $theme_options;
			if ( isset( $theme_options ) && is_array( $theme_options ) && count( $theme_options ) > 0 ) {

				if ( array_key_exists( $field_id, $theme_options ) ) {
					$return = $theme_options[ $field_id ];
				}
				else if ( isset( $default ) ) {
					$return = $default;
				}
				else {
					$return = '';
				}

				// FORCE CAST AS BOOL
				if ( $force_bool ) {
					return (bool) $return;
				}
				else {
					return $return;
				}

			}
			else {
				if ( isset( $default ) ) {
					return $default;
				}
				else {
					return false;
				}
			}

		}
	}

    /* -------------------------------------------------------------------------
        GET IMAGE FIELD
        For use with Redux Framework
    ------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_get_image_field' ) && function_exists( 'lsvr_get_field' ) ) {
		function lsvr_get_image_field( $field_id, $key = 'url' ){

			$field = lsvr_get_field( $field_id );
			if ( is_array( $field ) && array_key_exists( $key, $field ) ) {
				return $field[$key];
			}
			else {
				return false;
			}

		}
	}

    /* -------------------------------------------------------------------------
        GET SOCIAL LINKS
    ------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_get_social_links' ) ) {
		function lsvr_get_social_links() {

			$links = lsvr_get_field( 'social_links' );
			if ( is_array( $links ) ) {

				$links = array_filter( $links );
				if ( is_array( $links ) && count ( $links ) > 0 ) {

					// PARSE ARRAY
					$links_parsed = array();
					$html = '';
					$target = lsvr_get_field( 'social_links_target', false, true ) ? 'target="_blank"' : '';
					foreach ( $links as $key => $val ) {

						$class = strtolower( $key );
						$icoclass = '';
						if ( $class === 'googleplus' ) {
							$icoclass = 'google-plus';
						}
						else if ( $class === 'email' ) {
							$icoclass = 'envelope-o';
						}
						else if ( $class === 'vimeo' ) {
							$icoclass = 'vimeo-square';
						}
						else {
							$icoclass = $class;
						}
						$icoclass = 'fa fa-' . $icoclass;
						$html .= '<li class="ico-' . $class . '"><a href="' . esc_url( $val ) . '" ' . $target . '>';
						$html .= '<i class="' . esc_attr( $icoclass ) . '"></i></a></li>';

					}
					return $html;

				}
				else {
					return false;
				}

			}
			else {
				return false;
			}

		}
	}

    /* -------------------------------------------------------------------------
        GET IMAGE DATA
    ------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_get_image_data' ) ) {
		function lsvr_get_image_data( $image_id ){

			$image_data = array();
			$image_sizes = array( 'thumbnail', 'medium', 'large', 'full' );

			foreach ( $image_sizes as $size ) {
				$temp = wp_get_attachment_image_src( $image_id, $size );
				$image_data[$size] = $temp[0];
			}

			// GET ALT
			$image_data['alt'] = get_post_meta( $image_id, '_wp_attachment_image_alt', true );

			// GET TITLE
			$image_meta = wp_get_attachment_metadata( $image_id );
			if ( is_array( $image_meta ) && array_key_exists( 'title', $image_meta ) ){
				$image_data['title'] = $image_meta['title'];
			}
			else {
				$image_data['title'] = '';
			}

			// GET CAPTION
			$image_post_data = get_post( $image_id );
			if ( $image_post_data && is_object( $image_post_data ) ) {
				$image_data['caption'] = $image_post_data->post_excerpt;
			}
			else {
				$image_data['caption'] = '';
			}

			if ( count( $image_data ) > 0 ) {
				return $image_data;
			}
			else {
				return false;
			}

		}
	}

    /* -------------------------------------------------------------------------
        GET TAXONOMY TERM PARENTS
    ------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_get_term_parents' ) ) {
		function lsvr_get_term_parents( $term_id, $taxonomy, $max_limit = 5 ) {

			$term = get_term( $term_id, $taxonomy );
			if ( $term->parent !== 0 ) {

				$parents_arr = array();
				$counter = 0;
				$parent_id = $term->parent;

				while ( $parent_id !== 0 && $counter < $max_limit ) {
					array_unshift( $parents_arr, $parent_id );
					$parent = get_term( $parent_id, $taxonomy );
					$parent_id = $parent->parent;
					$counter++;
				}
				return $parents_arr;

			}
			else {
				return array();
			}

		}
	}

    /* -------------------------------------------------------------------------
        GET THE CONTENT WITH FORMATTING
    ------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_get_the_content' ) ) {
		function lsvr_get_the_content( $more_link_text = '(more...)', $stripteaser = 0, $more_file = '' ) {
			$content = get_the_content( $more_link_text, $stripteaser, $more_file );
			$content = apply_filters( 'the_content', $content );
			$content = str_replace( ']]>', ']]&gt;', $content );
			return $content;
		}
	}

    /* -------------------------------------------------------------------------
        EXCERPT BY ID
    ------------------------------------------------------------------------- */

    /*
	* http://pippinsplugins.com/a-better-wordpress-excerpt-by-id-function/
    * Gets the excerpt of a specific post ID or object
    * @param - $post - object/int - the ID or object of the post to get the excerpt of
    * @param - $length - int - the length of the excerpt in words
    * @param - $tags - string - the allowed HTML tags. These will not be stripped out
    * @param - $extra - string - text to append to the end of the excerpt
    */

	if ( ! function_exists( 'lsvr_excerpt_by_id' ) ) {
		function lsvr_excerpt_by_id( $post, $length = 10, $tags = '<a><em><strong>', $extra = ' &hellip;' ) {

			if ( is_int( $post ) ) {
				// get the post object of the passed ID
				$post = get_post($post);
			} elseif ( ! is_object( $post ) ) {
				return false;
			}

			if ( has_excerpt( $post->ID ) && $length < 1 ) {

				$the_excerpt = $post->post_excerpt;
				return apply_filters( 'the_content', $the_excerpt );

			} else {
				$the_excerpt = $post->post_content;
			}

			$the_excerpt = strip_shortcodes( strip_tags( $the_excerpt ), $tags );
			$the_excerpt = preg_split( '/\b/', $the_excerpt, $length * 2+1 );
			$excerpt_waste = array_pop( $the_excerpt );
			$the_excerpt = implode( $the_excerpt );
			$the_excerpt .= $extra;

			return apply_filters( 'the_content', $the_excerpt );

		}

	}

    /* -------------------------------------------------------------------------
        POLYLANG PLUGIN SUPPORT
    ------------------------------------------------------------------------- */

	if ( function_exists( 'pll_register_string' ) ) {
		pll_register_string( 'Header Branding Info', lsvr_get_field( 'header_branding_info' ) );
		pll_register_string( 'Header CTA Button Label', lsvr_get_field( 'header_cta_label' ) );
		pll_register_string( 'Breadcrumbs Home Label', lsvr_get_field( 'header_breadcrumbs_home_label', __( 'Home', 'lsvrtheme' ) ) );
		pll_register_string( 'Breadcrumbs Services Label', lsvr_get_field( 'services_page_title', __( 'Services', 'lsvrtheme' ) ) );
		pll_register_string( 'Breadcrumbs Projects Label', lsvr_get_field( 'projects_page_title', __( 'Projects', 'lsvrtheme' ) ) );
		pll_register_string( 'Footer CTA Title', lsvr_get_field( 'footer_cta_title', '' ) );
		pll_register_string( 'Footer CTA Text', lsvr_get_field( 'footer_cta_text', '' ) );
		pll_register_string( 'Footer CTA Button Label', lsvr_get_field( 'footer_cta_button_label', '' ) );
		pll_register_string( 'Footer CTA Button Link', lsvr_get_field( 'footer_cta_button_link', '' ) );
		pll_register_string( 'Footer Text', lsvr_get_field( 'footer_text', '' ) );
		pll_register_string( 'Service List Page Subtitle', lsvr_get_field( 'service_list_subtitle', '' ) );
		pll_register_string( 'Project List Page Subtitle', lsvr_get_field( 'project_list_subtitle', '' ) );
		pll_register_string( 'Blog "More" Button Label', lsvr_get_field( 'blog_list_more_label', __( 'Read More', 'lsvrtheme' ) ) );
		pll_register_string( 'Page 404 Title', lsvr_get_field( 'page404_title', __( '<strong>404</strong><br>Page Not Found', 'lsvrtheme' ) ) );
		pll_register_string( 'Page 404 Message', lsvr_get_field( 'page404_subtitle', __( 'The page you are looking for is no longer available or has been moved.', 'lsvrtheme' ) ) );
	}

    /* -------------------------------------------------------------------------
        ENABLE STYLE SWITCHER
    ------------------------------------------------------------------------- */

	if ( defined( 'LSVR_DEMO' ) && true == LSVR_DEMO ) {
		add_filter( 'body_class', 'lsvr_bluecollar_style_switcher_body_class' );
		if ( ! function_exists( 'lsvr_bluecollar_style_switcher_body_class' ) ) {
			function lsvr_bluecollar_style_switcher_body_class( $classes ) {
				$classes[] = 'm-style-switcher';
				return $classes;
			}
		}
	}

    /* -------------------------------------------------------------------------
        EXPORT XML FIX
    ------------------------------------------------------------------------- */

	if ( ! function_exists( 'lsvr_dummy_wp_get_attachment_url' ) ) {
		function lsvr_dummy_wp_get_attachment_url( $url, $post_id ){
			return 'https://i.postimg.cc/xdrC3VxL/dummy.jpg';
		}
	}
    //add_filter( 'wp_get_attachment_url' , 'lsvr_dummy_wp_get_attachment_url' , 10 , 2 );

?>