<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head data-template-uri="<?php echo get_template_directory_uri() ?>">
    <meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo( 'charset' ); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="profile" href="http://gmpg.org/xfn/11" />
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php if ( lsvr_get_image_field( 'favicon' ) ) { ?><link rel="shortcut icon" href="<?php echo lsvr_get_image_field( 'favicon' ); ?>"><?php } ?>
    <?php wp_head(); ?>
</head>

<?php // GET PAGE ID
$page_id = is_page() ? $wp_query->post->ID : false; ?>

<?php // ENABLE FIXED HEADER
$body_class = lsvr_get_field( 'header_fixed_enable', true, true ) ? ' m-fixed-header' : ''; ?>

<body <?php body_class( $body_class ); ?>>

	<!-- WRAPPER : begin -->
	<div id="wrapper">

		<!-- HEADER : begin -->
		<header id="header">
			<div class="header-inner">
				<div class="container">

					<!-- HEADER BRANDING : begin -->
					<div class="header-branding">
						<div class="branding-inner">

							<?php if ( lsvr_get_image_field( 'header_logo' ) || lsvr_get_image_field( 'header_logo_2x' ) ) : ?>
							<!-- BRANDING LOGO : begin -->
							<div class="brading-logo">
								<a href="<?php echo home_url(); ?>"><img src="<?php echo esc_url( lsvr_get_image_field( 'header_logo' ) ); ?>"
									data-hires="<?php echo esc_url( lsvr_get_image_field( 'header_logo_2x' ) ); ?>" alt="<?php bloginfo( 'name' ); ?>"></a>
							</div>
							<!-- BRANDING LOGO : end -->
							<?php endif; ?>

							<?php if ( lsvr_get_field( 'header_branding_info' ) ) : ?>
							<!-- BRANDING INFO : begin -->
							<div class="brading-info">
								<?php if ( function_exists( 'pll__' ) ) : ?>
									<?php echo pll__( lsvr_get_field( 'header_branding_info' ) ); ?>
								<?php else: ?>
									<?php echo lsvr_get_field( 'header_branding_info' ); ?>
								<?php endif; ?>
							</div>
							<!-- BRANDING INFO : end -->
							<?php endif; ?>

						</div>
					</div>
					<!-- HEADER BRANDING : end -->

					<!-- NAVIGATION TOGGLE : begin -->
					<button class="header-navigation-toggle" type="button"><i class="fa fa-bars"></i></button>
					<!-- NAVIGATION TOGGLE : end -->

					<!-- HEADER NAVIGATION : begin -->
					<div class="header-navigation">
						<div class="navigation-inner">

							<?php // HEADER MENU
							get_template_part( 'menu', 'header' ); // Load menu-header.php template. ?>

							<?php if ( lsvr_get_field( 'header_search_enable', true, true ) ) : ?>
							<!-- HEADER SEARCH : begin -->
							<div class="header-search">
								<?php get_search_form() ?>
								<button class="search-toggle" type="button"><i class="fa fa-search"></i></button>
							</div>
							<!-- HEADER SEARCH : end -->
							<?php endif; ?>

						</div>
					</div>
					<!-- HEADER NAVIGATION : end -->

				</div>
			</div>
		</header>
		<!-- HEADER : end -->