<?php

$redux_opt_name = 'theme_options';

if ( ! function_exists( 'redux_add_metaboxes' ) ):
    function redux_add_metaboxes( $metaboxes ) {

/* -----------------------------------------------------------------------------

    GENERAL VARIABLES

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		SIDEBAR ARRAY
	------------------------------------------------------------------------- */

	$sidebars_arr = array();
	if ( is_active_sidebar( 'default-sidebar' ) ) {
		$sidebars_arr[ 'default-sidebar' ] = __( 'Default Sidebar', 'lsvrtheme' );
	}
	for ( $i = 1; $i <= 10; $i++ ) {
		if ( is_active_sidebar( 'custom-sidebar-' . $i ) ) {
			$sidebars_arr[ 'custom-sidebar-' . $i ] = sprintf( __( 'Custom Sidebar %s', 'lsvrtheme' ), $i );
		}
	}


/* -----------------------------------------------------------------------------

    PAGE SETTINGS

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		HEADER
	------------------------------------------------------------------------- */

	$page_settings[] = array(
		'title' => __( 'Header', 'lsvrtheme' ),
		'desc' => __( 'Global settings are defined in <strong>Theme Options</strong>. If you want to override those settings for this page, choose <strong>Custom/Enable</strong>. To hide element, choose <strong>Disable</strong>. Please note, that these settings have no effect when you are using <strong>Full Width w/o Title</strong> template', 'lsvrtheme'),
		'icon' => 'el-icon-cog',
		'fields' => array(

			// SERVICE LIST
            array(
                'id' => 'meta_header_services_enable',
				'type' => 'button_set',
				'title' => __( 'Show Service List', 'lsvrtheme' ),
				'subtitle' => __( 'You can edit Service List settings under <strong>Theme Options / Header Settings</strong>.', 'lsvrtheme' ),
				'options' => array( 'global' => __( 'Global', 'lsvrtheme' ), 'enable' => __( 'Enable', 'lsvrtheme' ), 'disable' => __( 'Disable', 'lsvrtheme' ) ),
                'default' => 'global'
			),

			// PAGE TITLE
            array(
                'id' => 'meta_header_title',
				'type' => 'text',
				'title' => __( 'Override Page Title', 'lsvrtheme' ),
				'subtitle' => __( 'Useful if you want to use some HTML which shouldn\'t be visible in, for example, breadcrumbs (where default page title will be used).', 'lsvrtheme' ),
			),

			// BREADCRUMBS
            array(
                'id' => 'meta_header_breadcrumbs_enable',
				'type' => 'button_set',
				'title' => __( 'Show Breadcrumbs', 'lsvrtheme' ),
				'subtitle' => __( 'You can edit Breadcrumbs settings under <strong>Theme Options / Header Settings</strong>.', 'lsvrtheme' ),
				'options' => array( 'global' => __( 'Global', 'lsvrtheme' ), 'enable' => __( 'Enable', 'lsvrtheme' ), 'disable' => __( 'Disable', 'lsvrtheme' ) ),
                'default' => 'global'
			),

            // CONTACT PANEL
            array(
                'id' => 'meta_header_contact_panel_enable',
				'type' => 'button_set',
				'title' => __( 'Show Contact Panel', 'lsvrtheme' ),
				'options' => array( 'global' => __( 'Global', 'lsvrtheme' ), 'enable' => __( 'Enable', 'lsvrtheme' ), 'disable' => __( 'Disable', 'lsvrtheme' ) ),
				'subtitle' => __( 'You can edit Contact Panel settings under <strong>Theme Options / Header Settings</strong>.', 'lsvrtheme' ),
                'default' => 'global'
			),

		)
	);

	/* -------------------------------------------------------------------------
		FOOTER
	------------------------------------------------------------------------- */

	$page_settings[] = array(
		'title' => __( 'Footer', 'lsvrtheme' ),
		'desc' => __( 'Global settings are defined in <strong>Theme Options</strong>. If you want to override those settings for this page, choose <strong>Custom/Enable</strong>. To hide element, choose <strong>Disable</strong>.', 'lsvrtheme'),
		'icon' => 'el-icon-cog',
		'fields' => array(

			// FOOTER CTA ENABLE
            array(
                'id' => 'meta_footer_cta_enable',
				'type' => 'button_set',
				'title' => __( 'Footer CTA', 'lsvrtheme' ),
				'options' => array( 'global' => __( 'Global', 'lsvrtheme' ), 'custom' => __( 'Custom', 'lsvrtheme' ), 'disable' => __( 'Disable', 'lsvrtheme' ) ),
				'default' => 'global'
			),

			// FOOTER CTA TITLE
            array(
                'id' => 'meta_footer_cta_title',
				'type' => 'text',
				'title' => __( 'Footer CTA Title', 'lsvrtheme' ),
				'subtitle' => __( 'Leave blank to hide it.', 'lsvrtheme' ),
				'default' => __( 'Did You <strong>Know</strong>?', 'lsvrtheme' ),
				'required'  => array( 'meta_footer_cta_enable', "=", 'custom' ),
			),

			// FOOTER CTA TEXT
            array(
                'id' => 'meta_footer_cta_text',
				'type' => 'editor',
				'title' => __( 'Footer CTA Text', 'lsvrtheme' ),
				'subtitle' => __( 'Leave blank to hide it.', 'lsvrtheme' ),
				'default' => __( 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa.', 'lsvrtheme' ),
				'required'  => array( 'meta_footer_cta_enable', "=", 'custom' ),
			),

			// FOOTER CTA BUTTON LABEL
            array(
                'id' => 'meta_footer_cta_button_label',
				'type' => 'text',
				'title' => __( 'Footer CTA Button Label', 'lsvrtheme' ),
				'subtitle' => __( 'Leave blank to hide it.', 'lsvrtheme' ),
				'default' => __( 'Learn More', 'lsvrtheme' ),
				'required'  => array( 'meta_footer_cta_enable', "=", 'custom' ),
			),

			// FOOTER CTA BUTTON LINK
            array(
                'id' => 'meta_footer_cta_button_link',
				'type' => 'text',
				'title' => __( 'Footer CTA Button Link', 'lsvrtheme' ),
				'default' => '#',
				'required'  => array( 'meta_footer_cta_enable', "=", 'custom' ),
			),

		)
	);

	/* -------------------------------------------------------------------------
		SIDEBAR
	------------------------------------------------------------------------- */

	$page_settings[] = array(
		'title' => __( 'Sidebar', 'lsvrtheme' ),
		'desc' => __( 'You can assign a sidebar to this page (<strong>it will be displayed only if the selected template supports sidebars</strong>). Custom sidebars can be managed under <strong>"Theme Options / Sidebars"</strong>. Sidebar must contain <strong>at least one widget</strong> to be listed here.', 'lsvrtheme'),
		'icon' => 'el-icon-puzzle',
		'fields' => array(

			// SELECT SIDEBARS
			array(
				'id' => 'meta_sidebar_name',
				'type' => 'select',
				'title' => __( 'Select Sidebar', 'lsvrtheme' ),
				'options' => $sidebars_arr,
			),

			// SIDEBAR POSITION
			array(
				'id' => 'meta_sidebar_position',
				'type' => 'button_set',
				'title' => __( 'Sidebar Position', 'lsvrtheme' ),
				'options' => array( 'left' => __( 'Left', 'lsvrtheme' ), 'right' => __( 'Right', 'lsvrtheme' ) ),
				'default' => 'right',
			),

		)
	);

	$metaboxes[] = array(
		'id' => 'page_settings',
		'title' => __( 'Page Settings', 'lsvrtheme'),
		'post_types' => array( 'page' ),
		'position' => 'normal',
		'priority' => 'high',
		'sidebar' => false,
		'sections' => $page_settings
	);

/* -----------------------------------------------------------------------------

    SERVICE SETTINGS

----------------------------------------------------------------------------- */

	$service_settings[] = array(
		'title' => __( 'General', 'lsvrtheme' ),
		'icon' => 'el-icon-wrench',
		'fields' => array(

			// THUMBNAIL
			array(
				'id' => 'meta_service_thumb_image',
				'type' => 'media',
				'title' => __( 'Service Thumbnail', 'lsvrtheme' ),
			),

			// ICON
			array(
				'id' => 'meta_service_icon',
				'type' => 'text',
				'title' => __( 'Service Icon', 'lsvrtheme' ),
				'subtitle' => __( 'Add an icon class here, e.g. "im im-wrench". Please see the documentation for complete list of icons."', 'lsvrtheme' ),
			),

		)
	);

	$metaboxes[] = array(
		'id' => 'service_settings',
		'title' => __( 'Service Settings', 'lsvrtheme'),
		'post_types' => array( 'lsvrservice' ),
		'position' => 'normal',
		'priority' => 'high',
		'sidebar' => false,
		'sections' => $service_settings
	);

/* -----------------------------------------------------------------------------

    PROJECT SETTINGS

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		MEDIA
	------------------------------------------------------------------------- */

	$project_settings[] = array(
		'title' => __( 'Media', 'lsvrtheme' ),
		'icon' => 'el-icon-picture',
		'fields' => array(

			// THUMBNAIL
			array(
				'id' => 'meta_project_thumb_image',
				'type' => 'media',
				'title' => __( 'Project Thumbnail', 'lsvrtheme' ),
			),

			// GALLERY
			array(
				'id' => 'meta_project_gallery',
				'type' => 'gallery',
				'title' => __( 'Project Gallery', 'lsvrtheme' ),
			),

			// GALLERY POSITION
			array(
				'id' => 'meta_project_media_position',
				'type' => 'button_set',
				'title' => __( 'Gallery Position', 'lsvrtheme' ),
				'options' => array( 'top' => __( 'Top', 'lsvrtheme' ), 'bottom' => __( 'Bottom', 'lsvrtheme' ), 'left' => __( 'Left', 'lsvrtheme' ), 'right' => __( 'Right', 'lsvrtheme' ) ),
				'default' => 'top',
			),

			// IMAGES PER ROW
			array(
				'id' => 'meta_project_images_per_row',
				'type' => 'slider',
				'title' => __( 'Images Per Row', 'lsvrtheme' ),
				'default' => '1',
                'min' => '1',
                'step' => '1',
                'max' => '4'
			),

			// LIGHTBOX
			array(
				'id' => 'meta_project_gallery_lightbox',
				'type' => 'switch',
				'title' => __( 'Open Images in Lightbox', 'lsvrtheme' ),
				'default' => 1,
			),

		)
	);

	/* -------------------------------------------------------------------------
		INFO
	------------------------------------------------------------------------- */

	$project_settings[] = array(
		'title' => __( 'Info', 'lsvrtheme' ),
		'icon' => 'el-icon-list',
		'desc' => __( 'The following fields can be used for adding some extra info for this project. For example author name or URL.', 'lsvrtheme' ),
		'fields' => array(

			// CUSTOM FIELD 1 TITLE
			array(
				'id' => 'meta_project_info1_title',
				'type' => 'text',
				'title' => __( 'Custom Field 1 Title:', 'lsvrtheme' ),
			),

			// CUSTOM FIELD 1 TEXT
			array(
				'id' => 'meta_project_info1_text',
				'type' => 'textarea',
				'title' => __( 'Custom Field 1 Text:', 'lsvrtheme' ),
			),

			// CUSTOM FIELD 2 TITLE
			array(
				'id' => 'meta_project_info2_title',
				'type' => 'text',
				'title' => __( 'Custom Field 2 Title:', 'lsvrtheme' )
			),

			// CUSTOM FIELD 2 TEXT
			array(
				'id' => 'meta_project_info2_text',
				'type' => 'textarea',
				'title' => __( 'Custom Field 2 Text:', 'lsvrtheme' )
			),

			// CUSTOM FIELD 3 TITLE
			array(
				'id' => 'meta_project_info3_title',
				'type' => 'text',
				'title' => __( 'Custom Field 3 Title:', 'lsvrtheme' )
			),

			// CUSTOM FIELD 3 TEXT
			array(
				'id' => 'meta_project_info3_text',
				'type' => 'textarea',
				'title' => __( 'Custom Field  Text:', 'lsvrtheme' )
			),

			// CUSTOM FIELD 4 TITLE
			array(
				'id' => 'meta_project_info4_title',
				'type' => 'text',
				'title' => __( 'Custom Field 4 Title:', 'lsvrtheme' )
			),

			// CUSTOM FIELD 4 TEXT
			array(
				'id' => 'meta_project_info4_text',
				'type' => 'textarea',
				'title' => __( 'Custom Field 4 Text:', 'lsvrtheme' )
			),

		)
	);

	$metaboxes[] = array(
		'id' => 'project_settings',
		'title' => __( 'Project Settings', 'lsvrtheme' ),
		'post_types' => array( 'lsvrproject' ),
		'position' => 'normal',
		'priority' => 'high',
		'sections' => $project_settings
	);


/* -----------------------------------------------------------------------------

    SLIDE SETTINGS

----------------------------------------------------------------------------- */

	$slide_settings[] = array(
		'fields' => array(

			// VERTICAL ALIGN
			array(
				'id' => 'meta_slide_valign',
				'type' => 'button_set',
				'title' => __( 'Vertical Align:', 'lsvrtheme' ),
				'options' => array( 'top' => __( 'Top', 'lsvrtheme' ), 'middle' => __( 'Middle', 'lsvrtheme' ), 'bottom' => __( 'Bottom', 'lsvrtheme' ) ),
				'default' => 'middle',
			),

		)
	);

	$metaboxes[] = array(
		'id' => 'slide-settings',
		'title' => __( 'Slide Settings', 'lsvrtheme' ),
		'post_types' => array( 'lsvrslide' ),
		'position' => 'normal',
		'priority' => 'high',
		'sections' => $slide_settings
	);

	// SECTIONS END

	return $metaboxes;

	}
	add_action( 'redux/metaboxes/' . $redux_opt_name . '/boxes', 'redux_add_metaboxes' );
endif;

// The loader will load all of the extensions automatically based on your $redux_opt_name
require_once(dirname(__FILE__).'/loader.php');