<?php

if (!class_exists('Redux_Framework_Lsvrtheme_config')) {

    class Redux_Framework_Lsvrtheme_config {

        public $args        = array();
        public $sections    = array();
        public $theme;
        public $ReduxFramework;

        public function __construct() {

            if (!class_exists('ReduxFramework')) {
                return;
            }

            // This is needed. Bah WordPress bugs.  ;)
            if ( true == Redux_Helpers::isTheme(__FILE__) ) {
                $this->initSettings();
            } else {
                add_action('plugins_loaded', array($this, 'initSettings'), 10);
            }

        }

        public function initSettings() {

            // Just for demo purposes. Not needed per say.
            //$this->theme = wp_get_theme();

            // Set the default arguments
            $this->setArguments();

            // Set a few help tabs so you can see how it's done
            //$this->setHelpTabs();

            // Create the sections and fields
            $this->setSections();

            if (!isset($this->args['opt_name'])) { // No errors please
                return;
            }

            // If Redux is running as a plugin, this will remove the demo notice and links
            add_action( 'redux/loaded', array( $this, 'remove_demo' ) );

            // Function to test the compiler hook and demo CSS output.
            // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
            //add_filter('redux/options/'.$this->args['opt_name'].'/compiler', array( $this, 'compiler_action' ), 10, 3);

            // Change the arguments after they've been declared, but before the panel is created
            //add_filter('redux/options/'.$this->args['opt_name'].'/args', array( $this, 'change_arguments' ) );

            // Change the default value of a field after it's been set, but before it's been useds
            //add_filter('redux/options/'.$this->args['opt_name'].'/defaults', array( $this,'change_defaults' ) );

            // Dynamically add a section. Can be also used to modify sections/fields
            //add_filter('redux/options/' . $this->args['opt_name'] . '/sections', array($this, 'dynamic_section'));

            $this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
        }

        /**

          This is a test function that will let you see when the compiler hook occurs.
          It only runs if a field	set with compiler=>true is changed.

         * */
        function compiler_action($options, $css, $changed_values) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r($changed_values); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )

            /*
              // Demo of how to use the dynamic CSS and write your own static CSS file
              $filename = dirname(__FILE__) . '/style' . '.css';
              global $wp_filesystem;
              if( empty( $wp_filesystem ) ) {
                require_once( ABSPATH .'/wp-admin/includes/file.php' );
              WP_Filesystem();
              }

              if( $wp_filesystem ) {
                $wp_filesystem->put_contents(
                    $filename,
                    $css,
                    FS_CHMOD_FILE // predefined mode settings for WP files
                );
              }
             */
        }

        /**

          Custom function for filtering the sections array. Good for child themes to override or add to the sections.
          Simply include this function in the child themes functions.php file.

          NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
          so you must use get_template_directory_uri() if you want to use any of the built in icons

         * */
        function dynamic_section($sections) {
            //$sections = array();
            $sections[] = array(
                'title' => __('Section via hook', 'lsvrtheme'),
                'desc' => __('<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'lsvrtheme'),
                'icon' => 'el-icon-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }

        /**

          Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.

         * */
        function change_arguments($args) {
            //$args['dev_mode'] = true;

            return $args;
        }

        /**

          Filter hook for filtering the default value of any given field. Very useful in development mode.

         * */
        function change_defaults($defaults) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }

        // Remove the demo link and the notice of integrated demo from the redux-framework plugin
        function remove_demo() {

            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if (class_exists('ReduxFrameworkPlugin')) {
                remove_filter('plugin_row_meta', array(ReduxFrameworkPlugin::instance(), 'plugin_metalinks'), null, 2);

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
            }
        }

        public function setSections() {

            /**
              Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
             * */
            // Background Patterns Reader
            $sample_patterns_path   = ReduxFramework::$_dir . '../sample/patterns/';
            $sample_patterns_url    = ReduxFramework::$_url . '../sample/patterns/';
            $sample_patterns        = array();

            if (is_dir($sample_patterns_path)) :

                if ($sample_patterns_dir = opendir($sample_patterns_path)) :
                    $sample_patterns = array();

                    while (( $sample_patterns_file = readdir($sample_patterns_dir) ) !== false) {

                        if (stristr($sample_patterns_file, '.png') !== false || stristr($sample_patterns_file, '.jpg') !== false) {
                            $name = explode('.', $sample_patterns_file);
                            $name = str_replace('.' . end($name), '', $sample_patterns_file);
                            $sample_patterns[]  = array('alt' => $name, 'img' => $sample_patterns_url . $sample_patterns_file);
                        }
                    }
                endif;
            endif;

            ob_start();

            $ct             = wp_get_theme();
            $this->theme    = $ct;
            $item_name      = $this->theme->get('Name');
            $tags           = $this->theme->Tags;
            $screenshot     = $this->theme->get_screenshot();
            $class          = $screenshot ? 'has-screenshot' : '';

            $customize_title = sprintf(__('Customize &#8220;%s&#8221;', 'lsvrtheme'), $this->theme->display('Name'));

            ?>
            <div id="current-theme" class="<?php echo esc_attr($class); ?>">
            <?php if ($screenshot) : ?>
                <?php if (current_user_can('edit_theme_options')) : ?>
                        <a href="<?php echo wp_customize_url(); ?>" class="load-customize hide-if-no-customize" title="<?php echo esc_attr($customize_title); ?>">
                            <img src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview'); ?>" />
                        </a>
                <?php endif; ?>
                    <img class="hide-if-customize" src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview'); ?>" />
                <?php endif; ?>

                <h4><?php echo $this->theme->display('Name'); ?></h4>

                <div>
                    <ul class="theme-info">
                        <li><?php printf(__('By %s', 'lsvrtheme'), $this->theme->display('Author')); ?></li>
                        <li><?php printf(__('Version %s', 'lsvrtheme'), $this->theme->display('Version')); ?></li>
                        <li><?php echo '<strong>' . __('Tags', 'lsvrtheme') . ':</strong> '; ?><?php printf($this->theme->display('Tags')); ?></li>
                    </ul>
                    <p class="theme-description"><?php echo $this->theme->display('Description'); ?></p>
            <?php
            if ($this->theme->parent()) {
                printf(' <p class="howto">' . __('This <a href="%1$s">child theme</a> requires its parent theme, %2$s.') . '</p>', __('http://codex.wordpress.org/Child_Themes', 'lsvrtheme'), $this->theme->parent()->display('Name'));
            }
            ?>

                </div>
            </div>

            <?php
            $item_info = ob_get_contents();

            ob_end_clean();

            $sampleHTML = '';
            if (file_exists(dirname(__FILE__) . '/info-html.html')) {
                /** @global WP_Filesystem_Direct $wp_filesystem  */
                global $wp_filesystem;
                if (empty($wp_filesystem)) {
                    require_once(ABSPATH . '/wp-admin/includes/file.php');
                    WP_Filesystem();
                }
                $sampleHTML = $wp_filesystem->get_contents(dirname(__FILE__) . '/info-html.html');
            }

/* -----------------------------------------------------------------------------

    SECTIONS

----------------------------------------------------------------------------- */

	$lsvr_theme_options = get_option( 'theme_options' );

    /* -------------------------------------------------------------------------
        GENERAL
    ------------------------------------------------------------------------- */

	$this->sections[] = array(
		'title'     => __( 'General Settings', 'lsvrtheme' ),
		'icon'      => 'el-icon-home',
		'fields'    => array(

            // FAVICON
            array(
                'id' => 'favicon',
				'type' => 'media',
				'title' => __( 'Favicon', 'lsvrtheme' ),
				'subtitle' => __( '64px x 64px .PNG file.', 'lsvrtheme' ),
				'mode' => false
			),

			array(
				'id'   => 'general_divider_20',
				'type' => 'divide'
			),

            // SOCIAL ICONS
            array(
                'id' => 'social_links',
				'type' => 'sortable',
				'title' => __( 'Social Links', 'lsvrtheme' ),
                'subtitle' => __( 'Fill in the respective field with a full URL (starting with http:// or https:// respectively).', 'lsvrtheme' ),
                'label' => true,
                'options' => array(
                    'AngelList' => '',
                    'Behance' => '',
                    'Bitbucket' => '',
                    'Bitcoin' => '',
                    'Codepen' => '',
                    'Delicious' => '',
					'DeviantArt' => '',
                    'Digg' => '',
                    'Dribbble' => '',
                    'Dropbox' => '',
					'Email' => '',
                    'Facebook' => '',
                    'Flickr' => '',
                    'FourSquare' => '',
					'Git' => '',
                    'GitHub' => '',
                    'GooglePlus' => '',
                    'Instagram' => '',
					'LastFM' => '',
                    'LinkedIn' => '',
                    'PayPal' => '',
                    'Pinterest' => '',
                    'Reddit' => '',
                    'Skype' => '',
					'SoundCloud' => '',
                    'Spotify' => '',
					'Steam' => '',
                    'Trello' => '',
					'Tumblr' => '',
					'Twitch' => '',
					'Twitter' => '',
					'Vimeo' => '',
					'Vine' => '',
					'VK' => '',
					'WordPress' => '',
					'Xing' => '',
					'Yahoo' => '',
					'Yelp' => '',
					'YouTube' => '',
        	    ),
			),

			// SOCIAL ICONS TARGET
            array(
                'id' => 'social_links_target',
				'type' => 'switch',
				'title' => __( 'Open Social Links in New Tab', 'lsvrtheme' ),
                'default' => 0
			),

            // GOOGLE MAPS API
            array(
                'id' => 'gmap_api_key',
                'type' => 'text',
                'title' => __( 'Google Maps API Key', 'lsvrtheme' ),
                'subtitle' => __( 'The API key is required if you want to use Google Map element. Generate your own API key', 'lsvrtheme' ) . '<br><a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">https://developers.google.com/maps/documentation/javascript/get-api-key</a>',
            ),

		),
	);

    /* -------------------------------------------------------------------------
        HEADER
    ------------------------------------------------------------------------- */

	$this->sections[] = array(
		'title'     => __( 'Header Settings', 'lsvrtheme' ),
		'icon'      => 'el-icon-cog',
		'fields'    => array(

            // FIXED HEADER
            array(
                'id' => 'header_fixed_enable',
				'type' => 'switch',
				'title' => __( 'Fixed Top Bar', 'lsvrtheme' ),
				'subtitle' => __( 'Top Bar is the very top section of this theme which contains Branding, Menu and Search.', 'lsvrtheme' ),
                'default' => 1
			),

			array(
				'id'   => 'header_divider_10',
				'type' => 'divide'
			),

			// LOGO
            array(
                'id' => 'header_logo',
				'type' => 'media',
				'title' => __( 'Logo', 'lsvrtheme' ),
                'subtitle' => __( 'Height of the logo image should be 50px.', 'lsvrtheme' )
			),

			// LOGO 2X
            array(
                'id' => 'header_logo_2x',
				'type' => 'media',
				'title' => __( 'Retina Logo', 'lsvrtheme' ),
                'subtitle' => __( 'Retina (HiDPI) version of standard logo (optional). Its height should be 100px.', 'lsvrtheme' )
			),

			// HEADER INFO
            array(
                'id' => 'header_branding_info',
				'type' => 'text',
				'title' => __( 'Branding Info', 'lsvrtheme' ),
				'subtitle' => __( 'Text shown next to the logo. Ideal for branding purposes (especially if you don\'t have a logo), telephone number and so on. You can use some basic HTML here.', 'lsvrtheme' ),
				'default' => sprintf( '<strong>%s</strong><br><em>%s</em>', get_bloginfo( 'name' ), get_bloginfo( 'description' ) ),
			),

			array(
				'id'   => 'header_divider_20',
				'type' => 'divide'
			),

            // HEADER SEARCH
            array(
                'id' => 'header_search_enable',
				'type' => 'switch',
				'title' => __( 'Header Search', 'lsvrtheme' ),
                'default' => 1
			),

			array(
				'id'   => 'header_divider_30',
				'type' => 'divide'
			),

            // BACKGROUND IMAGE
            array(
                'id' => 'header_bg_image',
				'type' => 'media',
				'title' => __( 'Header Background Image', 'lsvrtheme' ),
				'subtitle' => __( 'Optimal resolution should be about 2000x1200px. Color overlay is added via CSS (you can disable it with Enable Color Overlay option below), so the image can be black and white to save bandwidth. This image can be overridden for individual pages by defining a Featured image.', 'lsvrtheme' ),
			),

            // NO COLOR OVERLAY
            array(
                'id' => 'header_color_overlay',
				'type' => 'switch',
				'title' => __( 'Enable Color Overlay on Background Image', 'lsvrtheme' ),
                'default' => 1
			),

            // FIXED BACKGROUND IMAGE
            array(
                'id' => 'header_bg_parallax',
				'type' => 'switch',
				'title' => __( 'Parallax Effect on Background Image', 'lsvrtheme' ),
                'default' => 1
			),

			array(
				'id'   => 'header_divider_40',
				'type' => 'divide'
			),

            // HEADER SERVICES
            array(
                'id' => 'header_services_enable',
				'type' => 'switch',
				'title' => __( 'Show Service List Globally', 'lsvrtheme' ),
				'subtitle' => __( 'This setting can be overriden for individual pages. Services can be added under <strong>Services</strong>.', 'lsvrtheme' ),
                'default' => 0
			),

            // SERVICES PER ROW
            array(
				'id' => 'header_services_items_per_row',
				'type' => 'slider',
				'title' => __( 'Number of Services Per Row', 'lsvrtheme' ),
				'default' => '4',
                'min' => '2',
                'step' => '1',
                'max' => '5',
			),

            // SERVICE LIST EXCERPT ENABLE
            array(
				'id' => 'header_services_excerpt_enable',
				'type' => 'switch',
				'title' => __( 'Show Excerpt', 'lsvrtheme' ),
				'default' => 1,
			),

            // SERVICE LIST MORE LINK ENABLE
            array(
				'id' => 'header_services_more_enable',
				'type' => 'switch',
				'title' => __( 'Show "More" Link', 'lsvrtheme' ),
				'default' => 1,
			),

			array(
				'id'   => 'header_divider_50',
				'type' => 'divide'
			),

            // BREADCRUMBS
            array(
                'id' => 'header_breadcrumbs_enable',
				'type' => 'switch',
				'title' => __( 'Show Breadcrumbs Globally', 'lsvrtheme' ),
				'subtitle' => __( 'You can override this setting under <strong>Page Settings</strong> when editing an individual page. For example, you may want to show Breadcrumbs for all pages except Home Page. In that case, enable it here and disable it under <strong>Page Settings</strong> of a particular page, which you want to use as a Home Page.', 'lsvrtheme' ),
                'default' => 1
			),

			// BREADCRUMBS HOME ENABLE
            array(
                'id' => 'header_breadcrumbs_home_enable',
				'type' => 'switch',
				'title' => __( 'Enable "Home" Link In Breadcrumbs', 'lsvrtheme' ),
                'default' => 1,
			),

			// BREADCRUMBS HOME LABEL
            array(
                'id' => 'header_breadcrumbs_home_label',
				'type' => 'text',
				'title' => __( '"Home" Link Label', 'lsvrtheme' ),
				'default' => __( 'Home', 'lsvrtheme' ),
				'required'  => array( 'header_breadcrumbs_home_enable', "=", 1 ),
			),

			array(
				'id'   => 'header_divider_60',
				'type' => 'divide'
			),

            // CONTACT PANEL
            array(
                'id' => 'header_contact_panel_enable',
				'type' => 'switch',
				'title' => __( 'Show Contact Panel Globally', 'lsvrtheme' ),
				'subtitle' => __( 'Contact Panel can contain some quick contact info (e.g. phone or email), social icons and CTA button. You can toggle the Contact Panel under <strong>Page Settings</strong> when editing an individual page.', 'lsvrtheme' ),
                'default' => 0
			),

			// QUICK CONTACT INFO 1 ICON
            array(
                'id' => 'header_quick_contact_1_icon',
				'type' => 'text',
				'title' => __( 'Quick Contact Info 1 Icon', 'lsvrtheme' ),
				'subtitle' => __( 'Add an icon class here, e.g. "fa fa-phone". Please see the documentation for complete list of icons.', 'lsvrtheme' ),
				'default' => 'fa fa-phone',
			),

			// QUICK CONTACT INFO 1 TEXT
            array(
                'id' => 'header_quick_contact_1_text',
				'type' => 'text',
				'title' => __( 'Quick Contact Info 1 Text', 'lsvrtheme' ),
				'default' => '<strong>123 456 789</strong>',
			),

			// QUICK CONTACT INFO 2 ICON
            array(
                'id' => 'header_quick_contact_2_icon',
				'type' => 'text',
				'title' => __( 'Quick Contact Info 2 Icon', 'lsvrtheme' ),
				'subtitle' => __( 'Add an icon class here, e.g. "fa fa-phone". Please see the documentation for complete list of icons.', 'lsvrtheme' ),
				'default' => 'fa fa-envelope-o',
			),

			// QUICK CONTACT INFO 2 TEXT
            array(
                'id' => 'header_quick_contact_2_text',
				'type' => 'text',
				'title' => __( 'Quick Contact Info 2 Text', 'lsvrtheme' ),
				'default' => '<strong><a href="help@bluecollar.com">help@bluecollar.com</a></strong>',
			),

			// QUICK CONTACT INFO 3 ICON
            array(
                'id' => 'header_quick_contact_3_icon',
				'type' => 'text',
				'title' => __( 'Quick Contact Info 3 Icon', 'lsvrtheme' ),
				'subtitle' => __( 'Add an icon class here, e.g. "fa fa-phone". Please see the documentation for complete list of icons.', 'lsvrtheme' ),
				'default' => '',
			),

			// QUICK CONTACT INFO 3 TEXT
            array(
                'id' => 'header_quick_contact_3_text',
				'type' => 'text',
				'title' => __( 'Quick Contact Info 3 Text', 'lsvrtheme' ),
				'default' => '',
			),

            // SOCIAL ICONS
            array(
                'id' => 'header_social_enable',
				'type' => 'switch',
				'title' => __( 'Show Social Icons in Contact Panel', 'lsvrtheme' ),
				'subtitle' => __( 'Social icons can be managed under <strong>General Settings</strong>.', 'lsvrtheme' ),
                'default' => 1,
			),

			// HEADER CTA LABEL
            array(
                'id' => 'header_cta_label',
				'type' => 'text',
				'title' => __( 'CTA Button Label', 'lsvrtheme' ),
				'subtitle' => __( 'Leave blank to hide CTA button.', 'lsvrtheme' ),
				'default' => __( 'Learn More', 'lsvrtheme' ),
			),

			// HEADER CTA LINK
            array(
                'id' => 'header_cta_link',
				'type' => 'text',
				'title' => __( 'CTA Button Link', 'lsvrtheme' ),
				'default' => '#',
			),

		),
	);

    /* -------------------------------------------------------------------------
        FOOTER
    ------------------------------------------------------------------------- */

	$this->sections[] = array(
		'title'     => __( 'Footer Settings', 'lsvrtheme' ),
		'icon'      => 'el-icon-cog',
		'fields'    => array(

            // BACKGROUND IMAGE
            array(
                'id' => 'footer_bg_image',
				'type' => 'media',
				'title' => __( 'Footer Background Image', 'lsvrtheme' ),
				'subtitle' => __( 'Optimal resolution should be about 2000x1200px. Color overlay is added via CSS, so the image can be black and white to save bandwidth.', 'lsvrtheme' ),
			),

            // PARALLAX BACKGROUND IMAGE
            array(
                'id' => 'footer_bg_parallax',
				'type' => 'switch',
				'title' => __( 'Parallax Effect on Background Image', 'lsvrtheme' ),
                'default' => 1
			),

			array(
				'id'   => 'footer_divider_10',
				'type' => 'divide'
			),

			// FOOTER CTA ENABLE
            array(
                'id' => 'footer_cta_enable',
				'type' => 'switch',
				'title' => __( 'Enable Footer CTA Globally', 'lsvrtheme' ),
                'subtitle' => __( 'You can override all CTA settings under <strong>Page Settings</strong> when editing an individual page.', 'lsvrtheme' ),
				'default' => 1
			),

			// FOOTER CTA TITLE
            array(
                'id' => 'footer_cta_title',
				'type' => 'text',
				'title' => __( 'Footer CTA Title', 'lsvrtheme' ),
				'subtitle' => __( 'Leave blank to hide it.', 'lsvrtheme' ),
				'default' => __( 'Did You <strong>Know</strong>?', 'lsvrtheme' )
			),

			// FOOTER CTA TEXT
            array(
                'id' => 'footer_cta_text',
				'type' => 'editor',
				'title' => __( 'Footer CTA Text', 'lsvrtheme' ),
				'subtitle' => __( 'Leave blank to hide it.', 'lsvrtheme' ),
				'default' => __( 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa.', 'lsvrtheme' )
			),

			// FOOTER CTA BUTTON LABEL
            array(
                'id' => 'footer_cta_button_label',
				'type' => 'text',
				'title' => __( 'Footer CTA Button Label', 'lsvrtheme' ),
				'subtitle' => __( 'Leave blank to hide it.', 'lsvrtheme' ),
				'default' => __( 'Learn More', 'lsvrtheme' )
			),

			// FOOTER CTA BUTTON LINK
            array(
                'id' => 'footer_cta_button_link',
				'type' => 'text',
				'title' => __( 'Footer CTA Button Link', 'lsvrtheme' ),
				'default' => '#'
			),

			array(
				'id'   => 'footer_divider_20',
				'type' => 'divide'
			),

            // BOTTOM PANEL COLUMNS
            array(
				'id' => 'bottom_panel_columns',
				'type' => 'slider',
				'title' => __( 'Bottom Panel Columns', 'lsvrtheme' ),
				'subtitle' => __( 'Set number of columns for Bottom Panel. In most cases, the number should be the same as number of widgets. Widgets can be added under <strong>Appearance / Widgets</strong>.', 'lsvrtheme' ),
				'default' => '3',
                'min' => '1',
                'step' => '1',
                'max' => '4',
			),

			array(
				'id'   => 'footer_divider_30',
				'type' => 'divide'
			),

            // SOCIAL ICONS
            array(
                'id' => 'footer_social_enable',
				'type' => 'switch',
				'title' => __( 'Show Social Icons', 'lsvrtheme' ),
				'subtitle' => __( 'Social icons will be displayed instead of footer menu. Social icons can be added under <strong>General Settings</strong>.', 'lsvrtheme' ),
				'default' => 0
			),

			array(
				'id'   => 'footer_divider_40',
				'type' => 'divide'
			),

            // FOOTER TEXT
            array(
                'id' => 'footer_text',
				'type' => 'editor',
				'title' => __( 'Footer Text', 'lsvrtheme' ),
                'subtitle' => __( 'Ideal for copyright notice.', 'lsvrtheme' ),
				'default' => '&copy; ' . date( 'Y' ) . ' ' . get_bloginfo( 'name' )
			),

		),
	);

	$this->sections[] = array(
		'type' => 'divide',
	);

    /* -------------------------------------------------------------------------
        STYLING
    ------------------------------------------------------------------------- */

	$this->sections[] = array(
        'title' => __( 'Styling', 'lsvrtheme' ),
		'icon' => 'el-icon-tint',
        'fields' => array(

            // THEME SKIN
            array(
                'id' => 'skin_default',
				'type' => 'select',
				'title' => __( 'Theme Color Scheme', 'lsvrtheme' ),
                'options' => array(
                    'default' => __( 'Default', 'lsvrtheme' ),
                    'skin2' => __( 'Skin 2', 'lsvrtheme' ),
                    'skin3' => __( 'Skin 3', 'lsvrtheme' ),
                    'skin4' => __( 'Skin 4', 'lsvrtheme' ),
                ),
                'default' => 'default',
				'required'  => array( 'skin_custom_enabled', "=", 0 ),
			),

            // ENABLE CUSTOM THEME SKIN
            array(
                'id' => 'skin_custom_enabled',
				'type' => 'switch',
				'title' => __( 'Enable Custom Color Scheme', 'lsvrtheme' ),
                'default' => 0
			),

            // CUSTOM THEME SKIN
			array(
				'id' => 'skin_custom_info',
				'type' => 'info',
				'desc' => __( 'Add a name of your color scheme file. <strong>Your file must be located in "/library/css/skin"</strong>. For example.: If your file is called "vanilla.css", add "vanilla" to the following input (without quotes). If you are using the child theme (<strong>which is highly recommended</strong>), the "/library/css/skin" path is relative to child theme\'s root directory. Please refer to the documentation on how to create custom color schemes.', 'lsvrtheme' ),
				'required'  => array( 'skin_custom_enabled', "=", 1 ),
            ),
            array(
                'id' => 'skin_custom_name',
				'type' => 'text',
				'title' => __( 'Custom Skin Name', 'lsvrtheme' ),
                'required'  => array( 'skin_custom_enabled', "=", 1 ),
				'default' => 'myskin'
			),

		),
	);

    /* -------------------------------------------------------------------------
        TYPOGRAPHY
    ------------------------------------------------------------------------- */

    $fonts_gf_enable = $lsvr_theme_options && array_key_exists( 'fonts_gf_enable', $lsvr_theme_options ) ? (bool) $lsvr_theme_options[ 'fonts_gf_enable' ] : true;

	$this->sections[] = array(
        'title' => __( 'Typography', 'lsvrtheme' ),
		'icon' => 'el-icon-fontsize',
        'fields' => array(

            // ENABLE GOOGLE FONTS
            array(
                'id' => 'fonts_gf_enable',
				'type' => 'switch',
				'title' => __( 'Enable Google Fonts', 'lsvrtheme' ),
                'default' => 1
			),

			// PRIMARY FONT
			array(
				'id'        => 'fonts_primary',
				'type'      => 'typography',
				'title'     => __( 'Primary Font', 'lsvrtheme' ),
				'subtitle'  => __( 'This is the default font. Default primary font family is "Source Sans Pro".', 'lsvrtheme' ),
				'google'    => $fonts_gf_enable,
				'all_styles' => true,
				'font-weight' => true,
				'font-style' => false,
				'line-height' => false,
				'text-align' => false,
				'subsets' => true,
				'color' => false,
				'default'   => array(
					'font-size'     => '16px',
					'font-weight'     => '400',
					'font-family'   => 'Source Sans Pro',
				),
				'required'  => array( 'fonts_gf_enable', "=", 1 ),
			),

			// SECONDARY FONT
			array(
				'id'        => 'fonts_secondary',
				'type'      => 'typography',
				'title'     => __( 'Secondary Font', 'lsvrtheme' ),
				'subtitle'  => __( 'This font is used mainly for headings. Default secondary font family is "Exo 2".', 'lsvrtheme' ),
				'google'    => $fonts_gf_enable,
				'all_styles' => true,
				'font-size' => false,
				'font-weight' => true,
				'font-style' => false,
				'line-height' => false,
				'text-align' => false,
				'subsets' => true,
				'color' => false,
				'default'   => array(
					'font-weight'   => '400',
					'font-family'   => 'Exo 2',
				),
				'required'  => array( 'fonts_gf_enable', "=", 1 ),
			),

		),
	);

	$this->sections[] = array(
		'type' => 'divide',
	);

    /* -------------------------------------------------------------------------
        SERVICES
    ------------------------------------------------------------------------- */

	$lsvr_services_slug = $lsvr_theme_options && array_key_exists( 'services_slug', $lsvr_theme_options ) ? $lsvr_theme_options[ 'services_slug' ] : 'services';

	$this->sections[] = array(
        'title' => __( 'Services', 'lsvrtheme' ),
		'icon' => 'el-icon-wrench',
        'fields' => array(

			// TOP INFO
			array(
				'id' => 'services_top_info',
				'type' => 'info',
				'desc' => sprintf( __( 'You can manage your services under <strong>Services</strong>. Default services page can be accessed via <a href="%s/%s">%s/%s</a>. Make sure to set your permalink settings (under <strong>Settings / Permalinks</strong>) to "Post name", otherwise your services page URL will be %s/?post_type=lsvrservice.', 'lsvrtheme' ), get_site_url(), $lsvr_services_slug, get_site_url(), $lsvr_services_slug, get_site_url() ),
            ),

			// SERVICES SORTING
            array(
                'id' => 'services_sort_alphabetically',
				'type' => 'switch',
				'title' => __( 'Sort Services Alphabetically', 'lsvrtheme' ),
                'default' => 1,
			),

			// SERVICES LINKING
            array(
                'id' => 'services_link_to_detail',
				'type' => 'switch',
				'title' => __( 'Link Service Thumbnail to Detail Page', 'lsvrtheme' ),
				'subtitle' => __( 'This will remove link from Service title. "More" button can be disabled by <strong>Show "More" Link</strong> option on this page and on <strong>Header Settings</strong> page.', 'lsvrtheme' ),
                'default' => 1,
			),

			// SERVICES TITLE
            array(
                'id' => 'services_page_title',
				'type' => 'text',
				'title' => __( 'Services Page Title', 'lsvrtheme' ),
				'subtitle' => __( 'It will be used for breadcrumb link as well.', 'lsvrtheme' ),
				'default' => __( 'Services', 'lsvrtheme' ),
			),

			// SERVICES SLUG
            array(
                'id' => 'services_slug',
				'type' => 'text',
				'title' => __( 'Services URL Slug', 'lsvrtheme' ),
				'subtitle' => sprintf( __( 'Slug defines the URL of your default services page. Your current URL is <a href="%s/%s">%s/%s</a>.<br><br><strong>IMPORTANT:</strong> After changing the slug, go to <strong>Settings / Permalinks</strong> and hit Save Changes.', 'lsvrtheme' ), get_site_url(), $lsvr_services_slug, get_site_url(), $lsvr_services_slug ),
				'default' => 'services',
			),

			array(
				'id'   => 'services_divider_10',
				'type' => 'divide'
			),

			// CONTACT PANEL ENABLE
            array(
                'id' => 'services_contact_panel_enable',
				'type' => 'button_set',
				'title' => __( 'Show Contact Panel on Service Pages', 'lsvrtheme' ),
				'subtitle' => __( 'Show Contact Panel on archive page (default service list) and service detail page. Contact Panel can be edited under <strong>Header Settings</strong>.', 'lsvrtheme' ),
				'options' => array( 'global' => __( 'Global', 'lsvrtheme' ), 'enable' => __( 'Enable', 'lsvrtheme' ), 'disable' => __( 'Disable', 'lsvrtheme' ) ),
                'default' => 'global',
			),

			array(
				'id'   => 'services_divider_20',
				'type' => 'divide'
			),

            // SERVICE LIST SUBTITLE
            array(
				'id' => 'service_list_subtitle',
				'type' => 'text',
				'title' => __( 'Service List Page Subtitle', 'lsvrtheme' ),
				'subtitle' => __( 'Subtitle for default service list page (archive page).', 'lsvrtheme' ),
				'default' => __( '<strong>We Are Specialists</strong> In These Areas', 'lsvrtheme' )
			),

            // SERVICES PER ROW
            array(
				'id' => 'service_list_items_per_row',
				'type' => 'slider',
				'title' => __( 'Number of Services Per Row', 'lsvrtheme' ),
				'subtitle' => __( 'It applies to default service list page (archive page).', 'lsvrtheme' ),
				'default' => '4',
                'min' => '1',
                'step' => '1',
                'max' => '4',
			),

            // SERVICE LIST EXCERPT ENABLE
            array(
				'id' => 'service_list_excerpt_enable',
				'type' => 'switch',
				'title' => __( 'Show Excerpt', 'lsvrtheme' ),
				'subtitle' => __( 'It applies to default service list page (archive page).', 'lsvrtheme' ),
				'default' => 1,
			),

            // SERVICE LIST MORE LINK ENABLE
            array(
				'id' => 'service_list_more_enable',
				'type' => 'switch',
				'title' => __( 'Show "More" Link', 'lsvrtheme' ),
				'subtitle' => __( 'It applies to default service list page (archive page).', 'lsvrtheme' ),
				'default' => 1,
			),

			array(
				'id'   => 'services_divider_30',
				'type' => 'divide'
			),

            // SERVICE DETAIL SIDEBAR ENABLE
            array(
				'id' => 'service_detail_sidebar_enable',
				'type' => 'switch',
				'title' => __( 'Show Service List on Detail', 'lsvrtheme' ),
				'default' => 1,
			),

			// SIDEBAR POSITION
            array(
                'id' => 'service_detail_sidebar_position',
				'type' => 'button_set',
				'title' => __( 'Position of Service List', 'lsvrtheme' ),
				'options' => array( 'left' => __( 'Left', 'lsvrtheme' ), 'right' => __( 'Right', 'lsvrtheme' ) ),
                'default' => 'left',
				'required'  => array( 'service_detail_sidebar_enable', "=", 1 ),
			),

		)
    );

    /* -------------------------------------------------------------------------
        PROJECTS
    ------------------------------------------------------------------------- */

	$lsvr_projects_slug = $lsvr_theme_options && array_key_exists( 'projects_slug', $lsvr_theme_options ) ? $lsvr_theme_options[ 'projects_slug' ] : 'projects';

	$this->sections[] = array(
        'title' => __( 'Projects', 'lsvrtheme' ),
		'icon' => 'el-icon-folder-open',
        'fields' => array(

			// TOP INFO
			array(
				'id' => 'projects_top_info',
				'type' => 'info',
				'desc' => sprintf( __( 'You can manage your projects under <strong>Projects</strong>. Default projects page can be accessed via <a href="%s/%s">%s/%s</a>. Make sure to set your permalink settings (under <strong>Settings / Permalinks</strong>) to "Post name", otherwise your projects page URL will be %s/?post_type=lsvrproject.', 'lsvrtheme' ), get_site_url(), $lsvr_projects_slug, get_site_url(), $lsvr_projects_slug, get_site_url() ),
            ),

			// PROJECTS TITLE
            array(
                'id' => 'projects_page_title',
				'type' => 'text',
				'title' => __( 'Projects Page Title', 'lsvrtheme' ),
				'subtitle' => __( 'It will be used for breadcrumb link as well.', 'lsvrtheme' ),
				'default' => __( 'Projects', 'lsvrtheme' ),
			),

			// PROJECTS SLUG
            array(
                'id' => 'projects_slug',
				'type' => 'text',
				'title' => __( 'Projects URL Slug', 'lsvrtheme' ),
				'subtitle' => sprintf( __( 'Slug defines the URL of your default projects page. Your current URL is <a href="%s/%s">%s/%s</a>.<br><br><strong>IMPORTANT:</strong> After changing the slug, go to <strong>Settings / Permalinks</strong> and hit Save Changes.', 'lsvrtheme' ), get_site_url(), $lsvr_projects_slug, get_site_url(), $lsvr_projects_slug ),
				'default' => 'projects',
			),

			// PROJECT CATEGORY SLUG
            array(
                'id' => 'project_cat_slug',
				'type' => 'text',
				'title' => __( 'Portfolio Category URL Slug', 'lsvrtheme' ),
				'subtitle' => __( 'This Slug defines the URL of page which shows posts from certain portfolio category.', 'lsvrtheme' ),
				'default' => 'portfolio-category',
			),

			array(
				'id'   => 'projects_divider_10',
				'type' => 'divide'
			),

			// CONTACT PANEL ENABLE
            array(
                'id' => 'projects_contact_panel_enable',
				'type' => 'button_set',
				'title' => __( 'Show Contact Panel on Project Pages', 'lsvrtheme' ),
				'subtitle' => __( 'Show Contact Panel on archive page (default project list) and project detail page. Contact Panel can be edited under <strong>Header Settings</strong>.', 'lsvrtheme' ),
				'options' => array( 'global' => __( 'Global', 'lsvrtheme' ), 'enable' => __( 'Enable', 'lsvrtheme' ), 'disable' => __( 'Disable', 'lsvrtheme' ) ),
                'default' => 'global',
			),

			array(
				'id'   => 'projects_divider_20',
				'type' => 'divide'
			),

            // PROJECT LIST SUBTITLE
            array(
				'id' => 'project_list_subtitle',
				'type' => 'text',
				'title' => __( 'Project List Page Subtitle', 'lsvrtheme' ),
				'subtitle' => __( 'Subtitle for default project list page (archive page) and project category page.', 'lsvrtheme' ),
				'default' => __( 'Here Are Some <strong>Interesting Projects</strong> We Did', 'lsvrtheme' )
			),

			// ENABLE CATEGORIES ON DEFAULT LIST
            array(
                'id' => 'project_list_categories_enable',
				'type' => 'switch',
				'title' => __( 'Show Categories on Project List', 'lsvrtheme' ),
				'subtitle' => __( 'It applies to default service list page (archive page) and project category page.', 'lsvrtheme' ),
                'default' => 1,
			),

			// CATEGORIES POSITION
            array(
                'id' => 'project_list_categories_position',
				'type' => 'button_set',
				'title' => __( 'Position of Category List', 'lsvrtheme' ),
				'options' => array( 'left' => __( 'Left', 'lsvrtheme' ), 'right' => __( 'Right', 'lsvrtheme' ) ),
                'default' => 'left',
				'required'  => array( 'project_list_categories_enable', "=", 1 ),
			),

            // PROJECTS PER PAGE
            array(
				'id' => 'project_list_items_per_page',
				'type' => 'slider',
				'title' => __( 'Number of Projects Per Page', 'lsvrtheme' ),
				'default' => '6',
                'min' => '1',
                'step' => '1',
                'max' => '50',
			),

            // PROJECTS PER ROW
            array(
				'id' => 'project_list_items_per_row',
				'type' => 'slider',
				'title' => __( 'Number of Projects Per Row', 'lsvrtheme' ),
				'default' => '2',
                'min' => '1',
                'step' => '1',
                'max' => '4',
			),

            // PROJECT LIST EXCERPT ENABLE
            array(
				'id' => 'project_list_excerpt_enable',
				'type' => 'switch',
				'title' => __( 'Show Excerpt', 'lsvrtheme' ),
				'subtitle' => __( 'It applies to default project list page (archive page) and project category page.', 'lsvrtheme' ),
				'default' => 1,
			),

            // PROJECT LIST MORE LINK ENABLE
            array(
				'id' => 'project_list_more_enable',
				'type' => 'switch',
				'title' => __( 'Show "More" Link', 'lsvrtheme' ),
				'subtitle' => __( 'It applies to default project list page (archive page) and project category page.', 'lsvrtheme' ),
				'default' => 1,
			),

			array(
				'id'   => 'projects_divider_30',
				'type' => 'divide'
			),

			// ENABLE CATEGORIES ON DETAIL
            array(
                'id' => 'project_detail_categories_enable',
				'type' => 'switch',
				'title' => __( 'Show Project Categories on Project Detail', 'lsvrtheme' ),
				'subtitle' => __( 'It will display the list of categories of currently viewed project (NOT list of all categories as on project list).', 'lsvrtheme' ),
                'default' => 1,
			),

			// ENABLE NAVIGATION ON DETAIL
            array(
                'id' => 'project_detail_navigation',
				'type' => 'switch',
				'title' => __( 'Show Navigation on Project Detail', 'lsvrtheme' ),
				'subtitle' => __( 'Show links to next / previous project', 'lsvrtheme' ),
                'default' => 1,
			),

		)
    );

    /* -------------------------------------------------------------------------
        BLOG
    ------------------------------------------------------------------------- */

	$this->sections[] = array(
        'title' => __( 'Blog (Posts)', 'lsvrtheme' ),
		'icon' => 'el-icon-pencil',
        'fields' => array(

			// TOP INFO
			array(
				'id' => 'blog_top_info',
				'type' => 'info',
				'desc' => __( '<strong>Don\'t forget to create a standard page</strong> which will be used as a base for blog pages. Then go to <strong>Settings / Reading</strong>, under <strong>Front page displays</strong> choose <strong>A static page (select below)</strong> and select this newly created page as <strong>Posts page</strong>. Page settings and title of this page will be used for all blog pages.', 'lsvrtheme' ),
            ),

			// SIDEBAR ENABLE
            array(
                'id' => 'blog_sidebar_enable',
				'type' => 'switch',
				'title' => __( 'Show Sidebar on Blog Pages', 'lsvrtheme' ),
				'subtitle' => __( 'Sidebar widgets can be customized under <strong>Appearance / Widgets</strong>. Don\'t forget to create a blog page first, see info above. You will be able to set sidebar position (and many other settings) under <strong>Page Settings</strong> of that page.', 'lsvrtheme' ),
                'default' => 1,
			),

			array(
				'id'   => 'blog_divider_10',
				'type' => 'divide'
			),

			// BLOG LIST LAYOUT
            array(
                'id' => 'blog_list_layout',
				'type' => 'button_set',
				'title' => __( 'Blog List Layout', 'lsvrtheme' ),
				'options' => array( 'default' => __( 'Standard', 'lsvrtheme' ), 'masonry' => __( 'Masonry', 'lsvrtheme' ) ),
                'default' => 'default',
			),

			// CATEGORIES ENABLE
            array(
                'id' => 'blog_categories_enable',
				'type' => 'switch',
				'title' => __( 'Shop Post Categories', 'lsvrtheme' ),
                'default' => 1,
			),

			// CROP EXCERPT
            array(
                'id' => 'blog_list_crop_excerpt',
				'type' => 'switch',
				'title' => __( 'Crop Post Excerpt on Blog List', 'lsvrtheme' ),
                'default' => 0,
			),

			// SHOW READ MORE BUTTON
            array(
                'id' => 'blog_list_more_enable',
				'type' => 'switch',
				'title' => __( 'Show "More" Button', 'lsvrtheme' ),
				'subtitle' => __( 'It will be displayed only for posts with defined excerpt.', 'lsvrtheme' ),
                'default' => 1,
			),

			// READ MORE LABEL
            array(
                'id' => 'blog_list_more_label',
				'type' => 'text',
				'title' => __( '"More" Button Label', 'lsvrtheme' ),
                'default' => __( 'Read More', 'lsvrtheme' ),
				'required'  => array( 'blog_list_more_enable', "=", 1 ),
			),

			array(
				'id'   => 'blog_divider_20',
				'type' => 'divide'
			),

			// ENABLE POST NAVIGATION
            array(
                'id' => 'blog_detail_tags_enable',
				'type' => 'switch',
				'title' => __( 'Show Post Tags on Blog Detail', 'lsvrtheme' ),
                'default' => 1,
			),

			// ENABLE POST NAVIGATION
            array(
                'id' => 'blog_detail_navigation_enable',
				'type' => 'switch',
				'title' => __( 'Show Navigation on Blog Detail', 'lsvrtheme' ),
				'subtitle' => __( 'Show links to next / previous post.', 'lsvrtheme' ),
                'default' => 1,
			),

			// ENABLE AUTHOR BIO IN DETAIL
            array(
                'id' => 'blog_detail_author_bio_enable',
				'type' => 'switch',
				'title' => __( 'Show Author Bio in Blog Detail', 'lsvrtheme' ),
				'subtitle' => __( 'Bio can be edited under <strong>Users</strong>', 'lsvrtheme' ),
                'default' => 0,
			),


		)
    );

    /* -------------------------------------------------------------------------
        SIDEBARS
    ------------------------------------------------------------------------- */

	$this->sections[] = array(
        'title' => __( 'Sidebars', 'lsvrtheme' ),
		'icon' => 'el-icon-puzzle',
        'fields' => array(

			// INFO
			array(
				'id' => 'sidebars_info',
				'type' => 'info',
				'desc' => __( 'This theme supports <strong>up to 10 custom sidebars</strong>. Any of those sidebars (including Page Sidebar) can be assigned to any page. To use a custom sidebar you need to enable it first. Then go to "Appearance / Widgets" and insert any number of widgets to it. The final step is to assign your new sidebar to a page under "Page Settings / Sidebar / Select Sidebar" when editing a page.', 'lsvrtheme' ),
            ),

			// ENABLE SIDEBAR 1
            array(
                'id' => 'sidebars_sidebar1_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 1', 'lsvrtheme' ),
                'default' => 1
			),

			// ENABLE SIDEBAR 2
            array(
                'id' => 'sidebars_sidebar2_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 2', 'lsvrtheme' ),
                'default' => 0
			),

			// ENABLE SIDEBAR 3
            array(
                'id' => 'sidebars_sidebar3_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 3', 'lsvrtheme' ),
                'default' => 0
			),

			// ENABLE SIDEBAR 4
            array(
                'id' => 'sidebars_sidebar4_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 4', 'lsvrtheme' ),
                'default' => 0
			),

			// ENABLE SIDEBAR 5
            array(
                'id' => 'sidebars_sidebar5_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 5', 'lsvrtheme' ),
                'default' => 0
			),

			// ENABLE SIDEBAR 6
            array(
                'id' => 'sidebars_sidebar6_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 6', 'lsvrtheme' ),
                'default' => 0
			),

			// ENABLE SIDEBAR 7
            array(
                'id' => 'sidebars_sidebar7_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 7', 'lsvrtheme' ),
                'default' => 0
			),

			// ENABLE SIDEBAR 8
            array(
                'id' => 'sidebars_sidebar8_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 8', 'lsvrtheme' ),
                'default' => 0
			),

			// ENABLE SIDEBAR 9
            array(
                'id' => 'sidebars_sidebar9_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 9', 'lsvrtheme' ),
                'default' => 0
			),

			// ENABLE SIDEBAR 10
            array(
                'id' => 'sidebars_sidebar10_enable',
				'type' => 'switch',
				'title' => __( 'Enable Sidebar 10', 'lsvrtheme' ),
                'default' => 0
			),

		)
    );

    /* -------------------------------------------------------------------------
        PAGE 404
    ------------------------------------------------------------------------- */

	$this->sections[] = array(
        'title' => __( 'Page 404', 'lsvrtheme' ),
		'icon' => 'el-icon-minus-sign',
        'fields' => array(

			// PAGE TITLE
            array(
                'id' => 'page404_title',
				'type' => 'text',
				'title' => __( 'Title', 'lsvrtheme' ),
                'default' => __( '<strong>404</strong><br>Page Not Found', 'lsvrtheme' ),
			),

			// PAGE SUBTITLE
            array(
                'id' => 'page404_subtitle',
				'type' => 'text',
				'title' => __( 'Message', 'lsvrtheme' ),
                'default' => __( 'The page you are looking for is no longer available or has been moved.', 'lsvrtheme' ),
			),

			// ENABLE RECENT POSTS
            array(
                'id' => 'page404_enable_posts',
				'type' => 'switch',
				'title' => __( 'Show Recent Posts', 'lsvrtheme' ),
                'default' => 1,
			),

			// ENABLE SEARCH
            array(
                'id' => 'page404_enable_search',
				'type' => 'switch',
				'title' => __( 'Show Search Form', 'lsvrtheme' ),
                'default' => 1,
			),

		)
    );

    /* -------------------------------------------------------------------------
        MISC
    ------------------------------------------------------------------------- */

	$this->sections[] = array(
        'title' => __( 'Misc', 'lsvrtheme' ),
		'icon' => 'el-icon-cog',
        'fields' => array(

			// STANDARD PAGINATION
            array(
                'id' => 'pagination_default_enable',
				'type' => 'switch',
				'title' => __( 'Enable Standard WordPress Pagination', 'lsvrtheme' ),
				'subtitle' => __( 'If you are having any problems using pagination (for blog, projects etc.), enable this.', 'lsvrtheme' ),
                'default' => 0,
			),

		)
    );

	$this->sections[] = array(
		'type' => 'divide',
	);

    /* -------------------------------------------------------------------------
        CUSTOM CSS
    ------------------------------------------------------------------------- */

    $this->sections[] = array(
        'title' => __( 'Custom CSS/JS', 'lsvrtheme' ),
		'icon' => 'el-icon-cogs',
        'fields' => array(

			// CSS
			array(
				'id'        => 'custom_css_code',
				'type'      => 'ace_editor',
				'title'     => __( 'CSS Code', 'lsvrtheme' ),
				'subtitle'  => __( 'Paste your CSS code here.', 'lsvrtheme' ),
				'mode'      => 'css',
				'theme'     => 'chrome',
			),

			// JS
			array(
				'id'        => 'custom_js_code',
				'type'      => 'ace_editor',
				'title'     => __( 'JS Code', 'lsvrtheme' ),
				'subtitle'  => __( 'Paste your JS code here.', 'lsvrtheme' ),
				'mode'      => 'javascript',
				'theme'     => 'chrome',
			),

            // custom code
            array(
                'id' => 'custom_any_code',
				'type' => 'textarea',
				'title' => __( 'Any Custom Code', 'lsvrtheme' ),
                'subtitle' => __( 'This field can be used for adding any code which contains &lt;script&gt;&lt;/script&gt; tags. For example Google Analytics code.', 'lsvrtheme' )
			)

        )
    );

// SECTIONS END

            $theme_info  = '<div class="redux-framework-section-desc">';
            $theme_info .= '<p class="redux-framework-theme-data description theme-uri">' . __('<strong>Theme URL:</strong> ', 'lsvrtheme') . '<a href="' . $this->theme->get('ThemeURI') . '" target="_blank">' . $this->theme->get('ThemeURI') . '</a></p>';
            $theme_info .= '<p class="redux-framework-theme-data description theme-author">' . __('<strong>Author:</strong> ', 'lsvrtheme') . $this->theme->get('Author') . '</p>';
            $theme_info .= '<p class="redux-framework-theme-data description theme-version">' . __('<strong>Version:</strong> ', 'lsvrtheme') . $this->theme->get('Version') . '</p>';
            $theme_info .= '<p class="redux-framework-theme-data description theme-description">' . $this->theme->get('Description') . '</p>';
            $tabs = $this->theme->get('Tags');
            if (!empty($tabs)) {
                $theme_info .= '<p class="redux-framework-theme-data description theme-tags">' . __('<strong>Tags:</strong> ', 'lsvrtheme') . implode(', ', $tabs) . '</p>';
            }
            $theme_info .= '</div>';

            if (file_exists(dirname(__FILE__) . '/../README.md')) {
                $this->sections['theme_docs'] = array(
                    'icon'      => 'el-icon-list-alt',
                    'title'     => __('Documentation', 'lsvrtheme'),
                    'fields'    => array(
                        array(
                            'id'        => '17',
                            'type'      => 'raw',
                            'markdown'  => true,
                            'content'   => file_get_contents(dirname(__FILE__) . '/../README.md')
                        ),
                    ),
                );
            }

            $this->sections[] = array(
                'title'     => __('Import / Export', 'lsvrtheme'),
                'desc'      => __('Import and Export your Redux Framework settings from file, text or URL.', 'lsvrtheme'),
                'icon'      => 'el-icon-refresh',
                'fields'    => array(
                    array(
                        'id'            => 'opt-import-export',
                        'type'          => 'import_export',
                        'title'         => 'Import Export',
                        'subtitle'      => 'Save and restore your Redux options',
                        'full_width'    => false,
                    ),
                ),
            );

            $this->sections[] = array(
                'type' => 'divide',
            );

            $this->sections[] = array(
                'icon'      => 'el-icon-info-sign',
                'title'     => __('Theme Information', 'lsvrtheme'),
                //'desc'      => __('<p class="description">This is the Description. Again HTML is allowed</p>', 'lsvrtheme'),
                'fields'    => array(
                    array(
                        'id'        => 'opt-raw-info',
                        'type'      => 'raw',
                        'content'   => $item_info,
                    )
                ),
            );

            if (file_exists(trailingslashit(dirname(__FILE__)) . 'README.html')) {
                $tabs['docs'] = array(
                    'icon'      => 'el-icon-book',
                    'title'     => __('Documentation', 'lsvrtheme'),
                    'content'   => nl2br(file_get_contents(trailingslashit(dirname(__FILE__)) . 'README.html'))
                );
            }
        }

        public function setHelpTabs() {

            // Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.
            $this->args['help_tabs'][] = array(
                'id'        => 'redux-help-tab-1',
                'title'     => __('Theme Information 1', 'lsvrtheme'),
                'content'   => __('<p>This is the tab content, HTML is allowed.</p>', 'lsvrtheme')
            );

            $this->args['help_tabs'][] = array(
                'id'        => 'redux-help-tab-2',
                'title'     => __('Theme Information 2', 'lsvrtheme'),
                'content'   => __('<p>This is the tab content, HTML is allowed.</p>', 'lsvrtheme')
            );

            // Set the help sidebar
            $this->args['help_sidebar'] = __('<p>This is the sidebar content, HTML is allowed.</p>', 'lsvrtheme');
        }

        /**

          All the possible arguments for Redux.
          For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments

         * */
        public function setArguments() {

            $theme = wp_get_theme(); // For use with some settings. Not necessary.

            $this->args = array(
                // TYPICAL -> Change these values as you need/desire
                'opt_name'          => 'theme_options',            // This is where your data is stored in the database and also becomes your global variable name.
                'display_name'      => $theme->get('Name'),     // Name that appears at the top of your panel
                'display_version'   => $theme->get('Version'),  // Version that appears at the top of your panel
                'menu_type'         => 'menu',                  //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
                'allow_sub_menu'    => true,                    // Show the sections below the admin menu item or not
                'menu_title'        => __('Theme Options', 'lsvrtheme'),
                'page_title'        => __('Theme Options', 'lsvrtheme'),

                // You will need to generate a Google API key to use this feature.
                // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
                'google_api_key' => 'AIzaSyDCOyIiq-EGJPTCJbrg2NeFDGd59ouIL3w', // Must be defined to add google fonts to the typography module

                'async_typography'  => false,                    // Use a asynchronous font on the front end or font string
                'admin_bar'         => true,                    // Show the panel pages on the admin bar
                'global_variable'   => '',                      // Set a different name for your global variable other than the opt_name
                'dev_mode'          => false,                    // Show the time the page took to load, etc
                'customizer'        => true,                    // Enable basic customizer support
                //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
                //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

                // OPTIONAL -> Give you extra features
                'page_priority'     => null,                    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
                'page_parent'       => 'themes.php',            // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
                'page_permissions'  => 'manage_options',        // Permissions needed to access the options panel.
                'menu_icon'         => '',                      // Specify a custom URL to an icon
                'last_tab'          => '',                      // Force your panel to always open to a specific tab (by id)
                'page_icon'         => 'icon-themes',           // Icon displayed in the admin panel next to your menu_title
                'page_slug'         => '_options',              // Page slug used to denote the panel
                'save_defaults'     => true,                    // On load save the defaults to DB before user clicks save or not
                'default_show'      => false,                   // If true, shows the default value next to each field that is not the default value.
                'default_mark'      => '',                      // What to print by the field's title if the value shown is default. Suggested: *
                'show_import_export' => true,                   // Shows the Import/Export panel when not used as a field.

                // CAREFUL -> These options are for advanced use only
                'transient_time'    => 60 * MINUTE_IN_SECONDS,
                'output'            => true,                    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
                'output_tag'        => true,                    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
                // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

                // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
                'database'              => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
                'system_info'           => false, // REMOVE

                // HINTS
                'hints' => array(
                    'icon'          => 'icon-question-sign',
                    'icon_position' => 'right',
                    'icon_color'    => 'lightgray',
                    'icon_size'     => 'normal',
                    'tip_style'     => array(
                        'color'         => 'light',
                        'shadow'        => true,
                        'rounded'       => false,
                        'style'         => '',
                    ),
                    'tip_position'  => array(
                        'my' => 'top left',
                        'at' => 'bottom right',
                    ),
                    'tip_effect'    => array(
                        'show'          => array(
                            'effect'        => 'slide',
                            'duration'      => '500',
                            'event'         => 'mouseover',
                        ),
                        'hide'      => array(
                            'effect'    => 'slide',
                            'duration'  => '500',
                            'event'     => 'click mouseleave',
                        ),
                    ),
                )
            );


            // Panel Intro text -> before the form
            if (!isset($this->args['global_variable']) || $this->args['global_variable'] !== false) {
                if (!empty($this->args['global_variable'])) {
                    $v = $this->args['global_variable'];
                } else {
                    $v = str_replace('-', '_', $this->args['opt_name']);
                }
                //$this->args['intro_text'] = sprintf(__('<p>Did you know that Redux sets a global variable for you? To access any of your saved options from within your code you can use your global variable: <strong>$%1$s</strong></p>', 'lsvrtheme'), $v);
            } else {
                //$this->args['intro_text'] = __('<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'lsvrtheme');
            }

            // Add content after the form.
            //$this->args['footer_text'] = __('<p>This text is displayed below the options panel. It isn\'t required, but more info is always better! The footer_text field accepts all HTML.</p>', 'lsvrtheme');
        }

    }

    global $reduxConfig;
    $reduxConfig = new Redux_Framework_Lsvrtheme_config();
}

/**
  Custom function for the callback referenced above
 */
if (!function_exists('redux_my_custom_field')):
    function redux_my_custom_field($field, $value) {
        print_r($field);
        echo '<br/>';
        print_r($value);
    }
endif;

/**
  Custom function for the callback validation referenced above
 * */
if (!function_exists('redux_validate_callback_function')):
    function redux_validate_callback_function($field, $value, $existing_value) {
        $error = false;
        $value = 'just testing';

        /*
          do your validation

          if(something) {
            $value = $value;
          } elseif(something else) {
            $error = true;
            $value = $existing_value;
            $field['msg'] = 'your custom error message';
          }
         */

        $return['value'] = $value;
        if ($error == true) {
            $return['error'] = $field;
        }
        return $return;
    }
endif;
