<?php get_header(); ?>

<?php $blog_page_id = get_option( 'page_for_posts' ); ?>
<?php $blog_page_id = $blog_page_id && $blog_page_id > 0 ? $blog_page_id : false; ?>

<!-- CORE : begin -->
<div id="core" <?php post_class(); ?>>

	<?php // PAGE HEADER
	get_template_part( 'components/page-header' ); ?>

	<div class="container">

		<?php if ( lsvr_get_field( 'blog_sidebar_enable', true, true ) ) : ?>
		<div class="row">
			<div class="col-md-9<?php if ( $blog_page_id && get_post_meta( $blog_page_id, 'meta_sidebar_position', true ) === 'left' ) : ?> col-md-push-3<?php endif; ?>">
		<?php endif; ?>

		<!-- PAGE CONTENT : begin -->
		<div id="page-content">

			<?php if ( have_posts() ) : ?>

				<?php if ( is_single() ) : ?>

					<!-- BLOG DETAIL : begin -->
					<div class="blog-detail-page">
					<?php while ( have_posts() ) : the_post(); ?>

						<?php get_template_part( 'article' ); ?>

					<?php endwhile; ?>
					</div>
					<!-- BLOG DETAIL : end -->

				<?php else : ?>

					<!-- BLOG LIST : begin -->
					<div class="blog-list-page">
						<div class="c-article-list<?php if ( lsvr_get_field( 'blog_list_layout', 'default' ) === 'masonry' ) : ?> m-masonry<?php endif; ?>">
						<?php while ( have_posts() ) : the_post(); ?>

							<?php get_template_part( 'article' ); ?>

						<?php endwhile; ?>
						</div>
					</div>
					<!-- BLOG LIST : end -->

					<?php // PAGINATION
					get_template_part( 'components/pagination' ); ?>

				<?php endif; ?>

			<?php else : ?>

				<div class="various-content">
					<p class="c-alert-message m-info max-width-400 margin-sides-auto"><i class="ico fa fa-info-circle"></i><?php _e( 'No posts found!', 'lsvrtheme' ); ?></p>
				</div>

			<?php endif; ?>

		</div>
		<!-- PAGE CONTENT : end -->

		<?php if ( lsvr_get_field( 'blog_sidebar_enable', true, true ) ) : ?>
			</div>
			<div class="col-md-3<?php if ( $blog_page_id && get_post_meta( $blog_page_id, 'meta_sidebar_position', true ) === 'left' ) : ?> col-md-pull-9<?php endif; ?>">

				<?php // SIDEBAR
				get_sidebar(); // load sidebar.php ?>

			</div>
		</div>
		<?php endif; ?>

	</div>

</div>
<!-- CORE : end -->

<?php get_footer(); ?>