<?php get_header();?>

<?php while ( have_posts() ) : the_post(); ?>

	<!-- CORE : begin -->
	<div id="core" <?php post_class(); ?>>

		<?php // PAGE HEADER
		get_template_part( 'components/page-header' ); ?>

		<div class="container">

			<!-- PAGE CONTENT : begin -->
			<div id="page-content">

				<!-- PROJECT DETAIL : begin -->
				<div class="project-detail">

					<?php // GENERATE MEDIA
					$project_media_html = ''; ?>
					<?php // IMAGE GALLERY
					if ( lsvr_get_field( 'meta_project_gallery' ) !== '' ) : ?>
						<?php $gallery_image_ids = explode( ',', lsvr_get_field( 'meta_project_gallery' ) ); ?>
						<?php if ( is_array( $gallery_image_ids ) ) : ?>
							<?php foreach( $gallery_image_ids as $k => $v ) : ?>
								<?php $image_data = lsvr_get_image_data( $v ); ?>
								<?php if ( $image_data ) : ?>
									<?php $project_media_html .= '<li class="project-image">'; ?>
									<?php if ( lsvr_get_field( 'meta_project_gallery_lightbox', true, true ) ) : ?>
										<?php $project_media_html .= '<a href="' . esc_url( $image_data['full'] ) . '" title="' . esc_attr( $image_data['caption'] ) . '" class="lightbox">'; ?>
									<?php endif; ?>

									<?php if ( ( lsvr_get_field( 'meta_project_media_position', 'top' ) === 'top'
										|| lsvr_get_field( 'meta_project_media_position', 'left' ) === 'bottom' )
										&& intval( lsvr_get_field( 'meta_project_images_per_row', '1' ) ) === 1 ) : ?>
										<?php $project_media_html .= '<img src="' . esc_url( $image_data['full'] ) . '" alt="' . esc_attr( $image_data['alt'] ) . '">'; ?>
									<?php elseif ( intval( lsvr_get_field( 'meta_project_images_per_row', '1' ) ) > 3 ) : ?>
										<?php $project_media_html .= '<img src="' . esc_url( $image_data['medium'] ) . '" alt="' . esc_attr( $image_data['alt'] ) . '">'; ?>
									<?php else : ?>
										<?php $project_media_html .= '<img src="' . esc_url( $image_data['large'] ) . '" alt="' . esc_attr( $image_data['alt'] ) . '">'; ?>
									<?php endif; ?>

									<?php if ( lsvr_get_field( 'meta_project_gallery_lightbox', true, true ) ) : ?>
										<?php $project_media_html .= '</a>'; ?>
									<?php endif; ?>
									<?php $project_media_html .= '</li>'; ?>
								<?php endif; ?>
							<?php endforeach; ?>
						<?php endif; ?>
						<?php if ( $project_media_html !== '' ) : ?>
							<?php $project_media_html = '<ul class="project-images m-' . esc_attr( lsvr_get_field( 'meta_project_images_per_row', '1' ) ) . '-per-row">' . $project_media_html . '</ul>'; ?>
						<?php endif; ?>
					<?php endif; ?>

					<?php // GENERATE INFO HTML
					$project_info_html = ''; ?>
					<?php for ( $i = 1; $i <= 4; $i++ ) : ?>
						<?php if ( lsvr_get_field( 'meta_project_info' . $i . '_title' ) !== '' && lsvr_get_field( 'meta_project_info' . $i . '_text' ) !== '' ) : ?>
							<?php $project_info_html .= '<dt>' . lsvr_get_field( 'meta_project_info' . $i . '_title' ) . '</dt><dd>' . lsvr_get_field( 'meta_project_info' . $i . '_text' ) . '</dd>'; ?>
						<?php endif; ?>
					<?php endfor; ?>
					<?php if ( $project_info_html !== '' ): ?>
						<?php $project_info_html = '<dl class="project-info">' . $project_info_html . '</dl>'; ?>
					<?php endif; ?>

					<?php // GENERATE PROJECT CATEGORIES HTML
					$project_cats_arr = wp_get_post_terms( get_the_id(), 'lsvrprojectcat' ); ?>
					<?php $project_cats_html = ''; ?>
					<?php foreach( $project_cats_arr as $value ) : ?>
						<?php $project_cats_html .= '<li><a href="' . get_term_link( $value, 'lsvrprojectcat' ) . '">' . $value->name . '</a></li>'; ?>
					<?php endforeach; ?>
					<?php if ( lsvr_get_field( 'project_detail_categories_enable', true, true ) && $project_cats_html !== '' ) : ?>
						<?php $project_cats_html = '<div class="project-folders"><dl><dt>' . __( 'Categories', 'lsvrtheme' ) . '</dt><dd><ul class="project-categories">' . $project_cats_html . '</ul></dd></dl></div>'; ?>
					<?php endif; ?>

					<?php // GENERATE PROJECT NAVIGATION
					$project_nav_html = ''; ?>
					<?php if ( lsvr_get_field( 'project_detail_navigation', true, true ) ) : ?>
					<?php $project_nav_html .= '<hr class="c-separator"><ul class="project-navigation">'; ?>

						<?php $prev_project = get_adjacent_post( false, '', true ); ?>
						<?php if ( ! empty( $prev_project ) ): ?>
							<?php $project_nav_html .= '<li class="prev"><a href="' . get_permalink( $prev_project->ID ) . '">' . $prev_project->post_title . '</a> <i class="fa fa-angle-right"></i></li>'; ?>
						<?php endif; ?>

						<?php $next_project = get_adjacent_post( false, '', false ); ?>
						<?php if ( ! empty( $next_project ) ): ?>
							<?php $project_nav_html .= '<li class="next"><i class="fa fa-angle-left"></i> <a href="' . get_permalink( $next_project->ID ) . '">' . $next_project->post_title . '</a></li>'; ?>
						<?php endif; ?>

					<?php $project_nav_html .= '</ul>'; ?>
					<?php endif; ?>

					<?php // MEDIA ON TOP
					if ( lsvr_get_field( 'meta_project_media_position', 'top' ) === 'top' ) : ?>

						<?php echo $project_media_html; ?>

						<?php if ( $project_info_html !== '' ) : ?>
						<div class="row">
							<div class="col-md-3">
								<?php echo $project_info_html; ?>
								<?php echo $project_cats_html; ?>
							</div>
							<div class="col-md-9">
						<?php endif; ?>

						<div class="project-description">
							<?php the_content(); ?>
						</div>

						<?php if ( $project_info_html !== '' ) : ?>
							</div>
						</div>
						<?php endif; ?>
						<?php echo $project_nav_html; ?>

					<?php // MEDIA ON BOTTOM
					elseif ( lsvr_get_field( 'meta_project_media_position', 'top' ) === 'bottom' ) : ?>

						<div class="container">

							<?php if ( $project_info_html !== '' ) : ?>
							<div class="row">
								<div class="col-md-3">
									<?php echo $project_info_html; ?>
									<?php echo $project_cats_html; ?>
								</div>
								<div class="col-md-9">
							<?php endif; ?>

							<div class="project-description">
								<?php the_content(); ?>
							</div>

							<?php if ( $project_info_html !== '' ) : ?>
								</div>
							</div>
							<?php endif; ?>

							<hr class="c-separator m-size-small m-transparent">

							<?php echo $project_media_html; ?>
							<?php echo $project_nav_html; ?>

						</div>

					<?php // MEDIA ON LEFT
					elseif ( lsvr_get_field( 'meta_project_media_position', 'top' ) === 'left' ) : ?>

						<div class="container">
							<div class="row">
								<div class="col-md-8">
									<?php echo $project_media_html; ?>
								</div>
								<div class="col-md-4">
									<div class="project-description">
										<?php the_content(); ?>
									</div>
									<?php echo $project_info_html; ?>
									<?php echo $project_cats_html; ?>
								</div>
							</div>
							<?php echo $project_nav_html; ?>
						</div>

					<?php // MEDIA ON RIGHT
					elseif ( lsvr_get_field( 'meta_project_media_position', 'top' ) === 'right' ) : ?>

						<div class="container">
							<div class="row">
								<div class="col-md-8 col-md-push-4">
									<?php echo $project_media_html; ?>
								</div>
								<div class="col-md-4 col-md-pull-8">
									<div class="project-description">
										<?php the_content(); ?>
									</div>
									<?php echo $project_info_html; ?>
									<?php echo $project_cats_html; ?>
								</div>
							</div>
							<?php echo $project_nav_html; ?>
						</div>

					<?php endif; ?>

				</div>
				<!-- PROJECT DETAIL : end -->

			</div>
			<!-- PAGE CONTENT : end -->

		</div>

	</div>
	<!-- CORE : end -->

<?php endwhile; ?>

<?php get_footer(); ?>