<?php get_header();?>

<?php while ( have_posts() ) : the_post(); ?>

	<!-- CORE : begin -->
	<div id="core" <?php post_class(); ?>>

		<?php // PAGE HEADER
		get_template_part( 'components/page-header' ); ?>

		<div class="container">

			<?php if ( lsvr_get_field( 'service_detail_sidebar_enable', true, true ) ) : ?>
			<div class="row">
				<div class="col-md-9<?php if ( lsvr_get_field( 'service_detail_sidebar_position', 'left' ) === 'left' ) : ?> col-md-push-3<?php endif; ?>">
			<?php endif; ?>

			<!-- PAGE CONTENT : begin -->
			<div id="page-content">

				<!-- SERVICE DETAIL : begin -->
				<div class="service-detail">

					<?php the_content(); ?>

				</div>
				<!-- SERVICE DETAIL : end -->

			</div>
			<!-- PAGE CONTENT : end -->

			<?php if ( lsvr_get_field( 'service_detail_sidebar_enable', true, true ) ) : ?>
				</div>
				<div class="col-md-3<?php if ( lsvr_get_field( 'service_detail_sidebar_position', 'left' ) === 'left' ) : ?> col-md-pull-9<?php endif; ?>">

					<?php if ( class_exists( 'Lsvr_Service_List' ) ) : ?>
					<!-- SIDEBAR : begin -->
					<hr class="c-separator m-size-medium m-type-2 hidden-lg hidden-md">
					<aside id="sidebar">
						<div class="widget-list">

							<?php // SERVICE LIST WIDGET
							if ( class_exists( 'Lsvr_Service_List' ) ) {
								the_widget( 'Lsvr_Service_List',
								array( 'title' => lsvr_get_field( 'services_page_title', __( 'Services', 'lsvrtheme' ) ) ),
								array( 'before_widget' => '<div class="widget service-list"><div class="widget-inner">',
									'after_widget'  => '</div></div>',
									'before_title'  => '<h3 class="widget-title">',
									'after_title'   => '</h3>' )
							); } ?>

						</div>
					</aside>
					<!-- SIDEBAR : end -->
					<?php endif; ?>

				</div>
			</div>
			<?php endif; ?>

		</div>

	</div>
	<!-- CORE : end -->

<?php endwhile; ?>

<?php get_footer(); ?>