<?php add_action( 'after_setup_theme', 'lsvr_bluecollar_child_theme_setup' );
if ( ! function_exists( 'lsvr_bluecollar_child_theme_setup' ) ) {
    function lsvr_bluecollar_child_theme_setup() {

        /**
         * Load parent and child style.css
         *
         * @link https://codex.wordpress.org/Child_Themes#How_to_Create_a_Child_Theme
         */
        add_action( 'wp_enqueue_scripts', 'lsvr_bluecollar_child_enqueue_parent_styles' );
        if ( ! function_exists( 'lsvr_bluecollar_child_enqueue_parent_styles' ) ) {
            function lsvr_bluecollar_child_enqueue_parent_styles() {

                // Load parent theme's style.css
                $parent_version = wp_get_theme( 'bluecollar' );
                $parent_version = $parent_version->Version;
                wp_enqueue_style( 'lsvr-bluecollar-main-style', get_template_directory_uri() . '/style.css', array(), $parent_version );

                // Load child theme's style.css
                $child_version = wp_get_theme();
                $child_version = $child_version->Version;
                wp_enqueue_style( 'lsvr-bluecollar-child-style', get_stylesheet_directory_uri() . '/style.css', array( 'lsvr-bluecollar-general-style' ), $child_version );

                // Load RTL
                if ( is_rtl() ) {
                    wp_enqueue_style( 'lsvr-bluecollar-rtl-style', get_template_directory_uri() . '/rtl.css', array( 'lsvr-bluecollar-general-style' ), $parent_version );
                }

            }
        }

        /* Load editor style */
        add_action( 'enqueue_block_editor_assets', 'lsvr_bluecollar_child_load_editor_assets' );
        if ( ! function_exists( 'lsvr_bluecollar_child_load_editor_assets' ) ) {
            function lsvr_bluecollar_child_load_editor_assets() {

                $child_version = wp_get_theme();
                $child_version = $child_version->Version;
                wp_enqueue_style( 'lsvr-bluecollar-child-editor-style', get_stylesheet_directory_uri() . '/editor-style.css', array(), $child_version );

            }
        }

        // Include file with hook examples
        //require_once( 'hook-examples.php' );

        /* Add your code after this comment */

    }
} ?>